/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.CollectionProperties;
import org.hibernate.hql.CollectionSubqueryFactory;
import org.hibernate.hql.NameGenerator;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.persister.collection.CollectionPropertyMapping;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FromElementType {
    private static final Logger log = LoggerFactory.getLogger((Class)FromElementType.class);
    private FromElement fromElement;
    private EntityType entityType;
    private EntityPersister persister;
    private QueryableCollection queryableCollection;
    private CollectionPropertyMapping collectionPropertyMapping;
    private JoinSequence joinSequence;
    private String collectionSuffix;

    public FromElementType(FromElement fromElement, EntityPersister persister, EntityType entityType) {
        this.fromElement = fromElement;
        this.persister = persister;
        this.entityType = entityType;
        if (persister != null) {
            fromElement.setText(((Queryable)persister).getTableName() + " " + this.getTableAlias());
        }
    }

    private String getTableAlias() {
        return this.fromElement.getTableAlias();
    }

    private String getCollectionTableAlias() {
        return this.fromElement.getCollectionTableAlias();
    }

    public String getCollectionSuffix() {
        return this.collectionSuffix;
    }

    public void setCollectionSuffix(String suffix) {
        this.collectionSuffix = suffix;
    }

    public EntityPersister getEntityPersister() {
        return this.persister;
    }

    public Type getDataType() {
        if (this.persister == null) {
            if (this.queryableCollection == null) {
                return null;
            }
            return this.queryableCollection.getType();
        }
        return this.entityType;
    }

    public Type getSelectType() {
        if (this.entityType == null) {
            return null;
        }
        boolean shallow = this.fromElement.getFromClause().getWalker().isShallowQuery();
        return TypeFactory.manyToOne(this.entityType.getAssociatedEntityName(), shallow);
    }

    public Queryable getQueryable() {
        return this.persister instanceof Queryable ? (Queryable)this.persister : null;
    }

    String renderScalarIdentifierSelect(int i) {
        this.checkInitialized();
        String[] cols = this.getPropertyMapping("id").toColumns(this.getTableAlias(), "id");
        StringBuffer buf = new StringBuffer();
        for (int j = 0; j < cols.length; ++j) {
            String column = cols[j];
            if (j > 0) {
                buf.append(", ");
            }
            buf.append(column).append(" as ").append(NameGenerator.scalarName(i, j));
        }
        return buf.toString();
    }

    String renderIdentifierSelect(int size, int k) {
        this.checkInitialized();
        if (this.fromElement.getFromClause().isSubQuery()) {
            String[] idColumnNames = this.persister != null ? ((Queryable)this.persister).getIdentifierColumnNames() : new String[]{};
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < idColumnNames.length; ++i) {
                buf.append(this.fromElement.getTableAlias()).append('.').append(idColumnNames[i]);
                if (i == idColumnNames.length - 1) continue;
                buf.append(", ");
            }
            return buf.toString();
        }
        if (this.persister == null) {
            throw new QueryException("not an entity");
        }
        String fragment = ((Queryable)this.persister).identifierSelectFragment(this.getTableAlias(), this.getSuffix(size, k));
        return FromElementType.trimLeadingCommaAndSpaces(fragment);
    }

    private String getSuffix(int size, int sequence) {
        return FromElementType.generateSuffix(size, sequence);
    }

    private static String generateSuffix(int size, int k) {
        String suffix = size == 1 ? "" : Integer.toString(k) + '_';
        return suffix;
    }

    private void checkInitialized() {
        this.fromElement.checkInitialized();
    }

    String renderPropertySelect(int size, int k, boolean allProperties) {
        this.checkInitialized();
        if (this.persister == null) {
            return "";
        }
        String fragment = ((Queryable)this.persister).propertySelectFragment(this.getTableAlias(), this.getSuffix(size, k), allProperties);
        return FromElementType.trimLeadingCommaAndSpaces(fragment);
    }

    String renderCollectionSelectFragment(int size, int k) {
        if (this.queryableCollection == null) {
            return "";
        }
        if (this.collectionSuffix == null) {
            this.collectionSuffix = FromElementType.generateSuffix(size, k);
        }
        String fragment = this.queryableCollection.selectFragment(this.getCollectionTableAlias(), this.collectionSuffix);
        return FromElementType.trimLeadingCommaAndSpaces(fragment);
    }

    public String renderValueCollectionSelectFragment(int size, int k) {
        if (this.queryableCollection == null) {
            return "";
        }
        if (this.collectionSuffix == null) {
            this.collectionSuffix = FromElementType.generateSuffix(size, k);
        }
        String fragment = this.queryableCollection.selectFragment(this.getTableAlias(), this.collectionSuffix);
        return FromElementType.trimLeadingCommaAndSpaces(fragment);
    }

    private static String trimLeadingCommaAndSpaces(String fragment) {
        if (fragment.length() > 0 && fragment.charAt(0) == ',') {
            fragment = fragment.substring(1);
        }
        fragment = fragment.trim();
        return fragment.trim();
    }

    public void setJoinSequence(JoinSequence joinSequence) {
        this.joinSequence = joinSequence;
    }

    public JoinSequence getJoinSequence() {
        if (this.joinSequence != null) {
            return this.joinSequence;
        }
        if (this.persister instanceof Joinable) {
            Joinable joinable = (Joinable)((Object)this.persister);
            return this.fromElement.getSessionFactoryHelper().createJoinSequence().setRoot(joinable, this.getTableAlias());
        }
        return null;
    }

    public void setQueryableCollection(QueryableCollection queryableCollection) {
        if (this.queryableCollection != null) {
            throw new IllegalStateException("QueryableCollection is already defined for " + this + "!");
        }
        this.queryableCollection = queryableCollection;
        if (!queryableCollection.isOneToMany()) {
            this.fromElement.setText(queryableCollection.getTableName() + " " + this.getTableAlias());
        }
    }

    public QueryableCollection getQueryableCollection() {
        return this.queryableCollection;
    }

    public Type getPropertyType(String propertyName, String propertyPath) {
        this.checkInitialized();
        Type type = null;
        if (this.persister != null && propertyName.equals(propertyPath) && propertyName.equals(this.persister.getIdentifierPropertyName())) {
            type = this.persister.getIdentifierType();
        } else {
            PropertyMapping mapping = this.getPropertyMapping(propertyName);
            type = mapping.toType(propertyPath);
        }
        if (type == null) {
            throw new MappingException("Property " + propertyName + " does not exist in " + (this.queryableCollection == null ? "class" : "collection") + " " + (this.queryableCollection == null ? this.fromElement.getClassName() : this.queryableCollection.getRole()));
        }
        return type;
    }

    String[] toColumns(String tableAlias, String path, boolean inSelect) {
        return this.toColumns(tableAlias, path, inSelect, false);
    }

    String[] toColumns(String tableAlias, String path, boolean inSelect, boolean forceAlias) {
        this.checkInitialized();
        PropertyMapping propertyMapping = this.getPropertyMapping(path);
        if (!inSelect && this.queryableCollection != null && CollectionProperties.isCollectionProperty(path)) {
            Map enabledFilters = this.fromElement.getWalker().getEnabledFilters();
            String subquery = CollectionSubqueryFactory.createCollectionSubquery(this.joinSequence, enabledFilters, propertyMapping.toColumns(tableAlias, path));
            if (log.isDebugEnabled()) {
                log.debug("toColumns(" + tableAlias + "," + path + ") : subquery = " + subquery);
            }
            return new String[]{"(" + subquery + ")"};
        }
        if (forceAlias) {
            return propertyMapping.toColumns(tableAlias, path);
        }
        if (this.fromElement.getWalker().getStatementType() == 45) {
            return propertyMapping.toColumns(tableAlias, path);
        }
        if (this.fromElement.getWalker().getCurrentClauseType() == 45) {
            return propertyMapping.toColumns(tableAlias, path);
        }
        if (this.fromElement.getWalker().isSubQuery()) {
            if (this.isCorrelation()) {
                if (this.isMultiTable()) {
                    return propertyMapping.toColumns(tableAlias, path);
                }
                return propertyMapping.toColumns(this.extractTableName(), path);
            }
            return propertyMapping.toColumns(tableAlias, path);
        }
        Object[] columns = propertyMapping.toColumns(path);
        log.trace("Using non-qualified column reference [" + path + " -> (" + ArrayHelper.toString(columns) + ")]");
        return columns;
    }

    private boolean isCorrelation() {
        FromClause top = this.fromElement.getWalker().getFinalFromClause();
        return this.fromElement.getFromClause() != this.fromElement.getWalker().getCurrentFromClause() && this.fromElement.getFromClause() == top;
    }

    private boolean isMultiTable() {
        return this.fromElement.getQueryable() != null && this.fromElement.getQueryable().isMultiTable();
    }

    private String extractTableName() {
        return this.fromElement.getQueryable().getTableName();
    }

    PropertyMapping getPropertyMapping(String propertyName) {
        this.checkInitialized();
        if (this.queryableCollection == null) {
            return (PropertyMapping)((Object)this.persister);
        }
        if (CollectionProperties.isCollectionProperty(propertyName)) {
            if (this.collectionPropertyMapping == null) {
                this.collectionPropertyMapping = new CollectionPropertyMapping(this.queryableCollection);
            }
            return this.collectionPropertyMapping;
        }
        if (this.queryableCollection.getElementType().isAnyType()) {
            return this.queryableCollection;
        }
        if (this.queryableCollection.getElementType().isComponentType() && propertyName.equals("id")) {
            return (PropertyMapping)((Object)this.queryableCollection.getOwnerEntityPersister());
        }
        return this.queryableCollection;
    }

    public boolean isCollectionOfValuesOrComponents() {
        if (this.persister == null) {
            if (this.queryableCollection == null) {
                return false;
            }
            return !this.queryableCollection.getElementType().isEntityType();
        }
        return false;
    }

    public boolean isEntity() {
        return this.persister != null;
    }
}

