/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.cfg.SearchConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchConfigurationFromHibernateCore
implements SearchConfiguration {
    private Configuration cfg;
    private ReflectionManager reflectionManager;

    public SearchConfigurationFromHibernateCore(Configuration cfg) {
        if (cfg == null) {
            throw new NullPointerException("Configuration is null");
        }
        this.cfg = cfg;
    }

    @Override
    public Iterator<Class<?>> getClassMappings() {
        return new ClassIterator(this.cfg.getClassMappings());
    }

    @Override
    public Class<?> getClassMapping(String name) {
        return this.cfg.getClassMapping(name).getMappedClass();
    }

    @Override
    public String getProperty(String propertyName) {
        return this.cfg.getProperty(propertyName);
    }

    @Override
    public Properties getProperties() {
        return this.cfg.getProperties();
    }

    @Override
    public ReflectionManager getReflectionManager() {
        if (this.reflectionManager == null) {
            try {
                this.reflectionManager = (ReflectionManager)this.cfg.getClass().getMethod("getReflectionManager", new Class[0]).invoke((Object)this.cfg, new Object[0]);
            }
            catch (Exception e) {
                this.reflectionManager = new JavaReflectionManager();
            }
        }
        return this.reflectionManager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassIterator
    implements Iterator<Class<?>> {
        private Iterator hibernatePersistentClassIterator;
        private Class<?> future;
        private Class<?> current;

        private ClassIterator(Iterator hibernatePersistentClassIterator) {
            this.hibernatePersistentClassIterator = hibernatePersistentClassIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.future != null) {
                return true;
            }
            do {
                if (!this.hibernatePersistentClassIterator.hasNext()) {
                    this.future = null;
                    return false;
                }
                PersistentClass pc = (PersistentClass)this.hibernatePersistentClassIterator.next();
                this.future = pc.getMappedClass();
            } while (this.future == null);
            return true;
        }

        @Override
        public Class<?> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Class<?> result = this.future;
            this.future = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot modify Hibenrate Core metadata");
        }
    }
}

