/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.Similarity;
import org.apache.solr.analysis.TokenFilterFactory;
import org.apache.solr.analysis.TokenizerChain;
import org.apache.solr.analysis.TokenizerFactory;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.util.DelegateNamedAnalyzer;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitContext {
    private final Map<String, AnalyzerDef> analyzerDefs = new HashMap<String, AnalyzerDef>();
    private final List<DelegateNamedAnalyzer> lazyAnalyzers = new ArrayList<DelegateNamedAnalyzer>();
    private final Analyzer defaultAnalyzer;
    private final Similarity defaultSimilarity;

    public InitContext(SearchConfiguration cfg) {
        this.defaultAnalyzer = this.initAnalyzer(cfg);
        this.defaultSimilarity = this.initSimilarity(cfg);
    }

    public void addAnalyzerDef(AnalyzerDef ann) {
        if (ann == null || this.analyzerDefs.put(ann.name(), ann) != null) {
            // empty if block
        }
    }

    public Analyzer buildLazyAnalyzer(String name) {
        DelegateNamedAnalyzer delegateNamedAnalyzer = new DelegateNamedAnalyzer(name);
        this.lazyAnalyzers.add(delegateNamedAnalyzer);
        return delegateNamedAnalyzer;
    }

    public List<DelegateNamedAnalyzer> getLazyAnalyzers() {
        return this.lazyAnalyzers;
    }

    private Analyzer initAnalyzer(SearchConfiguration cfg) {
        Analyzer defaultAnalyzer;
        Class analyzerClass;
        String analyzerClassName = cfg.getProperty("hibernate.search.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = ReflectHelper.classForName(analyzerClassName);
            }
            catch (Exception e) {
                return this.buildLazyAnalyzer(analyzerClassName);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        try {
            defaultAnalyzer = (Analyzer)analyzerClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene analyzer does not implement " + Analyzer.class.getName() + ": " + analyzerClassName, e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene analyzer with type " + analyzerClassName, e);
        }
        return defaultAnalyzer;
    }

    private Similarity initSimilarity(SearchConfiguration cfg) {
        Similarity defaultSimilarity;
        Class similarityClass;
        String similarityClassName = cfg.getProperty("hibernate.search.similarity");
        if (similarityClassName != null) {
            try {
                similarityClass = ReflectHelper.classForName(similarityClassName);
            }
            catch (Exception e) {
                throw new SearchException("Lucene Similarity class '" + similarityClassName + "' defined in property '" + "hibernate.search.similarity" + "' could not be found.", e);
            }
        } else {
            similarityClass = null;
        }
        if (similarityClass == null) {
            return Similarity.getDefault();
        }
        try {
            defaultSimilarity = (Similarity)similarityClass.newInstance();
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene similarity does not extend " + Similarity.class.getName() + ": " + similarityClassName, e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene similarity with type " + similarityClassName, e);
        }
        return defaultSimilarity;
    }

    public Analyzer getDefaultAnalyzer() {
        return this.defaultAnalyzer;
    }

    public Similarity getDefaultSimilarity() {
        return this.defaultSimilarity;
    }

    public Map<String, Analyzer> initLazyAnalyzers() {
        HashMap<String, Analyzer> initializedAnalyzers = new HashMap<String, Analyzer>(this.analyzerDefs.size());
        for (DelegateNamedAnalyzer delegateNamedAnalyzer : this.lazyAnalyzers) {
            String name = delegateNamedAnalyzer.getName();
            if (initializedAnalyzers.containsKey(name)) {
                delegateNamedAnalyzer.setDelegate((Analyzer)initializedAnalyzers.get(name));
                continue;
            }
            if (this.analyzerDefs.containsKey(name)) {
                Analyzer analyzer = this.buildAnalyzer(this.analyzerDefs.get(name));
                delegateNamedAnalyzer.setDelegate(analyzer);
                initializedAnalyzers.put(name, analyzer);
                continue;
            }
            throw new SearchException("Analyzer found with an unknown definition: " + name);
        }
        for (Map.Entry entry : this.analyzerDefs.entrySet()) {
            if (initializedAnalyzers.containsKey(entry.getKey())) continue;
            Analyzer analyzer = this.buildAnalyzer((AnalyzerDef)entry.getValue());
            initializedAnalyzers.put((String)entry.getKey(), analyzer);
        }
        return Collections.unmodifiableMap(initializedAnalyzers);
    }

    private Analyzer buildAnalyzer(AnalyzerDef analyzerDef) {
        TokenizerDef token = analyzerDef.tokenizer();
        TokenizerFactory tokenFactory = (TokenizerFactory)this.instantiate(token.factory());
        tokenFactory.init(this.getMapOfParameters(token.params()));
        int length = analyzerDef.filters().length;
        TokenFilterFactory[] filters = new TokenFilterFactory[length];
        for (int index = 0; index < length; ++index) {
            TokenFilterDef filterDef = analyzerDef.filters()[index];
            filters[index] = (TokenFilterFactory)this.instantiate(filterDef.factory());
            filters[index].init(this.getMapOfParameters(filterDef.params()));
        }
        return new TokenizerChain(tokenFactory, filters);
    }

    private Object instantiate(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to instantiate class: " + clazz, e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to instantiate class: " + clazz, e);
        }
    }

    private Map<String, String> getMapOfParameters(Parameter[] params) {
        HashMap<String, String> mapOfParams = new HashMap<String, String>(params.length);
        for (Parameter param : params) {
            mapOfParams.put(param.name(), param.value());
        }
        return Collections.unmodifiableMap(mapOfParams);
    }
}

