/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.reader.CacheableMultiReader;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderHelper;
import org.hibernate.search.store.DirectoryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharingBufferReaderProvider
implements ReaderProvider {
    protected final Map<IndexReader, ReaderUsagePair> allReaders = new ConcurrentHashMap<IndexReader, ReaderUsagePair>();
    protected Map<DirectoryProvider, PerDirectoryLatestReader> currentReaders;
    private final Logger log = LoggerFactory.getLogger(SharingBufferReaderProvider.class);

    public void closeReader(IndexReader multiReader) {
        if (multiReader == null) {
            return;
        }
        if (!(multiReader instanceof MultiReader)) {
            throw new AssertionFailure("Everything should be wrapped in a MultiReader");
        }
        IndexReader[] readers = ReaderProviderHelper.getSubReadersFromMultiReader((MultiReader)multiReader);
        this.log.debug("Closing MultiReader: {}", (Object)multiReader);
        for (IndexReader reader : readers) {
            ReaderUsagePair container = this.allReaders.get(reader);
            container.close();
        }
        this.log.trace("IndexReader closed.");
    }

    public void initialize(Properties props, SearchFactoryImplementor searchFactoryImplementor) {
        HashMap<DirectoryProvider, PerDirectoryLatestReader> map = new HashMap<DirectoryProvider, PerDirectoryLatestReader>();
        Set<DirectoryProvider> providers = searchFactoryImplementor.getDirectoryProviders();
        for (DirectoryProvider provider : providers) {
            try {
                map.put(provider, new PerDirectoryLatestReader(provider));
            }
            catch (IOException e) {
                throw new SearchException("Unable to open Lucene IndexReader", e);
            }
        }
        this.currentReaders = Collections.unmodifiableMap(map);
    }

    public IndexReader openReader(DirectoryProvider ... directoryProviders) {
        int length = directoryProviders.length;
        IndexReader[] readers = new IndexReader[length];
        this.log.debug("Opening IndexReader for directoryProviders: {}", (Object)length);
        for (int index = 0; index < length; ++index) {
            DirectoryProvider directoryProvider = directoryProviders[index];
            if (this.log.isTraceEnabled()) {
                this.log.trace("Opening IndexReader from {}", directoryProvider.getDirectory());
            }
            PerDirectoryLatestReader directoryLatestReader = this.currentReaders.get(directoryProvider);
            readers[index] = directoryLatestReader.refreshAndGet();
        }
        if (length == 0) {
            return null;
        }
        try {
            return new CacheableMultiReader(readers);
        }
        catch (Exception e) {
            for (IndexReader ir : readers) {
                ReaderUsagePair readerUsagePair = this.allReaders.get(ir);
                readerUsagePair.close();
            }
            throw new SearchException("Unable to open a MultiReader", e);
        }
    }

    protected IndexReader readerFactory(DirectoryProvider provider) throws IOException {
        return IndexReader.open(provider.getDirectory());
    }

    protected final class PerDirectoryLatestReader {
        public ReaderUsagePair current;
        private final Lock lockOnReplaceCurrent = new ReentrantLock();

        public PerDirectoryLatestReader(DirectoryProvider provider) throws IOException {
            IndexReader reader = SharingBufferReaderProvider.this.readerFactory(provider);
            ReaderUsagePair initialPair = new ReaderUsagePair(reader);
            initialPair.usageCounter.set(1);
            this.lockOnReplaceCurrent.lock();
            this.current = initialPair;
            this.lockOnReplaceCurrent.unlock();
            SharingBufferReaderProvider.this.allReaders.put(reader, initialPair);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexReader refreshAndGet() {
            ReaderUsagePair previousCurrent;
            IndexReader updatedReader;
            this.lockOnReplaceCurrent.lock();
            try {
                IndexReader beforeUpdateReader = this.current.reader;
                try {
                    updatedReader = beforeUpdateReader.reopen();
                }
                catch (IOException e) {
                    throw new SearchException("Unable to reopen IndexReader", e);
                }
                if (beforeUpdateReader == updatedReader) {
                    previousCurrent = null;
                    this.current.usageCounter.incrementAndGet();
                } else {
                    ReaderUsagePair newPair = new ReaderUsagePair(updatedReader);
                    assert (newPair.usageCounter.get() == 2);
                    previousCurrent = this.current;
                    this.current = newPair;
                    SharingBufferReaderProvider.this.allReaders.put(updatedReader, newPair);
                }
            }
            finally {
                this.lockOnReplaceCurrent.unlock();
            }
            if (previousCurrent != null) {
                previousCurrent.close();
            }
            return updatedReader;
        }
    }

    protected final class ReaderUsagePair {
        public final IndexReader reader;
        protected final AtomicInteger usageCounter = new AtomicInteger(2);

        ReaderUsagePair(IndexReader r) {
            this.reader = r;
        }

        public void close() {
            int refCount = this.usageCounter.decrementAndGet();
            if (refCount == 0) {
                ReaderUsagePair removed = SharingBufferReaderProvider.this.allReaders.remove(this.reader);
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    SharingBufferReaderProvider.this.log.warn("Unable to close Lucene IndexReader", (Throwable)e);
                }
                assert (removed != null);
            } else if (refCount < 0) {
                throw new AssertionFailure("Closing an IndexReader for which you didn't own a lock-token, or somebody else which didn't own closed already.");
            }
        }

        public String toString() {
            return "Reader:" + this.hashCode() + " ref.count=" + this.usageCounter.get();
        }
    }
}

