/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.hibernate.HibernateException;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAMDirectoryProvider
implements DirectoryProvider<RAMDirectory> {
    private RAMDirectory directory;
    private String indexName;

    @Override
    public void initialize(String directoryProviderName, Properties properties, SearchFactoryImplementor searchFactoryImplementor) {
        this.indexName = directoryProviderName;
    }

    @Override
    public void start() {
        this.directory = new RAMDirectory();
        try {
            IndexWriter iw = new IndexWriter((Directory)this.directory, (Analyzer)new StandardAnalyzer(), true);
            iw.close();
        }
        catch (IOException e) {
            throw new HibernateException("Unable to initialize index: " + this.indexName, e);
        }
    }

    @Override
    public RAMDirectory getDirectory() {
        return this.directory;
    }

    @Override
    public void stop() {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RAMDirectoryProvider)) {
            return false;
        }
        return this.indexName.equals(((RAMDirectoryProvider)obj).indexName);
    }

    public int hashCode() {
        int hash = 7;
        return 29 * hash + this.indexName.hashCode();
    }
}

