/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.info.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.Subject;
import org.ow2.easybeans.api.bean.info.IMethodSecurityInfo;
import org.ow2.easybeans.api.bean.info.ISecurityInfo;
import org.ow2.easybeans.security.struct.JGroup;
import org.ow2.easybeans.security.struct.JPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityInfo
implements ISecurityInfo {
    private List<String> declaredRoles = null;
    private List<IMethodSecurityInfo> methodSecurityInfos = new ArrayList<IMethodSecurityInfo>();
    private String runAsRole = null;
    private Subject runAsSubject = null;

    public void addMethodSecurityInfo(IMethodSecurityInfo methodSecurityInfo) {
        this.methodSecurityInfos.add(methodSecurityInfo);
    }

    public List<IMethodSecurityInfo> getMethodSecurityInfos() {
        return this.methodSecurityInfos;
    }

    public void setRunAsRole(String runAsRole) {
        this.runAsRole = runAsRole;
        this.runAsSubject = new Subject();
        JPrincipal principalName = new JPrincipal(runAsRole);
        this.runAsSubject.getPrincipals().add(principalName);
        JGroup roles = new JGroup("roles");
        roles.addMember(new JPrincipal(runAsRole));
        this.runAsSubject.getPrincipals().add((Principal)((Object)roles));
    }

    public String getRunAsRole() {
        return this.runAsRole;
    }

    public Subject getRunAsSubject() {
        return this.runAsSubject;
    }

    public void addDeclaredRole(String roleName) {
        this.declaredRoles.add(roleName);
    }

    public List<String> getDeclaredRoles() {
        return this.declaredRoles;
    }

    public void setDeclaredRole(List<String> declaredRoles) {
        this.declaredRoles = declaredRoles;
    }
}

