/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class BusinessMethodResolver {
    public static final String CLASS_INIT = "<clinit>";
    public static final String CONST_INIT = "<init>";
    private static Log logger = LogFactory.getLog(BusinessMethodResolver.class);

    private BusinessMethodResolver() {
    }

    public static void resolve(EasyBeansEjbJarClassMetadata classAnnotationMetadata) {
        BusinessMethodResolver.loop(classAnnotationMetadata, classAnnotationMetadata);
    }

    private static void loop(EasyBeansEjbJarClassMetadata beanclassAnnotationMetadata, EasyBeansEjbJarClassMetadata visitingclassAnnotationMetadata) {
        for (String itf : visitingclassAnnotationMetadata.getInterfaces()) {
            if (itf.startsWith("javax/ejb/") || itf.startsWith("java/io/Serializable") || itf.startsWith("java/io/Externalizable")) continue;
            EasyBeansEjbJarClassMetadata itfMetadata = (EasyBeansEjbJarClassMetadata)visitingclassAnnotationMetadata.getLinkedClassMetadata(itf);
            if (itfMetadata == null) {
                logger.warn((Object)"No class was found for interface {0}.", new Object[]{itf});
                continue;
            }
            for (EasyBeansEjbJarMethodMetadata methodData : itfMetadata.getMethodMetadataCollection()) {
                JMethod itfMethod = methodData.getJMethod();
                if (itfMethod.getName().equals(CLASS_INIT) || itfMethod.getName().equals(CONST_INIT)) continue;
                EasyBeansEjbJarMethodMetadata beanMethod = (EasyBeansEjbJarMethodMetadata)beanclassAnnotationMetadata.getMethodMetadata(itfMethod);
                if (beanMethod == null) {
                    throw new IllegalStateException("No method was found for method " + itfMethod + " in class " + beanclassAnnotationMetadata.getClassName());
                }
                beanMethod.setBusinessMethod(true);
            }
            if (itfMetadata.getInterfaces() == null) continue;
            BusinessMethodResolver.loop(beanclassAnnotationMetadata, itfMetadata);
        }
    }
}

