/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.interceptors;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.api.EasyBeansInvocationContext;
import org.ow2.easybeans.api.bean.EasyBeansBean;
import org.ow2.easybeans.api.interceptor.EZBInterceptorInvoker;
import org.ow2.easybeans.api.interceptor.EZBInterceptorManager;
import org.ow2.easybeans.api.interceptor.EZBInterceptorManagerFactory;
import org.ow2.easybeans.api.interceptor.EZBInvocationContextFactory;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.enhancer.interceptors.BeanBusinessMethodInvokerImpl;
import org.ow2.easybeans.enhancer.interceptors.BeanInterceptorInvokerImpl;
import org.ow2.easybeans.enhancer.interceptors.DynamicInvocationContextImpl;
import org.ow2.easybeans.enhancer.interceptors.EasyBeansInterceptorManagerFactory;
import org.ow2.easybeans.enhancer.interceptors.MethodHelper;
import org.ow2.easybeans.enhancer.interceptors.MethodInterceptorsBuilder;
import org.ow2.easybeans.enhancer.interceptors.StandaloneInterceptorInvokerImpl;
import org.ow2.easybeans.enhancer.lib.MethodRenamer;
import org.ow2.util.ee.metadata.ejbjar.api.IJClassInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.InterceptorType;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public class EasyBeansInvocationContextFactory
implements EZBInvocationContextFactory {
    private static final Log LOGGER = LogFactory.getLog(EasyBeansInvocationContextFactory.class);
    private Map<String, List<EZBInterceptorInvoker>> methodsInterceptorInvokerList;
    private Map<String, Method> methods;
    private List<String> interceptorClasses = null;
    private ClassLoader classLoader = null;

    public EasyBeansInvocationContextFactory(EasyBeansEjbJarClassMetadata classMetadata, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.methodsInterceptorInvokerList = new HashMap<String, List<EZBInterceptorInvoker>>();
        this.methods = new HashMap<String, Method>();
        this.interceptorClasses = new ArrayList<String>();
        Collection methodsMetadata = classMetadata.getMethodMetadataCollection();
        for (EasyBeansEjbJarMethodMetadata methodMetadata : methodsMetadata) {
            if (!methodMetadata.isBusinessMethod()) continue;
            List<IJClassInterceptor> allInterceptors = new MethodInterceptorsBuilder(methodMetadata, InterceptorType.AROUND_INVOKE).getAllInterceptors();
            ArrayList<Object> invokers = new ArrayList<Object>();
            String methodSignature = MethodHelper.getSignature(methodMetadata);
            this.methodsInterceptorInvokerList.put(methodSignature, invokers);
            for (IJClassInterceptor interceptor : allInterceptors) {
                String classname = interceptor.getClassName();
                JMethod jMethod = interceptor.getJMethod();
                if (classMetadata.getClassName().equals(classname)) {
                    invokers.add(new BeanInterceptorInvokerImpl(classname, jMethod, classLoader));
                    continue;
                }
                invokers.add(new StandaloneInterceptorInvokerImpl(classname, jMethod, classLoader));
                this.addInterceptorClass(classname);
            }
            JMethod interceptedMethod = methodMetadata.getJMethod();
            JMethod originalMethod = new JMethod(interceptedMethod.getAccess(), MethodRenamer.encode(interceptedMethod.getName()), interceptedMethod.getDescriptor(), interceptedMethod.getSignature(), interceptedMethod.getExceptions());
            invokers.add(new BeanBusinessMethodInvokerImpl(classMetadata.getClassName(), originalMethod, classLoader));
            this.methods.put(methodSignature, MethodHelper.getMethod(classMetadata.getClassName(), methodMetadata.getJMethod(), classLoader));
        }
    }

    protected void addInterceptorClass(String classname) {
        if (!this.interceptorClasses.contains(classname)) {
            this.interceptorClasses.add(classname);
        }
    }

    public EZBInterceptorManagerFactory getInterceptorManagerFactory() {
        return new EasyBeansInterceptorManagerFactory(this.interceptorClasses, this.classLoader);
    }

    public EasyBeansInvocationContext getContext(EasyBeansBean instance, EZBInterceptorManager interceptorManager, String methodSignature, Object ... parameters) {
        LOGGER.debug((Object)"Calling getContext for instance ''{0}'', interceptor manager ''{1}'', signature ''{2}'' and parameters ''{3}'' with interceptor invoker list set to ''{4}''", new Object[]{instance, interceptorManager, methodSignature, parameters, this.methodsInterceptorInvokerList});
        return new DynamicInvocationContextImpl(instance, this.methodsInterceptorInvokerList.get(methodSignature), interceptorManager, this.methods.get(methodSignature), parameters);
    }
}

