/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.ow2.easybeans.loader.EasyBeansClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPersistenceUnitInfo
implements PersistenceUnitInfo {
    private String persistenceUnitName = null;
    private String persistenceProviderClassName = null;
    private PersistenceUnitTransactionType transactionType = null;
    private DataSource jtaDataSource = null;
    private DataSource nonJtaDataSource = null;
    private String jtaDataSourceName = null;
    private String nonJtaDataSourceName = null;
    private List<String> mappingFileNames = null;
    private List<URL> jarFiles = null;
    private URL persistenceUnitRootUrl = null;
    private List<String> managedClassNames = null;
    private boolean excludeUnlistedClasses = false;
    private Properties properties = new Properties();
    private ClassLoader classLoader = null;
    private URL persistenceXmlFileUrl = null;
    private PersistenceProvider persistenceProvider = null;

    public JPersistenceUnitInfo() {
        this.mappingFileNames = new ArrayList<String>();
        this.managedClassNames = new ArrayList<String>();
        this.jarFiles = new ArrayList<URL>();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void addJarFile(URL jarFile) {
        this.jarFiles.add(jarFile);
    }

    public void setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }

    public void setNonJtaDataSource(DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
    }

    public void setJtaDataSourceName(String jtaDataSourceName) {
        this.jtaDataSourceName = jtaDataSourceName;
    }

    public void setNonJtaDataSourceName(String nonJtaDataSourceName) {
        this.nonJtaDataSourceName = nonJtaDataSourceName;
    }

    public void addMappingFileName(String mappingFileName) {
        this.mappingFileNames.add(mappingFileName);
    }

    public void setPersistenceProviderClassName(String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
    }

    public void setPersistenceProvider(PersistenceProvider persistenceProvider) {
        this.persistenceProvider = persistenceProvider;
    }

    public void setPersistenceXmlFileUrl(URL persistenceXmlFileUrl) {
        this.persistenceXmlFileUrl = persistenceXmlFileUrl;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public List<URL> getJarFiles() {
        return this.jarFiles;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public URL getPersistenceXmlFileUrl() {
        return this.persistenceXmlFileUrl;
    }

    public String getJtaDataSourceName() {
        return this.jtaDataSourceName;
    }

    public String getNonJtaDataSourceName() {
        return this.nonJtaDataSourceName;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public List<URL> getJarFileUrls() {
        return this.jarFiles;
    }

    public void setPersistenceUnitRootUrl(URL persistenceUnitRootUrl) {
        this.persistenceUnitRootUrl = persistenceUnitRootUrl;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public void addClass(String className) {
        this.managedClassNames.add(className);
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void addTransformer(ClassTransformer transformer) {
        if (this.classLoader instanceof EasyBeansClassLoader) {
            EasyBeansClassLoader currentCL = (EasyBeansClassLoader)this.classLoader;
            currentCL.addTransformer(transformer);
            return;
        }
        throw new IllegalStateException("Cannot add the given transformer as ClassLoader is not an EasyBeans classloader");
    }

    public ClassLoader getNewTempClassLoader() {
        if (this.classLoader instanceof EasyBeansClassLoader) {
            EasyBeansClassLoader currentCL = (EasyBeansClassLoader)this.classLoader;
            return currentCL.duplicate();
        }
        throw new IllegalStateException("Cannot build a new temporary classloader");
    }
}

