/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.compiler.lib;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.compiler.api.JormCompilerParameter;
import org.objectweb.jorm.compiler.api.PExceptionCompiler;
import org.objectweb.jorm.util.io.api.PathExplorer;
import org.objectweb.jorm.util.io.lib.DirJavaExplorer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class JormCompilerParameterImpl
implements JormCompilerParameter {
    private String logConfFile = null;
    private PathExplorer classpath = new DirJavaExplorer();
    private String output = null;
    private boolean verbose = false;
    private Collection inputFiles = new ArrayList();
    private boolean keepSrc = true;
    private String javacName = "javac";
    private String projectName = "";
    private boolean javac = false;
    private boolean generateBinding = true;
    private boolean parseOnly = false;
    private boolean stateGenerated = true;
    private String stateInheritance = null;
    private String bindingInheritance = null;
    private String bindingEnhancedClass = null;
    private String classMappingInheritance = null;
    private boolean bindingAbstract = false;
    private Logger logger = null;
    private ArrayList dtdLocations = new ArrayList();
    private boolean generatedPDFiles = false;
    private boolean generatedWithMapperPackage = true;

    public void print() {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("output: " + this.output));
            this.logger.log(BasicLevel.DEBUG, (Object)("verbose: " + this.verbose));
            this.logger.log(BasicLevel.DEBUG, (Object)"inputFiles: ");
            Iterator it = this.inputFiles.iterator();
            while (it.hasNext()) {
                this.logger.log(BasicLevel.DEBUG, (Object)((String)it.next()));
            }
        }
    }

    public String computePClassMappingInheritance(String cn) {
        return JormCompilerParameterImpl.computeInheritanceString(cn, this.classMappingInheritance);
    }

    public String computePBindingInheritance(String cn) {
        return JormCompilerParameterImpl.computeInheritanceString(cn, this.bindingInheritance);
    }

    public void loadConfFile(String file, Iterator knownmappers) throws PException {
        try {
            this.loadConfFile(new FileInputStream(file), knownmappers);
        }
        catch (IOException e) {
            throw new PExceptionCompiler(e, "Cannot open the jorm configuration file: " + file);
        }
    }

    public void loadConfFile(InputStream in, Iterator knownmappers) throws PException {
        if (in == null) {
            throw new PExceptionCompiler("Cannot load jorm configuration file: InputStream is null.");
        }
        Properties p = new Properties();
        try {
            p.load(in);
        }
        catch (IOException e) {
            throw new PExceptionCompiler(e, "An error occured during the loading of the jorm configuration file.");
        }
        String s = null;
        s = p.getProperty("log.config.file");
        if (s != null) {
            this.logConfFile = s;
        }
        if ((s = p.getProperty("keepsrc")) != null) {
            this.keepSrc = new Boolean(s);
        }
        if ((s = p.getProperty("verbose")) != null) {
            this.verbose = new Boolean(s);
        }
        if ((s = p.getProperty("javacompiler")) != null) {
            this.javacName = s;
        }
        if ((s = p.getProperty("projectname")) != null) {
            this.projectName = s;
        }
        if ((s = p.getProperty("stategenerated")) != null) {
            this.stateGenerated = new Boolean(s);
        }
        if ((s = p.getProperty("stateinheritance")) != null) {
            this.stateInheritance = s;
        }
        if ((s = p.getProperty("bindinginheritance")) != null) {
            this.bindingInheritance = s;
        }
        if ((s = p.getProperty("classmappinginheritance")) != null) {
            this.classMappingInheritance = s;
        }
        if ((s = p.getProperty("inputfiles")) != null) {
            StringTokenizer tok = new StringTokenizer(s, ",");
            while (tok.hasMoreTokens()) {
                this.inputFiles.add(tok.nextToken().trim());
            }
        }
    }

    public PathExplorer getClasspath() {
        return this.classpath;
    }

    public String getOutput() {
        return this.output;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Collection getInputFiles() {
        return this.inputFiles;
    }

    public boolean isKeepSrc() {
        return this.keepSrc;
    }

    public String getJavacName() {
        return this.javacName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean isJavac() {
        return this.javac;
    }

    public boolean isParseOnly() {
        return this.parseOnly;
    }

    public boolean isGenerateBinding() {
        return this.generateBinding;
    }

    public void setGenerateBinding(boolean v) {
        this.generateBinding = v;
    }

    public boolean isStateGenerated() {
        return this.stateGenerated;
    }

    public void setStateGenerated(boolean v) {
        this.stateGenerated = v;
    }

    public String getStateInheritance() {
        return this.stateInheritance;
    }

    public String getBindingInheritance() {
        return this.bindingInheritance;
    }

    public String getBindingEnhancedClass() {
        return this.bindingEnhancedClass;
    }

    public String getClassMappingInheritance() {
        return this.classMappingInheritance;
    }

    public boolean isBindingAbstract() {
        return this.bindingAbstract;
    }

    public ArrayList getDtdLocations() {
        return this.dtdLocations;
    }

    public boolean isGeneratedPDFiles() {
        return this.generatedPDFiles;
    }

    public boolean isGeneratedWithMapperPackage() {
        return this.generatedWithMapperPackage;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setLoggerFactory(LoggerFactory lf) {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFactory getLoggerFactory() {
        return null;
    }

    public Object clone() {
        JormCompilerParameterImpl res = new JormCompilerParameterImpl();
        res.classpath = this.classpath;
        res.output = this.output;
        res.verbose = this.verbose;
        res.inputFiles = this.inputFiles;
        res.keepSrc = this.keepSrc;
        res.javacName = this.javacName;
        res.projectName = this.projectName;
        res.javac = this.javac;
        res.parseOnly = this.parseOnly;
        res.stateGenerated = this.stateGenerated;
        res.stateInheritance = this.stateInheritance;
        res.bindingInheritance = this.bindingInheritance;
        res.classMappingInheritance = this.classMappingInheritance;
        res.bindingAbstract = this.bindingAbstract;
        res.logger = this.logger;
        res.dtdLocations = this.dtdLocations;
        return res;
    }

    private static String computeInheritanceString(String cn, String pattern) {
        if (cn == null || cn.length() == 0) {
            return null;
        }
        int pIdx = pattern.indexOf("%p");
        int cIdx = pattern.indexOf("%c");
        if (pIdx == -1 && cIdx == -1) {
            return pattern;
        }
        String[] icn = JormCompilerParameterImpl.isolatePackageName(cn);
        StringTokenizer st = new StringTokenizer(pattern, "%cp", true);
        StringBuffer sb = new StringBuffer();
        boolean hasPercent = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("%") && !hasPercent) {
                hasPercent = true;
                continue;
            }
            if (hasPercent) {
                if (token.equals("p")) {
                    if (icn[0] != null) {
                        sb.append(icn[0]);
                    }
                } else if (token.equals("c")) {
                    sb.append(icn[1]);
                }
                hasPercent = false;
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    private static String[] isolatePackageName(String fqcn) {
        int idx = fqcn.lastIndexOf(".");
        if (idx == -1) {
            return new String[]{null, fqcn};
        }
        return new String[]{fqcn.substring(0, idx + 1), fqcn.substring(idx + 1, fqcn.length())};
    }

    public void setClasspath(PathExplorer classpath) {
        this.classpath = classpath;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setKeepSrc(boolean keepSrc) {
        this.keepSrc = keepSrc;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setJavac(boolean javac) {
        this.javac = javac;
    }

    public void setStateInheritance(String stateInheritance) {
        this.stateInheritance = stateInheritance;
    }

    public void setBindingInheritance(String bindingInheritance) {
        this.bindingInheritance = bindingInheritance;
    }

    public void setBindingEnhancedClass(String bindingEnhancedClass) {
        this.bindingEnhancedClass = bindingEnhancedClass;
    }

    public void setClassMappingInheritance(String classMappingInheritance) {
        this.classMappingInheritance = classMappingInheritance;
    }

    public void setBindingAbstract(boolean bindingAbstract) {
        this.bindingAbstract = bindingAbstract;
    }

    public void setDtdLocations(ArrayList dtdLocations) {
        this.dtdLocations = dtdLocations;
    }

    public void setGeneratedPDFiles(boolean generatedPDFiles) {
        this.generatedPDFiles = generatedPDFiles;
    }

    public void setInputFiles(Collection inputFiles) {
        this.inputFiles = inputFiles;
    }

    public void setGeneratedWithMapperPackage(boolean generatedWithMapperPackage) {
        this.generatedWithMapperPackage = generatedWithMapperPackage;
    }

    public void setLogConfFile(String logConfFile) {
        this.logConfFile = logConfFile;
    }
}

