/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.scheduler;

import com.scalagent.scheduler.AddConditionListener;
import com.scalagent.scheduler.Condition;
import com.scalagent.scheduler.ConditionItem;
import com.scalagent.scheduler.RemoveConditionListener;
import com.scalagent.scheduler.ScheduleEvent;
import com.scalagent.scheduler.ScheduleItem;
import com.scalagent.scheduler.ScheduleNotification;
import com.scalagent.scheduler.SchedulerAlarm;
import fr.dyade.aaa.agent.AgentId;
import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.DriverDone;
import fr.dyade.aaa.agent.Notification;
import fr.dyade.aaa.agent.ProxyAgent;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class Scheduler
extends ProxyAgent {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger(Scheduler.class.getName());
    private static boolean initialized = false;
    public static String defaultName = "DefaultScheduler";
    ScheduleItem items;
    ConditionItem conditions;
    transient SchedulerAlarm alarm;

    public static void init(String args, boolean firstTime) throws Exception {
        if (initialized) {
            return;
        }
        initialized = true;
        if (!firstTime) {
            return;
        }
        Scheduler scheduler = new Scheduler();
        scheduler.deploy();
    }

    public static void stopService() {
    }

    public static AgentId getDefault(short serverId) {
        return new AgentId(serverId, serverId, AgentId.SchedulerServiceStamp);
    }

    public static AgentId getDefault() {
        return Scheduler.getDefault(AgentServer.getServerId());
    }

    public Scheduler(String schedulerName) {
        super(schedulerName);
        this.blockingCnx = false;
        this.items = null;
        this.conditions = null;
        this.alarm = null;
    }

    private Scheduler() throws IOException {
        super(defaultName, AgentId.SchedulerServiceStamp);
        this.blockingCnx = false;
        this.items = null;
        this.conditions = null;
        this.alarm = null;
    }

    public Scheduler(short to, String name) {
        super(to, name);
        this.blockingCnx = false;
        this.items = null;
        this.conditions = null;
        this.alarm = null;
    }

    public String toString() {
        return "(" + super.toString() + ",items=" + this.items + ",conditions=" + this.conditions + ")";
    }

    public void connect() throws Exception {
        this.alarm = new SchedulerAlarm();
        this.ois = this.alarm;
    }

    public void disconnect() throws IOException {
        if (this.alarm != null) {
            this.alarm.close();
            this.alarm = null;
            this.ois = null;
        }
    }

    ConditionItem addCondition(String name) {
        if (this.conditions == null) {
            this.conditions = new ConditionItem(name);
            return this.conditions;
        }
        ConditionItem prev = null;
        ConditionItem item = this.conditions;
        while (item != null) {
            int cmp = name.compareTo(item.name);
            if (cmp == 0) {
                return item;
            }
            if (cmp < 0) break;
            prev = item;
            item = item.next;
        }
        ConditionItem newItem = new ConditionItem(name);
        if (prev == null) {
            newItem.next = this.conditions;
            this.conditions = newItem;
        } else {
            newItem.next = prev.next;
            prev.next = newItem;
        }
        return newItem;
    }

    ConditionItem findCondition(String name) {
        if (this.conditions == null) {
            return null;
        }
        ConditionItem item = this.conditions;
        while (item != null) {
            int cmp = name.compareTo(item.name);
            if (cmp == 0) {
                return item;
            }
            if (cmp < 0) break;
            item = item.next;
        }
        return null;
    }

    void removeCondition(String name) {
        int cmp;
        if (this.conditions == null) {
            return;
        }
        ConditionItem prev = null;
        ConditionItem item = this.conditions;
        while (item != null && (cmp = name.compareTo(item.name)) != 0) {
            if (cmp < 0) {
                return;
            }
            prev = item;
            item = item.next;
        }
        if (prev == null) {
            this.conditions = this.conditions.next;
        } else {
            prev.next = prev.next.next;
        }
    }

    protected void agentInitialize(boolean firstTime) throws Exception {
        super.agentInitialize(firstTime);
        this.checkItems(true);
    }

    public void react(AgentId from, Notification not) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Scheduler.react(" + from + ',' + not + ')'));
        }
        if (not instanceof ScheduleEvent) {
            this.doReact(from, (ScheduleEvent)not);
        } else if (not instanceof ScheduleNotification) {
            this.doReact(from, (ScheduleNotification)not);
        } else if (not instanceof AddConditionListener) {
            this.doReact(from, (AddConditionListener)not);
        } else if (not instanceof RemoveConditionListener) {
            this.doReact(from, (RemoveConditionListener)not);
        } else {
            super.react(from, not);
        }
    }

    protected void doReact(AgentId from, ScheduleEvent not) throws Exception {
        this.insertItem(not);
        this.checkItems(false);
    }

    protected void doReact(AgentId from, ScheduleNotification not) throws Exception {
        this.checkItems(false);
    }

    protected void doReact(AgentId from, AddConditionListener not) throws Exception {
        this.addConditionListener(not.name, from);
    }

    protected void doReact(AgentId from, RemoveConditionListener not) throws Exception {
        this.removeConditionListener(not.name, from);
    }

    protected void insertItem(ScheduleEvent not) throws Exception {
        Date now = new Date();
        ScheduleItem newItem = new ScheduleItem(not);
        newItem.date = not.nextDate(now);
        if (newItem.date == null) {
            if (!not.outdatedRestart) {
                return;
            }
            newItem.date = now;
        }
        this.insertItem(newItem);
    }

    protected void insertItem(ScheduleItem newItem) throws Exception {
        if (newItem.date == null) {
            return;
        }
        if (this.items == null) {
            this.items = newItem;
        } else {
            ScheduleItem prev = null;
            ScheduleItem item = this.items;
            while (item != null && newItem.date.after(item.date)) {
                prev = item;
                item = item.next;
            }
            if (prev == null) {
                if (this.items != null) {
                    newItem.next = this.items;
                    this.items.prev = newItem;
                }
                this.items = newItem;
            } else {
                newItem.next = prev.next;
                newItem.prev = prev;
                prev.next = newItem;
                if (newItem.next != null) {
                    newItem.next.prev = newItem;
                }
            }
        }
    }

    protected void checkItems(boolean restart) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Scheduler.checkItems(" + restart + ')'));
        }
        Date now = new Date();
        ScheduleItem item = this.items;
        while (!(item == null || item.date != null && item.date.after(now))) {
            ScheduleItem nextItem = item.next;
            if (!restart || item.event.outdatedRestart || item.status || item.event.duration > 0L && new Date(item.date.getTime() + item.event.duration * 1000L).after(now)) {
                item.status = !item.status;
                this.signalEvent(item);
            }
            if (item.status) {
                if (item.event.duration > 0L) {
                    item.date.setTime(item.date.getTime() + item.event.duration * 1000L);
                } else {
                    boolean bl = item.status = !item.status;
                }
            }
            if (!item.status) {
                item.date = item.event.nextDate(now);
                if (item.date != null && !item.date.after(now)) {
                    item.date = null;
                }
            }
            if (item.date == null) {
                this.removeItem(item);
                item = nextItem;
                continue;
            }
            if (nextItem == null || !item.date.after(nextItem.date)) continue;
            this.removeItem(item);
            this.insertItem(item);
            item = nextItem;
        }
        if (this.items != null) {
            this.alarm.setTime(this.items.date.getTime() - now.getTime());
        }
    }

    void removeItem(ScheduleItem item) {
        if (item.next != null) {
            item.next.prev = item.prev;
        }
        if (item.prev == null) {
            this.items = item.next;
        } else {
            item.prev.next = item.next;
        }
        item.next = null;
        item.prev = null;
        ConditionItem citem = this.findCondition(item.event.name);
        if (citem == null) {
            return;
        }
        Enumeration listeners = citem.listeners.getListeners();
        if (listeners != null && listeners.hasMoreElements()) {
            return;
        }
        ScheduleItem sitem = this.items;
        while (sitem != null) {
            if (sitem.event.name.equals(item.event.name)) {
                return;
            }
            sitem = sitem.next;
        }
        this.removeCondition(item.event.name);
    }

    protected void addConditionListener(String condition, AgentId listener) throws Exception {
        ConditionItem citem = this.addCondition(condition);
        citem.listeners.addListener(listener);
        ScheduleItem item = this.items;
        while (item != null) {
            if (item.event.name.equals(condition) && item.status) {
                this.sendTo(listener, (Notification)new Condition(item.event.name, item.status));
            }
            item = item.next;
        }
    }

    protected void removeConditionListener(String condition, AgentId listener) throws Exception {
        ConditionItem citem = this.findCondition(condition);
        if (citem == null) {
            return;
        }
        citem.listeners.removeListener(listener);
        Enumeration listeners = citem.listeners.getListeners();
        if (listeners != null && listeners.hasMoreElements()) {
            return;
        }
        ScheduleItem item = this.items;
        while (item != null) {
            if (item.event.name.equals(condition)) {
                return;
            }
            item = item.next;
        }
        this.removeCondition(condition);
    }

    protected void signalEvent(ScheduleItem item) {
        ConditionItem condition = this.findCondition(item.event.name);
        if (condition == null) {
            return;
        }
        this.sendTo(condition.listeners, (Notification)new Condition(item.event.name, item.status));
    }

    protected void driverDone(DriverDone not) throws IOException {
    }
}

