/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.Debug;
import fr.dyade.aaa.agent.Network;
import fr.dyade.aaa.agent.ServerDesc;
import fr.dyade.aaa.agent.ServiceDesc;
import fr.dyade.aaa.agent.ServiceManager;
import fr.dyade.aaa.agent.conf.A3CML;
import fr.dyade.aaa.agent.conf.A3CMLConfig;
import fr.dyade.aaa.agent.conf.A3CMLDomain;
import fr.dyade.aaa.agent.conf.A3CMLNetwork;
import fr.dyade.aaa.agent.conf.A3CMLServer;
import fr.dyade.aaa.agent.conf.A3CMLService;
import fr.dyade.aaa.util.NullTransaction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ServerConfigHelper {
    private static Logger logger = Debug.getLogger(ServerConfigHelper.class.getName());
    private boolean autoCommit;

    public ServerConfigHelper(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public boolean addDomain(String domainName, String network, int routerId, int port) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ServerConfigHelper.addDomain(" + domainName + ',' + network + ',' + routerId + ',' + port + ')'));
        }
        A3CMLConfig a3cmlConfig = AgentServer.getConfig();
        if (a3cmlConfig.domains.get(domainName) != null) {
            throw new NameAlreadyUsedException("Domain name already used: " + domainName);
        }
        if (a3cmlConfig.servers.get(new Short((short)routerId)) == null) {
            throw new Exception("Server not found: " + routerId);
        }
        A3CMLDomain domain = new A3CMLDomain(domainName, network);
        a3cmlConfig.addDomain(domain);
        A3CMLServer a3cmlServer = a3cmlConfig.getServer((short)routerId);
        domain.addServer(a3cmlServer);
        A3CMLNetwork a3cmlNetwork = new A3CMLNetwork(domainName, port);
        a3cmlServer.addNetwork(a3cmlNetwork);
        A3CMLServer root = a3cmlConfig.getServer(AgentServer.getServerId());
        a3cmlConfig.configure(root);
        boolean res = false;
        if (routerId == AgentServer.getServerId()) {
            Network net = (Network)Class.forName(network).newInstance();
            net.name = AgentServer.getName() + '.' + domainName;
            AgentServer.addConsumer(domainName, net);
            try {
                short[] sids = new short[]{(short)routerId};
                net.init(domainName, port, sids);
                net.start();
            }
            catch (Exception exc) {
                if (logger.isLoggable(BasicLevel.ERROR)) {
                    logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
                }
                AgentServer.removeConsumer(domainName);
                a3cmlServer.removeNetwork(domainName);
                a3cmlConfig.removeDomain(domainName);
                a3cmlConfig.configure(root);
                throw new StartFailureException(exc.getMessage());
            }
            res = true;
        }
        if (this.autoCommit) {
            this.commit();
        }
        return res;
    }

    public boolean removeDomain(String domainName) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ServerConfigHelper.removeDomain(" + domainName + ')'));
        }
        A3CMLConfig a3cmlConfig = AgentServer.getConfig();
        A3CMLDomain domain = a3cmlConfig.getDomain(domainName);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> domain.servers = " + domain.servers));
        }
        if (domain.servers.size() > 1) {
            throw new Exception("Can't remove domain: it contains more than one server.");
        }
        A3CMLServer router = null;
        if (domain.servers.size() == 1) {
            router = (A3CMLServer)domain.servers.elementAt(0);
        }
        a3cmlConfig.removeDomain(domainName);
        if (router != null) {
            router.removeNetwork(domainName);
        }
        A3CMLServer root = a3cmlConfig.getServer(AgentServer.getServerId());
        a3cmlConfig.configure(root);
        boolean res = false;
        if (router != null && router.sid == AgentServer.getServerId()) {
            AgentServer.removeConsumer(domainName);
            res = true;
        }
        if (this.autoCommit) {
            this.commit();
        }
        return res;
    }

    public void addServer(int sid, String hostName, String domainName, int port, String name) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ServerConfigHelper.addServer(" + sid + ',' + hostName + ',' + domainName + ',' + port + ',' + name + ')'));
        }
        A3CMLConfig a3cmlConfig = AgentServer.getConfig();
        if (a3cmlConfig.servers.get(new Integer(sid)) != null) {
            throw new ServerIdAlreadyUsedException("Server id already used: " + sid);
        }
        A3CMLDomain domain = a3cmlConfig.getDomain(domainName);
        A3CMLServer server = new A3CMLServer((short)sid, name, hostName);
        a3cmlConfig.addServer(server);
        A3CMLNetwork network = new A3CMLNetwork(domainName, port);
        server.addNetwork(network);
        domain.addServer(server);
        server.domain = domainName;
        A3CMLServer root = a3cmlConfig.getServer(AgentServer.getServerId());
        a3cmlConfig.configure(root);
        ServerDesc serverDesc = new ServerDesc((short)sid, name, hostName, -1);
        AgentServer.addServerDesc(serverDesc);
        AgentServer.initServerDesc(serverDesc, server);
        if (serverDesc.gateway == serverDesc.sid) {
            if (serverDesc.domain instanceof Network) {
                Network net = (Network)serverDesc.domain;
                net.stop();
                net.addServer((short)sid);
                net.start();
            } else {
                throw new Error("Unknown gateway type: " + serverDesc.domain);
            }
        }
        if (this.autoCommit) {
            this.commit();
        }
    }

    public void removeServer(int sid) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ServerConfigHelper.removeServer(" + sid + ')'));
        }
        if (sid != AgentServer.getServerId()) {
            A3CMLConfig a3cmlConfig = AgentServer.getConfig();
            A3CMLServer a3cmlServer = a3cmlConfig.getServer((short)sid);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> server.networks = " + a3cmlServer.networks));
            }
            if (a3cmlServer.networks.size() > 1) {
                throw new Exception("Can't remove server: it belongs to more than one domain.");
            }
            a3cmlConfig.removeServer((short)sid);
            A3CMLServer root = a3cmlConfig.getServer(AgentServer.getServerId());
            a3cmlConfig.configure(root);
            ServerDesc servDesc = AgentServer.removeServerDesc((short)sid);
            if (servDesc.domain instanceof Network) {
                Network net = (Network)servDesc.domain;
                net.stop();
                net.delServer(servDesc.sid);
                net.start();
            }
            Enumeration e = AgentServer.elementsServerDesc();
            while (e.hasMoreElements()) {
                ServerDesc sd = (ServerDesc)e.nextElement();
                if (sd.gateway != sid) continue;
                sd.gateway = (short)-1;
                sd.domain = null;
            }
            if (this.autoCommit) {
                this.commit();
            }
        }
    }

    public void addService(int sid, String className, String args) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ServerConfigHelper.addService(" + sid + ',' + className + ',' + args + ')'));
        }
        A3CMLConfig a3cmlConfig = AgentServer.getConfig();
        A3CMLServer a3cmlServer = a3cmlConfig.getServer((short)sid);
        A3CMLService a3cmlService = new A3CMLService(className, args);
        a3cmlServer.addService(a3cmlService);
        if (sid == AgentServer.getServerId()) {
            try {
                ServiceManager.register(className, args);
                ServiceDesc desc = (ServiceDesc)ServiceManager.manager.registry.get(className);
                if (!desc.running) {
                    ServiceManager.start(desc);
                }
            }
            catch (Exception exc) {
                a3cmlServer.removeService(className);
            }
        }
        if (this.autoCommit) {
            this.commit();
        }
    }

    public void removeService(int sid, String className) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ServerConfigHelper.addService(" + sid + ',' + className + ')'));
        }
        A3CMLConfig a3cmlConfig = AgentServer.getConfig();
        A3CMLServer a3cmlServer = a3cmlConfig.getServer((short)sid);
        if (sid == AgentServer.getServerId()) {
            ServiceManager.stop(className);
        }
        a3cmlServer.removeService(className);
        if (this.autoCommit) {
            this.commit();
        }
    }

    public void commit() throws Exception {
        A3CMLConfig a3cmlConfig = AgentServer.getConfig();
        if (AgentServer.getTransaction() instanceof NullTransaction) {
            String cfgDir = System.getProperty("fr.dyade.aaa.agent.A3CONF_DIR", AgentServer.DEFAULT_CFG_DIR);
            String cfgFile = System.getProperty("fr.dyade.aaa.agent.A3CONF_FILE", "a3servers.xml");
            FileOutputStream fos = new FileOutputStream(new File(cfgDir, cfgFile));
            PrintWriter out = new PrintWriter(fos);
            A3CML.toXML(a3cmlConfig, out);
            out.flush();
            fos.flush();
            fos.getFD().sync();
            out.close();
            fos.close();
        } else {
            a3cmlConfig.save();
        }
    }

    public static class StartFailureException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public StartFailureException(String info) {
            super(info);
        }
    }

    public static class NameAlreadyUsedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NameAlreadyUsedException(String info) {
            super(info);
        }
    }

    public static class ServerIdAlreadyUsedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ServerIdAlreadyUsedException(String info) {
            super(info);
        }
    }
}

