/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.ConfigurationHelper;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.store.DiskStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheManager {
    public static final List ALL_CACHE_MANAGERS = Collections.synchronizedList(new ArrayList());
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager).getName());
    private static CacheManager singleton;
    protected final Map caches = new HashMap();
    private Ehcache defaultCache;
    private String diskStorePath;
    private CacheManagerEventListener cacheManagerEventListener;
    private Status status = Status.STATUS_UNINITIALISED;
    private CacheManagerPeerProvider cacheManagerPeerProvider;
    private CacheManagerPeerListener cacheManagerPeerListener;
    static /* synthetic */ Class class$net$sf$ehcache$CacheManager;

    public CacheManager(Configuration configuration) throws CacheException {
        this.init(configuration, null, null, null);
    }

    public CacheManager(String configurationFileName) throws CacheException {
        this.init(null, configurationFileName, null, null);
    }

    public CacheManager(URL configurationURL) throws CacheException {
        this.init(null, null, configurationURL, null);
    }

    public CacheManager(InputStream configurationInputStream) throws CacheException {
        this.init(null, null, null, configurationInputStream);
    }

    public CacheManager() throws CacheException {
        this.init(null, null, null, null);
    }

    private void init(Configuration configuration, String configurationFileName, URL configurationURL, InputStream configurationInputStream) {
        Configuration localConfiguration = configuration;
        if (configuration == null) {
            localConfiguration = this.parseConfiguration(configurationFileName, configurationURL, configurationInputStream);
        } else {
            localConfiguration.setSource("Programmatically configured.");
        }
        ConfigurationHelper configurationHelper = new ConfigurationHelper(this, localConfiguration);
        this.configure(configurationHelper);
        this.addConfiguredCaches(configurationHelper);
        this.status = Status.STATUS_ALIVE;
        if (this.cacheManagerPeerListener != null) {
            this.cacheManagerPeerListener.init();
        }
        if (this.cacheManagerPeerProvider != null) {
            this.cacheManagerPeerProvider.init();
        }
    }

    private synchronized Configuration parseConfiguration(String configurationFileName, URL configurationURL, InputStream configurationInputStream) throws CacheException {
        String configurationSource;
        Configuration configuration;
        this.reinitialisationCheck();
        if (configurationFileName != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configuring CacheManager from " + configurationFileName);
            }
            configuration = ConfigurationFactory.parseConfiguration(new File(configurationFileName));
            configurationSource = "file located at " + configurationFileName;
        } else if (configurationURL != null) {
            configuration = ConfigurationFactory.parseConfiguration(configurationURL);
            configurationSource = "URL of " + configurationURL;
        } else if (configurationInputStream != null) {
            configuration = ConfigurationFactory.parseConfiguration(configurationInputStream);
            configurationSource = "InputStream " + configurationInputStream;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Configuring ehcache from classpath.");
            }
            configuration = ConfigurationFactory.parseConfiguration();
            configurationSource = "classpath";
        }
        configuration.setSource(configurationSource);
        return configuration;
    }

    private void configure(ConfigurationHelper configurationHelper) {
        this.diskStorePath = configurationHelper.getDiskStorePath();
        this.detectAndFixDiskStorePathConflict(configurationHelper);
        this.cacheManagerEventListener = configurationHelper.createCacheManagerEventListener();
        this.cacheManagerPeerListener = configurationHelper.createCachePeerListener();
        this.detectAndFixCacheManagerPeerListenerConflict(configurationHelper);
        ALL_CACHE_MANAGERS.add(this);
        this.cacheManagerPeerProvider = configurationHelper.createCachePeerProvider();
        this.defaultCache = configurationHelper.createDefaultCache();
    }

    private void detectAndFixDiskStorePathConflict(ConfigurationHelper configurationHelper) {
        for (int i = 0; i < ALL_CACHE_MANAGERS.size(); ++i) {
            CacheManager cacheManager = (CacheManager)ALL_CACHE_MANAGERS.get(i);
            if (!this.diskStorePath.equals(cacheManager.diskStorePath)) continue;
            String newDiskStorePath = this.diskStorePath + File.separator + DiskStore.generateUniqueDirectory();
            LOG.warn("Creating a new instance of CacheManager using the diskStorePath \"" + this.diskStorePath + "\" which is already used" + " by an existing CacheManager.\nThe source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "The diskStore path for this CacheManager will be set to " + newDiskStorePath + ".\nTo avoid this" + " warning consider using the CacheManager factory methods to create a singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance.");
            this.diskStorePath = newDiskStorePath;
            break;
        }
    }

    private void detectAndFixCacheManagerPeerListenerConflict(ConfigurationHelper configurationHelper) {
        if (this.cacheManagerPeerListener == null) {
            return;
        }
        String uniqueResourceIdentifier = this.cacheManagerPeerListener.getUniqueResourceIdentifier();
        for (int i = 0; i < ALL_CACHE_MANAGERS.size(); ++i) {
            String otherUniqueResourceIdentifier;
            CacheManager cacheManager = (CacheManager)ALL_CACHE_MANAGERS.get(i);
            CacheManagerPeerListener otherCacheManagerPeerListener = cacheManager.cacheManagerPeerListener;
            if (otherCacheManagerPeerListener == null || !uniqueResourceIdentifier.equals(otherUniqueResourceIdentifier = otherCacheManagerPeerListener.getUniqueResourceIdentifier())) continue;
            LOG.warn("Creating a new instance of CacheManager with a CacheManagerPeerListener which has a conflict on a resource that must be unique.\nThe resource is " + uniqueResourceIdentifier + ".\n" + "Attempting automatic resolution. The source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "To avoid this warning consider using the CacheManager factory methods to create a " + "singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance.");
            this.cacheManagerPeerListener.attemptResolutionOfUniqueResourceConflict();
            break;
        }
    }

    private void addConfiguredCaches(ConfigurationHelper configurationHelper) {
        Set unitialisedCaches = configurationHelper.createCaches();
        Iterator iterator = unitialisedCaches.iterator();
        while (iterator.hasNext()) {
            Ehcache unitialisedCache = (Ehcache)iterator.next();
            this.addCacheNoCheck(unitialisedCache);
        }
    }

    private void reinitialisationCheck() throws IllegalStateException {
        if (this.defaultCache != null || this.diskStorePath != null || this.caches.size() != 0 || this.status.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("Attempt to reinitialise the CacheManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create() throws CacheException {
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating new CacheManager with default config");
                }
                singleton = new CacheManager();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Attempting to create an existing singleton. Existing singleton returned.");
            }
            return singleton;
        }
    }

    public static CacheManager getInstance() throws CacheException {
        return CacheManager.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(String configurationFileName) throws CacheException {
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating new CacheManager with config file: " + configurationFileName);
                }
                singleton = new CacheManager(configurationFileName);
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(URL configurationFileURL) throws CacheException {
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating new CacheManager with config URL: " + configurationFileURL);
                }
                singleton = new CacheManager(configurationFileURL);
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(InputStream inputStream) throws CacheException {
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            if (singleton == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating new CacheManager with InputStream");
                }
                singleton = new CacheManager(inputStream);
            }
            return singleton;
        }
    }

    public synchronized Cache getCache(String name) throws IllegalStateException, ClassCastException {
        this.checkStatus();
        return (Cache)this.caches.get(name);
    }

    public synchronized Ehcache getEhcache(String name) throws IllegalStateException {
        this.checkStatus();
        return (Ehcache)this.caches.get(name);
    }

    public synchronized void addCache(String cacheName) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        if (this.caches.get(cacheName) != null) {
            throw new ObjectExistsException("Cache " + cacheName + " already exists");
        }
        Ehcache cache = null;
        try {
            cache = (Ehcache)this.defaultCache.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error("Failure adding cache. Initial cause was " + e.getMessage(), e);
        }
        if (cache != null) {
            cache.setName(cacheName);
        }
        this.addCache(cache);
    }

    public synchronized void addCache(Cache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.addCache((Ehcache)cache);
    }

    public synchronized void addCache(Ehcache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        this.addCacheNoCheck(cache);
    }

    private synchronized void addCacheNoCheck(Ehcache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        if (this.caches.get(cache.getName()) != null) {
            throw new ObjectExistsException("Cache " + cache.getName() + " already exists");
        }
        cache.setCacheManager(this);
        cache.setDiskStorePath(this.diskStorePath);
        cache.initialise();
        cache.bootstrap();
        this.caches.put(cache.getName(), cache);
        if (this.cacheManagerEventListener != null) {
            this.cacheManagerEventListener.notifyCacheAdded(cache.getName());
        }
        if (this.cacheManagerPeerListener != null && this.status.equals(Status.STATUS_ALIVE)) {
            this.cacheManagerPeerListener.notifyCacheAdded(cache.getName());
        }
    }

    public synchronized boolean cacheExists(String cacheName) throws IllegalStateException {
        this.checkStatus();
        return this.caches.get(cacheName) != null;
    }

    public synchronized void removalAll() {
        String[] cacheNames = this.getCacheNames();
        for (int i = 0; i < cacheNames.length; ++i) {
            String cacheName = cacheNames[i];
            this.removeCache(cacheName);
        }
    }

    public synchronized void removeCache(String cacheName) throws IllegalStateException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        Ehcache cache = (Ehcache)this.caches.remove(cacheName);
        if (cache != null && cache.getStatus().equals(Status.STATUS_ALIVE)) {
            cache.dispose();
            if (this.cacheManagerEventListener != null) {
                this.cacheManagerEventListener.notifyCacheRemoved(cache.getName());
            }
            if (this.cacheManagerPeerListener != null && this.status.equals(Status.STATUS_ALIVE)) {
                this.cacheManagerPeerListener.notifyCacheRemoved(cache.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("CacheManager already shutdown");
            }
            return;
        }
        if (this.cacheManagerPeerProvider != null) {
            this.cacheManagerPeerProvider.dispose();
        }
        if (this.cacheManagerPeerListener != null) {
            this.cacheManagerPeerListener.dispose();
        }
        Class clazz = class$net$sf$ehcache$CacheManager == null ? (class$net$sf$ehcache$CacheManager = CacheManager.class$("net.sf.ehcache.CacheManager")) : class$net$sf$ehcache$CacheManager;
        synchronized (clazz) {
            ALL_CACHE_MANAGERS.remove(this);
            Collection cacheSet = this.caches.values();
            Iterator iterator = cacheSet.iterator();
            while (iterator.hasNext()) {
                Ehcache cache = (Ehcache)iterator.next();
                if (cache == null) continue;
                cache.dispose();
            }
            this.status = Status.STATUS_SHUTDOWN;
            if (this == singleton) {
                singleton = null;
            }
        }
    }

    public synchronized String[] getCacheNames() throws IllegalStateException {
        this.checkStatus();
        String[] list = new String[this.caches.size()];
        return this.caches.keySet().toArray(list);
    }

    private void checkStatus() {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The CacheManager is not alive.");
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void clearAll() throws CacheException {
        String[] cacheNames = this.getCacheNames();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Clearing all caches");
        }
        for (int i = 0; i < cacheNames.length; ++i) {
            String cacheName = cacheNames[i];
            Ehcache cache = this.getEhcache(cacheName);
            cache.removeAll();
        }
    }

    public CacheManagerPeerProvider getCachePeerProvider() {
        return this.cacheManagerPeerProvider;
    }

    public CacheManagerPeerListener getCachePeerListener() {
        return this.cacheManagerPeerListener;
    }

    public CacheManagerEventListener getCacheManagerEventListener() {
        return this.cacheManagerEventListener;
    }

    public void setCacheManagerEventListener(CacheManagerEventListener cacheManagerEventListener) {
        this.cacheManagerEventListener = cacheManagerEventListener;
    }

    public CacheManagerPeerProvider getCacheManagerPeerProvider() {
        return this.cacheManagerPeerProvider;
    }

    public synchronized void replaceCacheWithDecoratedCache(Ehcache cache, Ehcache decoratedCache) throws CacheException {
        if (!cache.equals(decoratedCache)) {
            throw new CacheException("Cannot replace " + decoratedCache.getName() + " It does not equal the incumbent cache.");
        }
        this.caches.remove(cache.getName());
        this.caches.put(cache.getName(), decoratedCache);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

