/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CachePeer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JNDIManualRMICacheManagerPeerProvider
implements CacheManagerPeerProvider {
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$distribution$JNDIRMICacheManagerPeerListener == null ? (class$net$sf$ehcache$distribution$JNDIRMICacheManagerPeerListener = JNDIManualRMICacheManagerPeerProvider.class$("net.sf.ehcache.distribution.JNDIRMICacheManagerPeerListener")) : class$net$sf$ehcache$distribution$JNDIRMICacheManagerPeerListener).getName());
    protected Map peerUrls = new HashMap();
    protected Map cachePeers = new HashMap();
    private final Object lock = new Object();
    private CacheManager cacheManager;
    private boolean isStashContexts = true;
    private boolean isStashRemoteCachePeers = true;
    static /* synthetic */ Class class$net$sf$ehcache$distribution$JNDIRMICacheManagerPeerListener;

    public JNDIManualRMICacheManagerPeerProvider(boolean isStashContexts, boolean isStashRemoteCachePeers) {
        this.isStashContexts = isStashContexts;
        this.isStashRemoteCachePeers = isStashRemoteCachePeers;
    }

    public JNDIManualRMICacheManagerPeerProvider(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void init() {
    }

    public void registerPeer(String jndiProviderUrl) {
        this.registerPeerToContext(jndiProviderUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPeer(String jndiProviderUrl) {
        Object object = this.lock;
        synchronized (object) {
            this.peerUrls.remove(jndiProviderUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List listRemoteCachePeers(Ehcache cache) throws CacheException {
        ArrayList<CachePeer> remoteCachePeers = new ArrayList<CachePeer>();
        ArrayList<String> staleCachePeers = new ArrayList<String>();
        String jndiProviderUrl = null;
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.peerUrls.keySet().iterator();
            while (iterator.hasNext()) {
                jndiProviderUrl = (String)iterator.next();
                String providerUrlCacheName = JNDIManualRMICacheManagerPeerProvider.extractCacheName(jndiProviderUrl);
                try {
                    if (!providerUrlCacheName.equals(cache.getName())) continue;
                    CachePeer cachePeer = this.lookupCachePeer(jndiProviderUrl);
                    remoteCachePeers.add(cachePeer);
                }
                catch (NamingException ne) {
                    LOG.debug(jndiProviderUrl + " " + ne.getMessage());
                    staleCachePeers.add(jndiProviderUrl);
                }
                catch (Exception ex) {
                    LOG.error(ex.getMessage(), ex);
                    throw new CacheException(jndiProviderUrl + " Unable to list remote cache peers. Error was " + ex.getMessage(), ex);
                }
            }
        }
        if (!staleCachePeers.isEmpty()) {
            this.unregisterStalePeers(staleCachePeers);
        }
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("listRemoteCachePeers " + cache.getName() + " returning " + remoteCachePeers.size() + " " + this.printCachePeers(remoteCachePeers));
            }
            catch (RemoteException e) {
                LOG.warn(e.getMessage(), e);
                LOG.debug("listRemoteCachePeers " + cache.getName() + " returning " + remoteCachePeers.size());
            }
        }
        return remoteCachePeers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws CacheException {
        Object object = this.lock;
        synchronized (object) {
            this.peerUrls.clear();
            this.peerUrls = null;
            this.cachePeers.clear();
            this.cachePeers = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("dispose " + this.toString());
        }
    }

    public long getTimeForClusterToForm() {
        return 0L;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    private Context registerPeerToContext(String jndiProviderUrl) {
        String initialContextFactory = System.getProperty("java.naming.factory.initial");
        if (LOG.isDebugEnabled()) {
            LOG.debug("registerPeerToContext: " + jndiProviderUrl + " " + JNDIManualRMICacheManagerPeerProvider.extractProviderUrl(jndiProviderUrl) + " with " + initialContextFactory);
        }
        Hashtable<String, String> hashTable = new Hashtable<String, String>(1);
        hashTable.put("java.naming.provider.url", JNDIManualRMICacheManagerPeerProvider.extractProviderUrl(jndiProviderUrl));
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext(hashTable);
            this.registerPeerToContext(jndiProviderUrl, initialContext);
        }
        catch (NamingException e) {
            LOG.warn(jndiProviderUrl + " " + e.getMessage());
            this.registerPeerToContext(jndiProviderUrl, null);
        }
        return initialContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPeerToContext(String jndiProviderUrl, Context context) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStashContexts) {
                this.peerUrls.put(jndiProviderUrl, context);
            } else {
                this.peerUrls.put(jndiProviderUrl, null);
            }
        }
    }

    private static String extractCacheName(String jndiProviderUrl) {
        return jndiProviderUrl.substring(jndiProviderUrl.lastIndexOf(47) + 1);
    }

    private static String extractProviderUrl(String jndiProviderUrl) {
        return jndiProviderUrl.substring(0, jndiProviderUrl.lastIndexOf(47));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context getContext(String jndiProviderUrl) {
        if (this.isStashContexts) {
            Object object = this.lock;
            synchronized (object) {
                return (Context)this.peerUrls.get(jndiProviderUrl);
            }
        }
        return null;
    }

    private void unregisterStalePeers(List staleCachePeers) {
        Iterator iterator = staleCachePeers.iterator();
        while (iterator.hasNext()) {
            String jndiProviderUrl = (String)iterator.next();
            this.registerPeerToContext(jndiProviderUrl, null);
            this.registerCachePeer(jndiProviderUrl, null);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("unregisterStalePeers " + jndiProviderUrl);
        }
    }

    private CachePeer lookupCachePeer(String jndiProviderUrl) throws NamingException {
        CachePeer cachePeer = this.getCachePeer(jndiProviderUrl);
        boolean isAlreadyLookedupRemoteCachePeer = false;
        if (cachePeer == null) {
            cachePeer = this.lookupRemoteCachePeer(jndiProviderUrl);
            if (cachePeer == null) {
                String msg = "cachePeer null after lookup " + jndiProviderUrl;
                LOG.debug(msg);
                throw new NamingException(msg);
            }
            isAlreadyLookedupRemoteCachePeer = true;
        }
        cachePeer = this.getNonStaleCachePeer(jndiProviderUrl, cachePeer, isAlreadyLookedupRemoteCachePeer);
        this.registerCachePeer(jndiProviderUrl, cachePeer);
        return cachePeer;
    }

    private CachePeer getNonStaleCachePeer(String jndiProviderUrl, CachePeer cachePeer, boolean isAlreadyLookedupRemoteCachePeer) throws NamingException {
        boolean isStale = this.isStale(cachePeer);
        CachePeer localCachePeer = null;
        if (isStale) {
            if (!isAlreadyLookedupRemoteCachePeer) {
                LOG.debug("CachePeer is stale, looking it up again " + jndiProviderUrl);
                localCachePeer = this.lookupRemoteCachePeer(jndiProviderUrl);
                if (!this.isStale(localCachePeer)) {
                    isStale = false;
                }
            }
        } else {
            localCachePeer = cachePeer;
        }
        if (isStale) {
            String msg = "After lookup CachePeer is stale " + jndiProviderUrl;
            LOG.info(msg);
            throw new NamingException(msg);
        }
        return localCachePeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachePeer getCachePeer(String jndiProviderUrl) {
        if (this.isStashRemoteCachePeers) {
            Object object = this.lock;
            synchronized (object) {
                return (CachePeer)this.cachePeers.get(jndiProviderUrl);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCachePeer(String jndiProviderUrl, CachePeer cachePeer) {
        if (this.isStashRemoteCachePeers) {
            Object object = this.lock;
            synchronized (object) {
                this.cachePeers.put(jndiProviderUrl, cachePeer);
            }
        }
    }

    private CachePeer lookupRemoteCachePeer(String jndiProviderUrl) throws NamingException {
        Context context = this.getContext(jndiProviderUrl);
        if (context == null) {
            context = this.registerPeerToContext(jndiProviderUrl);
        }
        return (CachePeer)context.lookup(JNDIManualRMICacheManagerPeerProvider.extractCacheName(jndiProviderUrl));
    }

    private boolean isStale(CachePeer cachePeer) {
        try {
            cachePeer.getName();
        }
        catch (RemoteException re) {
            return true;
        }
        return false;
    }

    private StringBuffer printCachePeers(List cachePeers) throws RemoteException {
        Iterator iterator = cachePeers.iterator();
        StringBuffer sb = new StringBuffer();
        sb.append("CachePeers=[");
        while (iterator.hasNext()) {
            CachePeer cachePeer = (CachePeer)iterator.next();
            sb.append(" ").append(cachePeer.toString());
        }
        sb.append("]");
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(super.toString()).append(" cacheManager=").append(this.cacheManager).append(" isStashContexts=").append(this.isStashContexts).append(" isStashRemoteCachePeers=").append(this.isStashRemoteCachePeers);
        Object object = this.lock;
        synchronized (object) {
            buff.append(" peerUrls=").append(this.peerUrls).append(" cachePeers=").append(this.cachePeers);
        }
        return buff.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

