/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.builder;

import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPBuilder;
import org.apache.axiom.om.util.ElementHelper;

public class XOPAwareStAXOMBuilder
extends StAXOMBuilder
implements XOPBuilder {
    Attachments attachments;

    public XOPAwareStAXOMBuilder(OMFactory ombuilderFactory, XMLStreamReader parser2, Attachments attachments) {
        super(ombuilderFactory, parser2);
        this.attachments = attachments;
    }

    public XOPAwareStAXOMBuilder(OMFactory factory, XMLStreamReader parser2, OMElement element, Attachments attachments) {
        super(factory, parser2, element);
        this.attachments = attachments;
    }

    public XOPAwareStAXOMBuilder(String filePath, Attachments attachments) throws XMLStreamException, FileNotFoundException {
        super(filePath);
        this.attachments = attachments;
    }

    public XOPAwareStAXOMBuilder(InputStream inStream, Attachments attachments) throws XMLStreamException {
        super(inStream);
        this.attachments = attachments;
    }

    public XOPAwareStAXOMBuilder(XMLStreamReader parser2, Attachments attachments) {
        super(parser2);
        this.attachments = attachments;
    }

    protected OMNode createOMElement() throws OMException {
        String elementName = this.parser.getLocalName();
        String namespaceURI = this.parser.getNamespaceURI();
        if ("Include".equals(elementName) && "http://www.w3.org/2004/08/xop/include".equals(namespaceURI)) {
            OMText node;
            String contentID = ElementHelper.getContentID(this.parser, this.getDocument().getCharsetEncoding());
            if (this.lastNode == null) {
                throw new OMException("XOP:Include element is not supported here");
            }
            if (this.lastNode.isComplete() & this.lastNode.getParent() != null) {
                node = this.omfactory.createOMText(contentID, (OMElement)this.lastNode.getParent(), this);
                ((OMNodeEx)this.lastNode).setNextOMSibling(node);
                ((OMNodeEx)((Object)node)).setPreviousOMSibling(this.lastNode);
            } else {
                OMContainerEx e = (OMContainerEx)((Object)this.lastNode);
                node = this.omfactory.createOMText(contentID, (OMElement)this.lastNode, this);
                e.setFirstChild(node);
            }
            return node;
        }
        return super.createOMElement();
    }

    public DataHandler getDataHandler(String blobContentID) throws OMException {
        return this.attachments.getDataHandler(blobContentID);
    }
}

