/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler.ant;

import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.commons.modeler.ant.Arg;
import org.apache.tools.ant.Task;

public class JmxInvoke
extends Task {
    String objectName;
    String method;
    Vector args;

    public void setObjectName(String name) {
        this.objectName = name;
    }

    public void setOperation(String method) {
        this.method = method;
    }

    public void execute() {
        try {
            MBeanServer server = (MBeanServer)this.project.getReference("jmx.server");
            if (server == null) {
                if (MBeanServerFactory.findMBeanServer(null).size() > 0) {
                    server = MBeanServerFactory.findMBeanServer(null).get(0);
                } else {
                    System.out.println("Creating mbean server");
                    server = MBeanServerFactory.createMBeanServer();
                }
                this.project.addReference("jmx.server", server);
            }
            ObjectName oname = new ObjectName(this.objectName);
            if (this.args == null) {
                server.invoke(oname, this.method, null, null);
            } else {
                Object[] argsA = new Object[this.args.size()];
                String[] sigA = new String[this.args.size()];
                for (int i = 0; i < this.args.size(); ++i) {
                    Arg arg = (Arg)this.args.elementAt(i);
                    if (arg.type == null) {
                        arg.type = "java.lang.String";
                    }
                    sigA[i] = arg.getType();
                    argsA[i] = arg.getValue();
                }
                server.invoke(oname, this.method, argsA, sigA);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

