/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import org.apache.cxf.configuration.spring.AbstractBeanDefinitionParser;
import org.apache.cxf.configuration.spring.BusWiringType;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractFactoryBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected void doParse(Element element, ParserContext ctx, BeanDefinitionBuilder bean) {
        BeanDefinitionBuilder factoryBean = BeanDefinitionBuilder.rootBeanDefinition(this.getFactoryClass());
        NamedNodeMap atts = element.getAttributes();
        boolean createdFromAPI = false;
        boolean setBus = false;
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr node = (Attr)atts.item(i);
            String val = node.getValue();
            String pre = node.getPrefix();
            String name = node.getLocalName();
            if ("createdFromAPI".equals(name)) {
                factoryBean.setAbstract(true);
                bean.setAbstract(true);
                createdFromAPI = true;
                continue;
            }
            if ("abstract".equals(name)) {
                factoryBean.setAbstract(true);
                bean.setAbstract(true);
                continue;
            }
            if ("id".equals(name) || "name".equals(name) || !this.isAttribute(pre, name)) continue;
            if ("bus".equals(name)) {
                setBus = true;
            }
            this.mapAttribute(factoryBean, element, name, val);
        }
        if (!setBus) {
            this.addBusWiringAttribute(factoryBean, BusWiringType.PROPERTY);
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            String name = node.getLocalName();
            this.mapElement(ctx, factoryBean, (Element)node, name);
        }
        String id = this.getIdOrName(element);
        if (createdFromAPI) {
            id = id + this.getSuffix();
        }
        String factoryId = id + this.getFactoryIdSuffix();
        ctx.getRegistry().registerBeanDefinition(factoryId, factoryBean.getBeanDefinition());
        bean.getBeanDefinition().setAttribute("id", id);
        bean.setFactoryBean(factoryId, "create");
    }

    protected abstract Class getFactoryClass();

    protected abstract String getFactoryIdSuffix();
}

