/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.spi;

import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.spi.ServiceDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.EndpointUtils;
import org.apache.cxf.jaxws.ServiceImpl;

public class ProviderImpl
extends Provider {
    public static final String JAXWS_PROVIDER = ProviderImpl.class.getName();
    private static final Logger LOG = LogUtils.getL7dLogger(ProviderImpl.class);

    public ServiceDelegate createServiceDelegate(URL url, QName qname, Class cls) {
        Bus bus = BusFactory.getThreadDefaultBus();
        return new ServiceImpl(bus, url, qname, cls);
    }

    public Endpoint createEndpoint(String bindingId, Object implementor) {
        EndpointImpl ep = null;
        if (EndpointUtils.isValidImplementor(implementor)) {
            Bus bus = BusFactory.getThreadDefaultBus();
            ep = new EndpointImpl(bus, implementor, bindingId);
            return ep;
        }
        throw new WebServiceException(new Message("INVALID_IMPLEMENTOR_EXC", LOG, new Object[0]).toString());
    }

    public Endpoint createAndPublishEndpoint(String url, Object implementor) {
        Endpoint ep = this.createEndpoint(null, implementor);
        ep.publish(url);
        return ep;
    }
}

