/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.jdbc.DynamicQuery;

class FindBusinessByNameQuery {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$datastore$jdbc$FindBusinessByNameQuery == null ? (class$org$apache$juddi$datastore$jdbc$FindBusinessByNameQuery = FindBusinessByNameQuery.class$("org.apache.juddi.datastore.jdbc.FindBusinessByNameQuery")) : class$org$apache$juddi$datastore$jdbc$FindBusinessByNameQuery);
    static String selectSQL;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$FindBusinessByNameQuery;

    FindBusinessByNameQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(Vector names, Vector keysIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        Vector<String> vector;
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindBusinessByNameQuery.appendWhere(sql, names, qualifiers);
        FindBusinessByNameQuery.appendIn(sql, keysIn);
        FindBusinessByNameQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug(sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keysOut.addElement(resultSet.getString(1));
            }
            vector = keysOut;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage(), e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage(), e);
            }
            throw throwable;
        }
        try {
            resultSet.close();
        }
        catch (Exception e) {
            log.warn("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage(), e);
        }
        try {
            statement.close();
        }
        catch (Exception e) {
            log.warn("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage(), e);
        }
        return vector;
    }

    private static void appendWhere(DynamicQuery sql, Vector names, FindQualifiers qualifiers) {
        sql.append("WHERE B.BUSINESS_KEY = N.BUSINESS_KEY ");
        if (names != null) {
            int nameSize = names.size();
            if (nameSize > 0) {
                sql.append("AND (");
                for (int i = 0; i < nameSize; ++i) {
                    Name name = (Name)names.elementAt(i);
                    String text = name.getValue();
                    String lang = name.getLanguageCode();
                    if (text == null || text.length() <= 0) continue;
                    if (qualifiers == null) {
                        sql.append("(UPPER(NAME) LIKE ?");
                        sql.addValue(text.endsWith("%") ? text.toUpperCase() : text.toUpperCase() + "%");
                    } else if (qualifiers.caseSensitiveMatch && qualifiers.exactNameMatch) {
                        sql.append("(NAME = ?");
                        sql.addValue(text);
                    } else if (!qualifiers.caseSensitiveMatch && qualifiers.exactNameMatch) {
                        sql.append("(UPPER(NAME) = ?");
                        sql.addValue(text.toUpperCase());
                    } else if (qualifiers.caseSensitiveMatch && !qualifiers.exactNameMatch) {
                        sql.append("(NAME LIKE ?");
                        sql.addValue(text.endsWith("%") ? text : text + "%");
                    } else if (!qualifiers.caseSensitiveMatch && !qualifiers.exactNameMatch) {
                        sql.append("(UPPER(NAME) LIKE ?");
                        sql.addValue(text.endsWith("%") ? text.toUpperCase() : text.toUpperCase() + "%");
                    }
                    if (lang != null && lang.length() > 0) {
                        sql.append(" AND (UPPER(LANG_CODE) LIKE ?)");
                        sql.addValue(lang.toUpperCase() + "%");
                    }
                    sql.append(")");
                    if (i + 1 >= nameSize) continue;
                    sql.append(" OR ");
                }
            }
            sql.append(") ");
        }
    }

    private static void appendIn(DynamicQuery sql, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        sql.append("AND B.BUSINESS_KEY IN (");
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null || !qualifiers.sortByNameAsc && !qualifiers.sortByNameDesc && !qualifiers.sortByDateAsc && !qualifiers.sortByDateDesc) {
            sql.append("N.NAME ASC,B.LAST_UPDATE DESC");
        } else if (qualifiers.sortByNameAsc || qualifiers.sortByNameDesc) {
            if (qualifiers.sortByDateAsc || qualifiers.sortByDateDesc) {
                if (qualifiers.sortByNameAsc && qualifiers.sortByDateDesc) {
                    sql.append("N.NAME ASC,B.LAST_UPDATE DESC");
                } else if (qualifiers.sortByNameAsc && qualifiers.sortByDateAsc) {
                    sql.append("N.NAME ASC,B.LAST_UPDATE ASC");
                } else if (qualifiers.sortByNameDesc && qualifiers.sortByDateDesc) {
                    sql.append("N.NAME DESC,B.LAST_UPDATE DESC");
                } else {
                    sql.append("N.NAME DESC,B.LAST_UPDATE ASC");
                }
            } else if (qualifiers.sortByNameAsc) {
                sql.append("N.NAME ASC,B.LAST_UPDATE DESC");
            } else {
                sql.append("N.NAME DESC,B.LAST_UPDATE DESC");
            }
        } else if (qualifiers.sortByDateAsc || qualifiers.sortByDateDesc) {
            if (qualifiers.sortByDateDesc) {
                sql.append("B.LAST_UPDATE ASC,N.NAME ASC");
            } else {
                sql.append("B.LAST_UPDATE DESC,N.NAME ASC");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT B.BUSINESS_KEY,B.LAST_UPDATE,N.NAME ");
        sql.append("FROM BUSINESS_ENTITY B,BUSINESS_NAME N ");
        selectSQL = sql.toString();
    }
}

