/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.function;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.DataStore;
import org.apache.juddi.datastore.DataStoreFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.publisher.Publisher;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.SavePublisher;
import org.apache.juddi.datatype.response.PublisherDetail;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.function.AbstractFunction;
import org.apache.juddi.registry.RegistryEngine;
import org.apache.juddi.util.Config;

public class SavePublisherFunction
extends AbstractFunction {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$function$SavePublisherFunction == null ? (class$org$apache$juddi$function$SavePublisherFunction = SavePublisherFunction.class$("org.apache.juddi.function.SavePublisherFunction")) : class$org$apache$juddi$function$SavePublisherFunction);
    static /* synthetic */ Class class$org$apache$juddi$function$SavePublisherFunction;

    public SavePublisherFunction(RegistryEngine registry) {
        super(registry);
    }

    public RegistryObject execute(RegistryObject regObject) throws RegistryException {
        SavePublisher request = (SavePublisher)regObject;
        String generic = request.getGeneric();
        AuthInfo authInfo = request.getAuthInfo();
        Vector publisherVector = request.getPublisherVector();
        DataStore dataStore = DataStoreFactory.getDataStore();
        try {
            String pubID;
            Publisher pub;
            int i;
            dataStore.beginTrans();
            Publisher publisher = this.getPublisher(authInfo, dataStore);
            String publisherID = publisher.getPublisherID();
            if (!dataStore.isAdministrator(publisherID)) {
                throw new RegistryException("Invalid Operation, You must have administrative priveledges to create a new publisher account.");
            }
            for (i = 0; i < publisherVector.size(); ++i) {
                pub = (Publisher)publisherVector.elementAt(i);
                pubID = pub.getPublisherID();
                if (pubID != null && pubID.length() != 0) continue;
                throw new RegistryException("A valid Publisher ID was not specified: " + pubID);
            }
            for (i = 0; i < publisherVector.size(); ++i) {
                pub = (Publisher)publisherVector.elementAt(i);
                pubID = pub.getPublisherID();
                dataStore.deletePublisher(pubID);
                dataStore.savePublisher(pub);
            }
            dataStore.commit();
            PublisherDetail detail = new PublisherDetail();
            detail.setGeneric(generic);
            detail.setOperator(Config.getOperator());
            detail.setTruncated(false);
            detail.setPublisherVector(publisherVector);
            PublisherDetail publisherDetail = detail;
            return publisherDetail;
        }
        catch (RegistryException regex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(regex);
            throw regex;
        }
        catch (Exception ex) {
            try {
                dataStore.rollback();
            }
            catch (Exception e) {
                // empty catch block
            }
            log.error(ex);
            throw new RegistryException(ex);
        }
        finally {
            if (dataStore != null) {
                dataStore.release();
            }
        }
    }

    public static void main(String[] args) {
        RegistryEngine reg = new RegistryEngine();
        reg.init();
        reg.dispose();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

