/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.validator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.Loader;
import org.apache.juddi.validator.Validator;

public class ValidatorFactory {
    private static Log log = LogFactory.getLog(class$org$apache$juddi$validator$ValidatorFactory == null ? (class$org$apache$juddi$validator$ValidatorFactory = ValidatorFactory.class$("org.apache.juddi.validator.ValidatorFactory")) : class$org$apache$juddi$validator$ValidatorFactory);
    private static final String IMPL_KEY = "juddi.validation";
    private static final String DEFAULT_IMPL = "org.apache.juddi.validation.DefaultValidation";
    private static Validator validation = null;
    static /* synthetic */ Class class$org$apache$juddi$validator$ValidatorFactory;

    public static Validator getValidation() {
        if (validation == null) {
            validation = ValidatorFactory.createValidation();
        }
        return validation;
    }

    private static synchronized Validator createValidation() {
        if (validation != null) {
            return validation;
        }
        String className = Config.getStringProperty(IMPL_KEY, DEFAULT_IMPL);
        log.debug("Validation Implementation = " + className);
        Class implClass = null;
        try {
            implClass = Loader.getClassForName(className);
        }
        catch (ClassNotFoundException e) {
            log.error("The specified Validation class '" + className + "' was not found in classpath.");
            log.error(e);
        }
        try {
            validation = (Validator)implClass.newInstance();
        }
        catch (Exception e) {
            log.error("Exception while attempting to instantiate the implementation of Validation: " + implClass.getName() + "\n" + e.getMessage());
            log.error(e);
        }
        return validation;
    }

    public static void main(String[] args) throws Exception {
        Validator validation = ValidatorFactory.getValidation();
        if (validation != null) {
            System.out.println("Got a Validation instance: " + validation.getClass().getName());
            if (validation.validate(new CategoryBag())) {
                System.out.println("The objct was successfully validated.");
            } else {
                System.out.println("Sorry validation failed.");
            }
        } else {
            System.out.println("Couldn't get a Validation instance.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

