/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.action.EntityIdentityInsertAction;
import org.hibernate.action.EntityInsertAction;
import org.hibernate.classic.Lifecycle;
import org.hibernate.classic.Validatable;
import org.hibernate.engine.Cascade;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Nullability;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.engine.Versioning;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.AbstractReassociateEventListener;
import org.hibernate.event.def.WrapVisitor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaveEventListener
extends AbstractReassociateEventListener {
    protected static final int PERSISTENT = 0;
    protected static final int TRANSIENT = 1;
    protected static final int DETACHED = 2;
    protected static final int DELETED = 3;
    private static final Logger log = LoggerFactory.getLogger(AbstractSaveEventListener.class);

    protected Serializable saveWithRequestedId(Object entity, Serializable requestedId, String entityName, Object anything, EventSource source) {
        return this.performSave(entity, requestedId, source.getEntityPersister(entityName, entity), false, anything, source, true);
    }

    protected Serializable saveWithGeneratedId(Object entity, String entityName, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        EntityPersister persister = source.getEntityPersister(entityName, entity);
        Serializable generatedId = persister.getIdentifierGenerator().generate(source, entity);
        if (generatedId == null) {
            throw new IdentifierGenerationException("null id generated for:" + entity.getClass());
        }
        if (generatedId == IdentifierGeneratorFactory.SHORT_CIRCUIT_INDICATOR) {
            return source.getIdentifier(entity);
        }
        if (generatedId == IdentifierGeneratorFactory.POST_INSERT_INDICATOR) {
            return this.performSave(entity, null, persister, true, anything, source, requiresImmediateIdAccess);
        }
        if (log.isDebugEnabled()) {
            log.debug("generated identifier: " + persister.getIdentifierType().toLoggableString(generatedId, source.getFactory()) + ", using strategy: " + persister.getIdentifierGenerator().getClass().getName());
        }
        return this.performSave(entity, generatedId, persister, false, anything, source, true);
    }

    protected Serializable performSave(Object entity, Serializable id, EntityPersister persister, boolean useIdentityColumn, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        EntityKey key;
        if (log.isTraceEnabled()) {
            log.trace("saving " + MessageHelper.infoString(persister, id, source.getFactory()));
        }
        if (!useIdentityColumn) {
            key = new EntityKey(id, persister, source.getEntityMode());
            Object old = source.getPersistenceContext().getEntity(key);
            if (old != null) {
                if (source.getPersistenceContext().getEntry(old).getStatus() == Status.DELETED) {
                    source.forceFlush(source.getPersistenceContext().getEntry(old));
                } else {
                    throw new NonUniqueObjectException(id, persister.getEntityName());
                }
            }
            persister.setIdentifier(entity, id, source.getEntityMode());
        } else {
            key = null;
        }
        if (this.invokeSaveLifecycle(entity, persister, source)) {
            return id;
        }
        return this.performSaveOrReplicate(entity, key, persister, useIdentityColumn, anything, source, requiresImmediateIdAccess);
    }

    protected boolean invokeSaveLifecycle(Object entity, EntityPersister persister, EventSource source) {
        if (persister.implementsLifecycle(source.getEntityMode())) {
            log.debug("calling onSave()");
            if (((Lifecycle)entity).onSave(source)) {
                log.debug("insertion vetoed by onSave()");
                return true;
            }
        }
        return false;
    }

    protected void validate(Object entity, EntityPersister persister, EventSource source) {
        if (persister.implementsValidatable(source.getEntityMode())) {
            ((Validatable)entity).validate();
        }
    }

    protected Serializable performSaveOrReplicate(Object entity, EntityKey key, EntityPersister persister, boolean useIdentityColumn, Object anything, EventSource source, boolean requiresImmediateIdAccess) {
        boolean shouldDelayIdentityInserts;
        this.validate(entity, persister, source);
        Serializable id = key == null ? null : key.getIdentifier();
        boolean inTxn = source.getJDBCContext().isTransactionInProgress();
        boolean bl = shouldDelayIdentityInserts = !inTxn && !requiresImmediateIdAccess;
        if (useIdentityColumn && !shouldDelayIdentityInserts) {
            log.trace("executing insertions");
            source.getActionQueue().executeInserts();
        }
        source.getPersistenceContext().addEntry(entity, Status.SAVING, null, null, id, null, LockMode.WRITE, useIdentityColumn, persister, false, false);
        this.cascadeBeforeSave(source, persister, entity, anything);
        Object[] values = persister.getPropertyValuesToInsert(entity, this.getMergeMap(anything), source);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.substituteValuesIfNecessary(entity, id, values, persister, source);
        if (persister.hasCollections()) {
            boolean bl2 = substitute = substitute || this.visitCollectionsBeforeSave(entity, id, values, types, source);
        }
        if (substitute) {
            persister.setPropertyValues(entity, values, source.getEntityMode());
        }
        TypeFactory.deepCopy(values, types, persister.getPropertyUpdateability(), values, source);
        new ForeignKeys.Nullifier(entity, false, useIdentityColumn, source).nullifyTransientReferences(values, types);
        new Nullability(source).checkNullability(values, persister, false);
        if (useIdentityColumn) {
            EntityIdentityInsertAction insert = new EntityIdentityInsertAction(values, entity, persister, source, shouldDelayIdentityInserts);
            if (!shouldDelayIdentityInserts) {
                log.debug("executing identity-insert immediately");
                source.getActionQueue().execute(insert);
                id = insert.getGeneratedId();
                key = new EntityKey(id, persister, source.getEntityMode());
                source.getPersistenceContext().checkUniqueness(key, entity);
            } else {
                log.debug("delaying identity-insert due to no transaction in progress");
                source.getActionQueue().addAction(insert);
                key = insert.getDelayedEntityKey();
            }
        }
        Object version2 = Versioning.getVersion(values, persister);
        source.getPersistenceContext().addEntity(entity, Status.MANAGED, values, key, version2, LockMode.WRITE, useIdentityColumn, persister, this.isVersionIncrementDisabled(), false);
        if (!useIdentityColumn) {
            source.getActionQueue().addAction(new EntityInsertAction(id, values, entity, version2, persister, source));
        }
        this.cascadeAfterSave(source, persister, entity, anything);
        this.markInterceptorDirty(entity, persister, source);
        return id;
    }

    private void markInterceptorDirty(Object entity, EntityPersister persister, EventSource source) {
        if (FieldInterceptionHelper.isInstrumented(entity)) {
            FieldInterceptor interceptor = FieldInterceptionHelper.injectFieldInterceptor(entity, persister.getEntityName(), null, source);
            interceptor.dirty();
        }
    }

    protected Map getMergeMap(Object anything) {
        return null;
    }

    protected boolean isVersionIncrementDisabled() {
        return false;
    }

    protected boolean visitCollectionsBeforeSave(Object entity, Serializable id, Object[] values, Type[] types, EventSource source) {
        WrapVisitor visitor = new WrapVisitor(source);
        visitor.processEntityPropertyValues(values, types);
        return visitor.isSubstitutionRequired();
    }

    protected boolean substituteValuesIfNecessary(Object entity, Serializable id, Object[] values, EntityPersister persister, SessionImplementor source) {
        boolean substitute = source.getInterceptor().onSave(entity, id, values, persister.getPropertyNames(), persister.getPropertyTypes());
        if (persister.isVersioned()) {
            substitute = Versioning.seedVersion(values, persister.getVersionProperty(), persister.getVersionType(), source) || substitute;
        }
        return substitute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeBeforeSave(EventSource source, EntityPersister persister, Object entity, Object anything) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 2, source).cascade(persister, entity, anything);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cascadeAfterSave(EventSource source, EntityPersister persister, Object entity, Object anything) {
        source.getPersistenceContext().incrementCascadeLevel();
        try {
            new Cascade(this.getCascadeAction(), 1, source).cascade(persister, entity, anything);
        }
        finally {
            source.getPersistenceContext().decrementCascadeLevel();
        }
    }

    protected abstract CascadingAction getCascadeAction();

    protected int getEntityState(Object entity, String entityName, EntityEntry entry, SessionImplementor source) {
        if (entry != null) {
            if (entry.getStatus() != Status.DELETED) {
                if (log.isTraceEnabled()) {
                    log.trace("persistent instance of: " + this.getLoggableName(entityName, entity));
                }
                return 0;
            }
            if (log.isTraceEnabled()) {
                log.trace("deleted instance of: " + this.getLoggableName(entityName, entity));
            }
            return 3;
        }
        if (ForeignKeys.isTransient(entityName, entity, this.getAssumedUnsaved(), source)) {
            if (log.isTraceEnabled()) {
                log.trace("transient instance of: " + this.getLoggableName(entityName, entity));
            }
            return 1;
        }
        if (log.isTraceEnabled()) {
            log.trace("detached instance of: " + this.getLoggableName(entityName, entity));
        }
        return 2;
    }

    protected String getLoggableName(String entityName, Object entity) {
        return entityName == null ? entity.getClass().getName() : entityName;
    }

    protected Boolean getAssumedUnsaved() {
        return null;
    }
}

