/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.configuration;

import java.util.Properties;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;

public abstract class ConfigurationParseHelper {
    public static final int parseInt(String value, String errorMsgOnParseFailure) {
        if (value == null) {
            throw new SearchException(errorMsgOnParseFailure);
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nfe) {
            throw new SearchException(errorMsgOnParseFailure, nfe);
        }
    }

    public static final int parseInt(String value, int defValue, String errorMsgOnParseFailure) {
        if (StringHelper.isEmpty(value)) {
            return defValue;
        }
        return ConfigurationParseHelper.parseInt(value, errorMsgOnParseFailure);
    }

    public static final int getIntValue(Properties cfg, String key, int defValue) {
        String propValue = cfg.getProperty(key);
        return ConfigurationParseHelper.parseInt(propValue, defValue, "Unable to parse " + key + ": " + propValue);
    }
}

