/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.Workspace;
import org.hibernate.search.backend.impl.lucene.LuceneWorker;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneBackendQueueProcessor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(LuceneBackendQueueProcessor.class);
    private final List<LuceneWork> queue;
    private final SearchFactoryImplementor searchFactoryImplementor;

    public LuceneBackendQueueProcessor(List<LuceneWork> queue, SearchFactoryImplementor searchFactoryImplementor) {
        this.queue = queue;
        this.searchFactoryImplementor = searchFactoryImplementor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Workspace workspace = new Workspace(this.searchFactoryImplementor);
        LuceneWorker worker = new LuceneWorker(workspace);
        try {
            ArrayList<LuceneWorker.WorkWithPayload> queueWithFlatDPs = new ArrayList<LuceneWorker.WorkWithPayload>(this.queue.size() * 2);
            for (LuceneWork work : this.queue) {
                DirectoryProvider[] providers;
                DocumentBuilder<Object> documentBuilder = this.searchFactoryImplementor.getDocumentBuilders().get(work.getEntityClass());
                IndexShardingStrategy shardingStrategy = documentBuilder.getDirectoryProviderSelectionStrategy();
                if (PurgeAllLuceneWork.class.isAssignableFrom(work.getClass())) {
                    for (DirectoryProvider provider : providers = shardingStrategy.getDirectoryProvidersForDeletion(work.getEntityClass(), work.getId(), work.getIdInString())) {
                        queueWithFlatDPs.add(new LuceneWorker.WorkWithPayload(work, provider));
                    }
                    continue;
                }
                if (AddLuceneWork.class.isAssignableFrom(work.getClass())) {
                    DirectoryProvider provider = shardingStrategy.getDirectoryProviderForAddition(work.getEntityClass(), work.getId(), work.getIdInString(), work.getDocument());
                    queueWithFlatDPs.add(new LuceneWorker.WorkWithPayload(work, provider));
                    continue;
                }
                if (DeleteLuceneWork.class.isAssignableFrom(work.getClass())) {
                    for (DirectoryProvider provider : providers = shardingStrategy.getDirectoryProvidersForDeletion(work.getEntityClass(), work.getId(), work.getIdInString())) {
                        queueWithFlatDPs.add(new LuceneWorker.WorkWithPayload(work, provider));
                    }
                    continue;
                }
                if (OptimizeLuceneWork.class.isAssignableFrom(work.getClass())) {
                    for (DirectoryProvider provider : providers = shardingStrategy.getDirectoryProvidersForAllShards()) {
                        queueWithFlatDPs.add(new LuceneWorker.WorkWithPayload(work, provider));
                    }
                    continue;
                }
                throw new AssertionFailure("Unknown work type: " + work.getClass());
            }
            this.deadlockFreeQueue(queueWithFlatDPs, this.searchFactoryImplementor);
            this.checkForBatchIndexing(workspace);
            for (LuceneWorker.WorkWithPayload luceneWork : queueWithFlatDPs) {
                worker.performWork(luceneWork);
            }
        }
        finally {
            workspace.clean();
            this.queue.clear();
        }
    }

    private void checkForBatchIndexing(Workspace workspace) {
        for (LuceneWork luceneWork : this.queue) {
            if (!luceneWork.isBatch()) continue;
            log.trace("Setting batch indexing mode.");
            workspace.setBatch(true);
            break;
        }
    }

    private void deadlockFreeQueue(List<LuceneWorker.WorkWithPayload> queue, final SearchFactoryImplementor searchFactoryImplementor) {
        Collections.sort(queue, new Comparator<LuceneWorker.WorkWithPayload>(){

            @Override
            public int compare(LuceneWorker.WorkWithPayload o1, LuceneWorker.WorkWithPayload o2) {
                long h2;
                long h1 = LuceneBackendQueueProcessor.this.getWorkHashCode(o1, searchFactoryImplementor);
                return h1 < (h2 = LuceneBackendQueueProcessor.this.getWorkHashCode(o2, searchFactoryImplementor)) ? -1 : (h1 == h2 ? 0 : 1);
            }
        });
    }

    private long getWorkHashCode(LuceneWorker.WorkWithPayload luceneWork, SearchFactoryImplementor searchFactoryImplementor) {
        DirectoryProvider provider = luceneWork.getProvider();
        int h = provider.getClass().hashCode();
        h = 31 * h + provider.hashCode();
        long extendedHash = h;
        if (luceneWork.getWork() instanceof AddLuceneWork) {
            ++extendedHash;
        }
        if (luceneWork.getWork() instanceof OptimizeLuceneWork) {
            extendedHash += 2L;
        }
        return extendedHash;
    }
}

