/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.filter;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Filter;
import org.hibernate.util.SoftLimitMRUCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingWrapperFilter
extends Filter {
    private final Logger log = LoggerFactory.getLogger(CachingWrapperFilter.class);
    public static final int DEFAULT_SIZE = 5;
    private final int size;
    private transient SoftLimitMRUCache cache;
    private Filter filter;

    public CachingWrapperFilter(Filter filter) {
        this(filter, 5);
    }

    public CachingWrapperFilter(Filter filter, int size) {
        this.filter = filter;
        this.size = size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader reader) throws IOException {
        if (this.cache == null) {
            this.log.debug("Initialising SoftLimitMRUCache with hard ref size of {}", this.size);
            this.cache = new SoftLimitMRUCache(this.size);
        }
        SoftLimitMRUCache softLimitMRUCache = this.cache;
        synchronized (softLimitMRUCache) {
            BitSet cached = (BitSet)this.cache.get(reader);
            if (cached != null) {
                return cached;
            }
        }
        BitSet bits = this.filter.bits(reader);
        SoftLimitMRUCache softLimitMRUCache2 = this.cache;
        synchronized (softLimitMRUCache2) {
            this.cache.put(reader, bits);
        }
        return bits;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingWrapperFilter)) {
            return false;
        }
        return this.filter.equals(((CachingWrapperFilter)o).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

