/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSDirectoryProvider
implements DirectoryProvider<FSDirectory> {
    private final Logger log = LoggerFactory.getLogger(FSDirectoryProvider.class);
    private FSDirectory directory;
    private String indexName;

    @Override
    public void initialize(String directoryProviderName, Properties properties, SearchFactoryImplementor searchFactoryImplementor) {
        boolean manual = searchFactoryImplementor.getIndexingStrategy().equals("manual");
        File indexDir = DirectoryProviderHelper.getVerifiedIndexDir(directoryProviderName, properties, !manual);
        try {
            this.indexName = indexDir.getCanonicalPath();
            this.directory = DirectoryProviderHelper.createFSIndex(indexDir);
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + directoryProviderName, e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        try {
            this.directory.close();
        }
        catch (Exception e) {
            this.log.error("Unable to properly close Lucene directory {}" + this.directory.getFile(), e);
        }
    }

    @Override
    public FSDirectory getDirectory() {
        return this.directory;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FSDirectoryProvider)) {
            return false;
        }
        return this.indexName.equals(((FSDirectoryProvider)obj).indexName);
    }

    public int hashCode() {
        int hash = 11;
        return 37 * hash + this.indexName.hashCode();
    }
}

