/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.XAQueueConnection;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.ManagedConnectionImpl;
import org.objectweb.joram.client.connector.OutboundConnection;
import org.objectweb.joram.client.connector.OutboundQueueSession;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutboundQueueConnection
extends OutboundConnection
implements QueueConnection {
    OutboundQueueConnection(ManagedConnectionImpl managedCx, XAQueueConnection xac) {
        super(managedCx, xac);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundQueueConnection(" + managedCx + ", " + xac + ")"));
        }
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        Session sess;
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createQueueSession(" + transacted + ", " + acknowledgeMode + ")"));
        }
        if (!this.valid) {
            throw new IllegalStateException("Invalid connection handle.");
        }
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createQueueSession sess = " + this.managedCx.session));
        }
        if ((sess = this.managedCx.session) == null) {
            sess = this.xac.createSession(false, acknowledgeMode);
        }
        return new OutboundQueueSession(sess, this, transacted);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new IllegalStateException("Forbidden call on a component's connection.");
    }
}

