/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.mapper.rdb.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.generator.lib.CommonHelper;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenColumn;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenJoin;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenRef;
import org.objectweb.jorm.mapper.rdb.generator.RdbGenTable;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbClassMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbFilter;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbMapping;
import org.objectweb.jorm.mapper.rdb.metainfo.RdbPrimitiveElementMapping;
import org.objectweb.jorm.metainfo.api.Class;
import org.objectweb.jorm.metainfo.api.ClassMapping;
import org.objectweb.jorm.metainfo.api.ParentClassMapping;
import org.objectweb.jorm.metainfo.api.PrimitiveElement;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.ExpressionException;
import org.objectweb.medor.expression.api.ParameterOperand;
import org.objectweb.medor.expression.api.VariableOperand;
import org.objectweb.medor.expression.converter.rdb.Expression2WhereClauseImpl;
import org.objectweb.medor.expression.lib.ExpressionPrinter;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class RdbGenInfos {
    private static final String COLUMN = ", ";
    public Map tables = new HashMap();
    public RdbGenTable mainTable = null;
    public List readableColumns = new ArrayList();
    public RdbGenRef genId = null;
    public RdbMapping mapping = null;
    public Map genRefs = new HashMap();
    String filterExpr = null;
    public Logger logger;
    public boolean debug = false;
    public static CommonHelper commonHelper = new CommonHelper();
    String pnameIteratorWhereClause = null;

    public Map getTables() {
        return this.tables;
    }

    public RdbGenTable getReferenceTable() {
        return this.mainTable;
    }

    public List getReadableColumns() {
        return this.readableColumns;
    }

    public RdbGenRef getGenId() {
        return this.genId;
    }

    public Map getGenRefs() {
        return this.genRefs;
    }

    public List getTableCompositeGenRefs(RdbGenTable rgt) {
        return this.getTableCompositeGenRefs(rgt, null);
    }

    public List getTableCompositeGenRefs(RdbGenTable rgt, RdbGenJoin rgj) {
        ArrayList<RdbGenRef> res = new ArrayList<RdbGenRef>();
        Iterator it = this.genRefs.values().iterator();
        while (it.hasNext()) {
            RdbGenRef rgr = (RdbGenRef)it.next();
            if (rgr.refColumn != null || rgr.join != rgj || res.contains(rgr)) continue;
            res.add(rgr);
        }
        return res;
    }

    public int getColumnPosition(RdbGenColumn irgc) {
        return this.getColumnPosition(irgc, null);
    }

    public int getColumnPosition(RdbGenColumn irgc, RdbGenJoin rgj) {
        int idx = 1;
        if (this.debug) {
            this.logger.log(BasicLevel.DEBUG, (Object)("getColumnPosition(" + irgc.columnName + ", rgj=" + rgj + ")"));
        }
        for (int i = 0; i < this.readableColumns.size(); ++i) {
            RdbGenColumn rgc = (RdbGenColumn)this.readableColumns.get(i);
            if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("\tcurrent column: " + rgc.columnName));
                this.logger.log(BasicLevel.DEBUG, (Object)("\tpirgc=" + irgc.toString() + " - current=" + rgc.toString()));
            }
            if (rgc.equals(irgc)) {
                if (rgj != null) {
                    if (this.debug) {
                        this.logger.log(BasicLevel.DEBUG, (Object)("\t\tadd join idx: " + rgj.joinIdx));
                    }
                    idx += rgj.joinIdx;
                }
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("\treturn " + idx));
                }
                return idx;
            }
            if (rgc.joins != null) {
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("\t\tcurrent has joins: " + rgc.joins.size()));
                }
                idx += rgc.joins.size();
            } else {
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)"\t\tidx++");
                }
                ++idx;
            }
            if (!this.debug) continue;
            this.logger.log(BasicLevel.DEBUG, (Object)("\t\tidx=" + idx));
        }
        return -1;
    }

    public String getExistStatement() {
        RdbGenColumn rgc;
        String cnfn;
        Iterator it;
        StringBuffer sb = new StringBuffer("SELECT ");
        String sep = "";
        String tabname = null;
        if (this.genId.refColumn != null) {
            sb.append(sep);
            this.appendFQColName(sb, this.genId.refColumn);
            tabname = this.genId.refColumn.table.tableName;
        } else {
            it = this.genId.cnFieldColumns.keySet().iterator();
            while (it.hasNext()) {
                cnfn = (String)it.next();
                rgc = (RdbGenColumn)this.genId.cnFieldColumns.get(cnfn);
                sb.append(sep);
                sep = COLUMN;
                this.appendFQColName(sb, rgc);
                if (tabname != null) continue;
                tabname = rgc.table.tableName;
            }
        }
        sb.append(" FROM ");
        sb.append(tabname);
        sb.append(" WHERE ");
        sep = "";
        if (this.genId.refColumn != null) {
            sb.append(sep);
            this.appendFQColName(sb, this.genId.refColumn);
            sb.append(" = ?");
        } else {
            it = this.genId.cnFieldColumns.keySet().iterator();
            while (it.hasNext()) {
                cnfn = (String)it.next();
                rgc = (RdbGenColumn)this.genId.cnFieldColumns.get(cnfn);
                sb.append(sep);
                sep = " AND ";
                this.appendFQColName(sb, rgc);
                sb.append(" = ?");
            }
        }
        return sb.toString();
    }

    public String getReadSelectFields() {
        return this.getReadSelectFields(false);
    }

    public String getReadSelectFields(boolean aliasingWithPE) {
        StringBuffer select = new StringBuffer();
        String sep = "";
        for (int i = 0; i < this.readableColumns.size(); ++i) {
            RdbGenColumn rgc = (RdbGenColumn)this.readableColumns.get(i);
            if (rgc.joins != null && rgc.joins.size() > 1) {
                int j;
                String[] s = new String[rgc.joins.size()];
                for (j = 0; j < rgc.joins.size(); ++j) {
                    RdbGenJoin rgj = (RdbGenJoin)rgc.joins.get(j);
                    s[rgj.joinIdx] = this.getFQColName(rgc, "_J" + rgj.joinIdx);
                }
                for (j = 0; j < s.length; ++j) {
                    select.append(sep);
                    sep = COLUMN;
                    select.append(s[j]);
                    if (!aliasingWithPE) continue;
                    select.append("\"+ adapter.getColumnAliasExpr(\"");
                    select.append(((PrimitiveElement)rgc.pes.get(j)).getName());
                    select.append("\") + \"");
                }
                continue;
            }
            select.append(sep);
            sep = COLUMN;
            this.appendFQColName(select, rgc);
            if (!aliasingWithPE) continue;
            select.append("\"+ adapter.getColumnAliasExpr(\"");
            select.append(rgc.fieldName);
            select.append("\") + \"");
        }
        return select.toString();
    }

    public String getReadSelectFieldsAsColArray() {
        StringBuffer select = new StringBuffer("new String[]{");
        String sep = "";
        for (int i = 0; i < this.readableColumns.size(); ++i) {
            RdbGenColumn rgc = (RdbGenColumn)this.readableColumns.get(i);
            if (rgc.joins != null && rgc.joins.size() > 1) {
                int j;
                String[] s = new String[rgc.joins.size()];
                for (j = 0; j < rgc.joins.size(); ++j) {
                    RdbGenJoin rgj = (RdbGenJoin)rgc.joins.get(j);
                    s[rgj.joinIdx] = this.getFQColName(rgc, "_J" + rgj.joinIdx);
                }
                for (j = 0; j < s.length; ++j) {
                    select.append(sep);
                    sep = COLUMN;
                    select.append("\"").append(s[j]).append("\"");
                }
                continue;
            }
            select.append(sep);
            sep = COLUMN;
            select.append("\"");
            this.appendFQColName(select, rgc);
            select.append("\"");
        }
        select.append("}");
        return select.toString();
    }

    public List getConstantVisibleColumns() {
        ArrayList<RdbGenColumn> constantCols = new ArrayList<RdbGenColumn>();
        for (int i = 0; i < this.readableColumns.size(); ++i) {
            RdbGenColumn rgc = (RdbGenColumn)this.readableColumns.get(i);
            if (rgc.constant == null || rgc.hiddenField) continue;
            constantCols.add(rgc);
        }
        return constantCols;
    }

    public int getReadSelectNbFields() {
        int res = 0;
        for (int i = 0; i < this.readableColumns.size(); ++i) {
            RdbGenColumn rgc = (RdbGenColumn)this.readableColumns.get(i);
            if (rgc.joins != null && rgc.joins.size() > 1) {
                int j;
                String[] s = new String[rgc.joins.size()];
                for (j = 0; j < rgc.joins.size(); ++j) {
                    RdbGenJoin rgj = (RdbGenJoin)rgc.joins.get(j);
                    s[rgj.joinIdx] = this.getFQColName(rgc, "_J" + rgj.joinIdx);
                }
                for (j = 0; j < s.length; ++j) {
                    ++res;
                }
                continue;
            }
            ++res;
        }
        return res;
    }

    public List getReadFromTables() {
        ArrayList<String> al = new ArrayList<String>();
        al.add("JoinedTable jt = new JoinedTable(\"" + this.mainTable.tableName + "\");");
        al.add("JoinedTable.Join jtj = null;");
        Iterator it = this.tables.values().iterator();
        while (it.hasNext()) {
            RdbGenTable rgt = (RdbGenTable)it.next();
            if (rgt.joins == null) continue;
            boolean multiJoin = rgt.joins.size() > 1;
            for (int i = 0; i < rgt.joins.size(); ++i) {
                RdbGenJoin join = (RdbGenJoin)rgt.joins.get(i);
                String tableSuffix = null;
                if (multiJoin) {
                    tableSuffix = "_J" + ((RdbGenJoin)rgt.joins.get((int)i)).joinIdx;
                    al.add("jtj = jt.createChildren(\"" + rgt.tableName + "\", \"" + rgt.tableName + tableSuffix + "\");");
                } else {
                    al.add("jtj = jt.createChildren(\"" + rgt.tableName + "\");");
                }
                for (int j = 0; j < join.joinColumnsInMain.size(); ++j) {
                    al.add("jtj.addJoinColumn(\"" + ((RdbGenColumn)join.joinColumnsInMain.get((int)j)).columnName + "\", \"" + ((RdbGenColumn)join.joinColumnsInExt.get((int)j)).columnName + "\");");
                }
            }
        }
        return al;
    }

    public String getReadWhereClause() {
        StringBuffer where = new StringBuffer();
        String sep = "";
        if (this.genId.refColumn != null) {
            where.append(sep);
            this.appendFQColName(where, this.genId.refColumn);
            where.append(" = ?");
        } else {
            Iterator it = this.genId.cnFieldColumns.keySet().iterator();
            while (it.hasNext()) {
                String cnfn = (String)it.next();
                RdbGenColumn rgc = (RdbGenColumn)this.genId.cnFieldColumns.get(cnfn);
                where.append(sep);
                sep = " AND ";
                this.appendFQColName(where, rgc);
                where.append(" = ?");
            }
        }
        return where.toString();
    }

    public String getPNameIteratorSelectClause() {
        try {
            StringBuffer select = new StringBuffer();
            if (this.genId.getCnFieldColumns() == null) {
                this.appendFQColName(select, this.genId.getRefColumn());
            } else {
                String sep = "";
                Iterator it = this.genId.getCnFieldColumns().keySet().iterator();
                while (it.hasNext()) {
                    RdbGenColumn rgc = (RdbGenColumn)this.genId.getCnFieldColumns().get(it.next());
                    if (!this.colInGenId(rgc)) continue;
                    select.append(sep);
                    sep = COLUMN;
                    this.appendFQColName(select, rgc);
                }
            }
            return select.toString();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String getPNameIteratorSelectClauseWithPrefetch() {
        try {
            StringBuffer select = new StringBuffer();
            select.append(this.getReadSelectFields(true));
            if (this.genId.getCnFieldColumns() == null) {
                select.append(COLUMN);
                this.appendFQColName(select, this.genId.getRefColumn());
                select.append("\" + adapter.getColumnAliasExpr(\"pk0\") + \"");
            } else {
                Iterator it = this.genId.getCnFieldColumns().keySet().iterator();
                int i = 0;
                while (it.hasNext()) {
                    RdbGenColumn rgc = (RdbGenColumn)this.genId.getCnFieldColumns().get(it.next());
                    if (!this.colInGenId(rgc)) continue;
                    select.append(COLUMN);
                    this.appendFQColName(select, rgc);
                    select.append("\" + adapter.getColumnAliasExpr(\"pk");
                    select.append(i);
                    select.append("\") + \"");
                }
            }
            return select.toString();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Expression getFilterMedorExpression() {
        Expression exp = null;
        try {
            RdbFilter rdbFilter = ((RdbClassMapping)this.mapping.getClassMapping()).getRdbFilter();
            if (rdbFilter != null) {
                exp = rdbFilter.getExpression();
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Rdb filter specified for the class " + this.mapping.getClassMapping().getJormClass().getFQName() + ", expression=" + ExpressionPrinter.e2str(exp)));
                }
            } else if (((RdbClassMapping)this.mapping.getClassMapping()).inheritsStructures() || !this.mapping.getClassMapping().getJormClass().getSubClasses().isEmpty()) {
                exp = ((RdbClassMapping)this.mapping.getClassMapping()).getMappingFilterFromNamingFilter();
                if (this.debug) {
                    this.logger.log(BasicLevel.DEBUG, (Object)("Class " + this.mapping.getClassMapping().getJormClass().getFQName() + " has a filtered mapping and the filter is computed from the naming filter:" + ExpressionPrinter.e2str(exp)));
                }
            } else if (this.debug) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Class " + this.mapping.getClassMapping().getJormClass().getFQName() + " has no filter"));
            }
            return exp;
        }
        catch (ExpressionException e) {
            if (this.logger != null) {
                this.logger.log(BasicLevel.ERROR, (Object)("Cannot compute filter expression: " + e.getMessage()), (Throwable)e);
            } else {
                e.printStackTrace(System.err);
            }
            throw new InternalError("Cannot compute filter expression: " + e);
        }
    }

    public String getFilterExpression() {
        if (this.filterExpr != null) {
            return this.filterExpr;
        }
        try {
            Expression exp = this.getFilterMedorExpression();
            if (exp == null) {
                this.filterExpr = "";
            } else {
                StringBuffer sb = new StringBuffer();
                new JormExpression2WhereClause().convertExp2WhereClauseBuilder(exp, "adapter", sb, new HashMap());
                this.filterExpr = sb.toString();
            }
            return this.filterExpr;
        }
        catch (ExpressionException e) {
            throw new InternalError("Cannot compute filter expression: " + e);
        }
    }

    public String getPNameIteratorWhereClause() throws ExpressionException {
        if (this.pnameIteratorWhereClause == null) {
            this.pnameIteratorWhereClause = this.getFilterExpression();
        }
        if (this.pnameIteratorWhereClause != null && this.pnameIteratorWhereClause.length() > 0) {
            return this.pnameIteratorWhereClause;
        }
        return null;
    }

    public String getUpdateStatement(RdbGenTable rgt) throws PException {
        int i;
        StringBuffer sb = new StringBuffer("UPDATE ");
        sb.append(rgt.tableName);
        sb.append(" SET ");
        String sep = "";
        for (i = 0; i < rgt.inheritedColumns.size(); ++i) {
            if (!this.updatable((RdbGenColumn)rgt.inheritedColumns.get(i))) continue;
            sb.append(sep);
            sep = COLUMN;
            sb.append(((RdbGenColumn)rgt.inheritedColumns.get((int)i)).columnName);
            sb.append(" = ?");
        }
        for (i = 0; i < rgt.columns.size(); ++i) {
            if (!this.updatable((RdbGenColumn)rgt.columns.get(i))) continue;
            sb.append(sep);
            sep = COLUMN;
            sb.append(((RdbGenColumn)rgt.columns.get((int)i)).columnName);
            sb.append(" = ?");
        }
        this.appendModificationWhereClause(sb, rgt);
        return sb.toString();
    }

    public String getUpdateStatement(RdbGenJoin rgj) throws PException {
        StringBuffer sb = new StringBuffer("UPDATE ");
        sb.append(rgj.table.tableName);
        sb.append(" SET ");
        String sep = "";
        if (rgj.table.colocatedTable) {
            for (int i = 0; i < rgj.joinColumnsInExt.size(); ++i) {
                sb.append(sep);
                sep = COLUMN;
                sb.append(((RdbGenColumn)rgj.joinColumnsInExt.get((int)i)).columnName);
                sb.append(" = ?");
            }
        } else {
            for (int i = 0; i < rgj.table.columns.size(); ++i) {
                RdbGenColumn rgc = (RdbGenColumn)rgj.table.columns.get(i);
                if (rgc.joinCol != null) continue;
                sb.append(sep);
                sep = COLUMN;
                sb.append(rgc.columnName);
                sb.append(" = ?");
            }
        }
        this.appendModificationWhereClause(sb, rgj, rgj.table.colocatedTable);
        return sb.toString();
    }

    public String getUpdateNullStatement(RdbGenTable rgt) throws PException {
        if (rgt.joins != null && rgt.joins.size() > 0) {
            throw new PException("umanaged case, must use getUpdateNullStatement(RdbGenJoin) for each join.");
        }
        StringBuffer sb = new StringBuffer("UPDATE ");
        sb.append(rgt.tableName);
        sb.append(" SET ");
        String sep = "";
        for (int i = 0; i < rgt.columns.size(); ++i) {
            RdbGenColumn rgc = (RdbGenColumn)rgt.columns.get(i);
            if (!this.updatable(rgc) || rgt.colocatedColumn(rgc)) continue;
            sb.append(sep);
            sep = COLUMN;
            sb.append(rgc.columnName);
            sb.append(" = null");
        }
        this.appendModificationWhereClause(sb, rgt);
        return sb.toString();
    }

    public String getUpdateNullStatement(RdbGenJoin rgj) throws PException {
        StringBuffer sb = new StringBuffer("UPDATE ");
        sb.append(rgj.table.tableName);
        sb.append(" SET ");
        String sep = "";
        for (int i = 0; i < rgj.joinColumnsInExt.size(); ++i) {
            sb.append(sep);
            sep = COLUMN;
            sb.append(((RdbGenColumn)rgj.joinColumnsInExt.get((int)i)).columnName);
            sb.append(" = null");
        }
        this.appendModificationWhereClause(sb, rgj, false);
        return sb.toString();
    }

    public String getInsertStatement(RdbGenTable rgt) throws PException {
        int i;
        String sep = "";
        StringBuffer sb = new StringBuffer("INSERT INTO ");
        sb.append(rgt.tableName);
        sb.append(" (");
        ArrayList columns = new ArrayList();
        columns.addAll(rgt.inheritedColumns);
        columns.addAll(rgt.columns);
        for (i = 0; i < columns.size(); ++i) {
            sb.append(sep);
            sep = COLUMN;
            sb.append(((RdbGenColumn)columns.get((int)i)).columnName);
        }
        sb.append(") VALUES (");
        sep = "";
        for (i = 0; i < columns.size(); ++i) {
            sb.append(sep);
            sep = COLUMN;
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getInsertStatement(RdbGenJoin rgj) {
        RdbGenTable rgt = rgj.getTable();
        int i = 0;
        try {
            RdbGenColumn col;
            String sep = "";
            StringBuffer sb = new StringBuffer("INSERT INTO ");
            sb.append(rgt.tableName);
            sb.append(" (");
            for (i = 0; i < rgt.columns.size(); ++i) {
                col = (RdbGenColumn)rgt.columns.get(i);
                if (!col.isInJoin(rgj)) continue;
                sb.append(sep);
                sep = COLUMN;
                sb.append(((RdbGenColumn)rgt.columns.get((int)i)).columnName);
            }
            sb.append(") VALUES (");
            sep = "";
            for (i = 0; i < rgt.columns.size(); ++i) {
                col = (RdbGenColumn)rgt.columns.get(i);
                if (!col.isInJoin(rgj)) continue;
                sb.append(sep);
                sep = COLUMN;
                sb.append("?");
            }
            sb.append(")");
            return sb.toString();
        }
        catch (RuntimeException e) {
            System.out.println(rgt.tableName);
            System.out.println(rgt.columns.get(i));
            System.out.println(((RdbGenColumn)rgt.columns.get((int)i)).joins);
            e.printStackTrace();
            throw e;
        }
    }

    public String getDeleteStatement(RdbGenTable rgt) throws PException {
        StringBuffer sb = new StringBuffer("DELETE FROM ");
        sb.append(rgt.tableName);
        this.appendModificationWhereClause(sb, rgt);
        return sb.toString();
    }

    public String getDeleteStatement(RdbGenJoin rgj) throws PException {
        return this.getDeleteStatement(rgj.getTable());
    }

    public String getExtDeleteStatement(RdbGenJoin rgj) throws PException {
        StringBuffer sb = new StringBuffer("DELETE FROM ");
        sb.append(rgj.table.tableName);
        this.appendModificationWhereClause(sb, rgj, rgj.table.colocatedTable);
        return sb.toString();
    }

    public String setIdPnParam(String cnfn, int idx, String adapter, String pstmt, boolean isSpecific) throws PException {
        RdbGenColumn rgc = (RdbGenColumn)this.genId.cnFieldColumns.get(cnfn);
        return rgc.getSqlSet(adapter, pstmt, this.setIdPNParameterOperand(cnfn, isSpecific), idx);
    }

    public String setIdPNParameterOperand(String cnfn, boolean isSpecific) throws PException {
        RdbGenColumn rgc = (RdbGenColumn)this.genId.cnFieldColumns.get(cnfn);
        StringBuffer value = new StringBuffer();
        if (isSpecific) {
            value.append("((");
            value.append(this.genId.getCnFQName());
            value.append("PNG) _pngId).pnGet");
            value.append(commonHelper.upperFL(cnfn));
            value.append("(null)");
        } else {
            value.append("((PNameGetter) _pngId).");
            value.append(commonHelper.getPNameGetterGetFunction(rgc.columnType));
            value.append("(\"");
            value.append(cnfn);
            value.append("\", null)");
        }
        return value.toString();
    }

    public RdbGenRef getGenRefOfColumn(RdbGenColumn rgc) {
        return this.getGenRefOfColumn(rgc, null);
    }

    public RdbGenRef getGenRefOfColumn(RdbGenColumn rgc, RdbGenJoin rgj) {
        int idx;
        if (rgc.joinCol != null) {
            return this.getGenRefOfColumn(rgc.joinCol, rgj);
        }
        PrimitiveElement pe = null;
        if (rgj != null && rgc.joins != null && (idx = rgc.joins.indexOf(rgj)) != -1) {
            pe = (PrimitiveElement)rgc.pes.get(idx);
        }
        Iterator it = this.genRefs.values().iterator();
        while (it.hasNext()) {
            RdbGenRef rgr = (RdbGenRef)it.next();
            if (rgr.refColumn != null) {
                if (rgr.refColumn != rgc || pe != null && !rgr.nd.getFieldName().equals(pe.getName())) continue;
                return rgr;
            }
            Iterator it2 = rgr.cnFieldColumns.values().iterator();
            Collection classfields = rgr.nd.getNameRef().getProjection().values();
            while (it2.hasNext()) {
                RdbGenColumn currentRgc = (RdbGenColumn)it2.next();
                if (currentRgc != rgc || pe != null && !classfields.contains(pe.getName())) continue;
                return rgr;
            }
        }
        System.out.println("getGenRefOfColumn(" + rgc.columnName + COLUMN + (rgj == null ? "null" : "" + rgj.joinIdx) + ") return null");
        return null;
    }

    public boolean colInGenId(RdbGenColumn genCol) {
        if (genCol.joinCol != null) {
            return this.colInGenId(genCol.joinCol);
        }
        if (this.genId.refColumn != null) {
            if (this.genId.refColumn == genCol) {
                return true;
            }
        } else {
            Iterator itCol = this.genId.cnFieldColumns.values().iterator();
            while (itCol.hasNext()) {
                RdbGenColumn genColOfComposite = (RdbGenColumn)itCol.next();
                if (genColOfComposite != genCol) continue;
                return true;
            }
        }
        return false;
    }

    public String getGenRefFieldName(RdbGenRef gr) {
        Iterator it = this.genRefs.keySet().iterator();
        while (it.hasNext()) {
            String res = (String)it.next();
            if (this.genRefs.get(res) != gr) continue;
            return res;
        }
        return null;
    }

    public String getPnFieldName(RdbGenColumn rgc) {
        Iterator it = this.genId.cnFieldColumns.keySet().iterator();
        while (it.hasNext()) {
            String res = (String)it.next();
            if (rgc != this.genId.cnFieldColumns.get(res)) continue;
            return res;
        }
        return null;
    }

    private void appendFQColName(StringBuffer sb, RdbGenColumn rgc) {
        sb.append(rgc.table.tableName);
        sb.append(".");
        sb.append(rgc.columnName);
    }

    private String getFQColName(RdbGenColumn rgc, String tableSuffix) {
        return rgc.table.tableName + tableSuffix + "." + rgc.columnName;
    }

    private void appendModificationWhereClause(StringBuffer sb, RdbGenTable rgt) throws PException {
        String sep = "";
        sb.append(" WHERE ");
        if (rgt != this.mainTable) {
            throw new PException("umanaged case, the table " + rgt.tableName + " is an external table");
        }
        if (this.genId.refColumn != null) {
            sb.append(this.genId.refColumn.columnName);
            sb.append(" = ?");
        } else {
            Iterator it = this.genId.cnFieldColumns.values().iterator();
            while (it.hasNext()) {
                RdbGenColumn cur = (RdbGenColumn)it.next();
                sb.append(sep);
                sep = " AND ";
                sb.append(cur.columnName);
                sb.append(" = ?");
            }
        }
    }

    private void appendModificationWhereClause(StringBuffer sb, RdbGenJoin rgj, boolean isNotJoinColumn) {
        String sep = "";
        sb.append(" WHERE ");
        sep = "";
        if (isNotJoinColumn) {
            for (int i = 0; i < rgj.table.columns.size(); ++i) {
                RdbGenColumn rgc = (RdbGenColumn)rgj.table.columns.get(i);
                if (rgc.joinCol != null) continue;
                sb.append(sep);
                sep = " AND ";
                sb.append(rgc.columnName);
                sb.append(" = ?");
            }
        } else {
            for (int i = 0; i < rgj.joinColumnsInExt.size(); ++i) {
                sb.append(sep);
                sep = " AND ";
                sb.append(((RdbGenColumn)rgj.joinColumnsInExt.get((int)i)).columnName);
                sb.append(" = ?");
            }
        }
    }

    public boolean updatable(RdbGenColumn rgc) {
        return (!rgc.hiddenField || rgc.joinCol != null || !this.colInGenId(rgc)) && rgc.constant == null;
    }

    public boolean updatable(RdbGenColumn rgc, RdbGenJoin rgj) {
        if (rgj == null) {
            return this.updatable(rgc);
        }
        if (rgj.table.colocatedTable) {
            return rgc.joinCol != null && rgc.isInJoin(rgj);
        }
        return rgc.joinCol == null;
    }

    public boolean hasFilter() {
        return this.filterExpr != null && !"".equals(this.filterExpr);
    }

    class JormExpression2WhereClause
    extends Expression2WhereClauseImpl {
        JormExpression2WhereClause() {
        }

        public void convertExp2WhereClauseBuilder(Expression expression, String rdbAdapterVarName, StringBuffer sb, Map ctx) throws ExpressionException {
            if (expression instanceof ParameterOperand) {
                String fieldName = ((ParameterOperand)expression).getName();
                RdbPrimitiveElementMapping rpem = this.getRPEM(fieldName, RdbGenInfos.this.mapping.getClassMapping());
                if (rpem == null) {
                    throw new ExpressionException("No mapping found for the field '" + fieldName + "' into the mapping filter");
                }
                RdbGenColumn rgc = RdbGenInfos.this.mainTable.getColumn(rpem.getName());
                if (rgc == null) {
                    throw new ExpressionException("No column found for the field '" + fieldName + "' into the mainb table '" + RdbGenInfos.this.mainTable.tableName + "' in the mapping filter");
                }
                RdbGenInfos.this.appendFQColName(sb, rgc);
            } else if (expression instanceof VariableOperand) {
                sb.append("\" + ");
                sb.append(rdbAdapterVarName);
                sb.append(".getValueAsSQLString(getNamingFilterKey(), ");
                sb.append(expression.getType().getProgName());
                sb.append(".getTypeCode()) + \"");
            } else {
                super.convertExp2WhereClauseBuilder(expression, rdbAdapterVarName, sb, ctx);
            }
        }

        private RdbPrimitiveElementMapping getRPEM(String fieldName, ClassMapping cm) throws ExpressionException {
            RdbPrimitiveElementMapping rpem;
            if (RdbGenInfos.this.debug) {
                RdbGenInfos.this.logger.log(BasicLevel.DEBUG, (Object)("Try to find the field " + fieldName + " on the class mapping of the class " + ((Class)cm.getLinkedMO()).getFQName()));
            }
            if ((rpem = (RdbPrimitiveElementMapping)cm.getPrimitiveElementMapping(fieldName)) == null) {
                Iterator it = cm.getParentClassMappings().iterator();
                while (rpem == null && it.hasNext()) {
                    ParentClassMapping pcm = (ParentClassMapping)it.next();
                    ClassMapping _cm = pcm.getMOClass().getClassProject(pcm.getProjectName()).getMapping(pcm.getMapperName()).getClassMapping();
                    rpem = this.getRPEM(fieldName, _cm);
                }
            }
            return rpem;
        }
    }
}

