/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.optim.rdb;

import java.util.ArrayList;
import org.objectweb.medor.api.Field;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.api.TupleStructure;
import org.objectweb.medor.datasource.api.DataStore;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.Operator;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.lib.MemberOf;
import org.objectweb.medor.optim.api.RewriteRule;
import org.objectweb.medor.optim.lib.BasicRule;
import org.objectweb.medor.query.api.CalculatedField;
import org.objectweb.medor.query.api.FilteredQueryTree;
import org.objectweb.medor.query.api.NestedField;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.medor.query.rdb.api.QualifiedTable;
import org.objectweb.medor.query.rdb.api.RdbExpField;
import org.objectweb.medor.query.rdb.api.RdbExpQueryLeaf;
import org.objectweb.medor.query.rdb.lib.BasicQualifiedTable;
import org.objectweb.medor.query.rdb.lib.BasicRdbExpQueryLeaf;

public class GroupSameDBRule
extends BasicRule
implements RewriteRule {
    public QueryTree rewrite(QueryTree qt, QueryNode parent) throws MedorException {
        RdbQuery rq = this.recurseRewrite(qt);
        GroupSameDBRule.debug("end of recurse");
        if (rq != null) {
            GroupSameDBRule.debug("building RdbLeaf");
            return this.buildRdbLeaf(rq, qt);
        }
        return qt;
    }

    private RdbQuery recurseRewrite(QueryTree qt) throws MedorException {
        if (qt instanceof RdbExpQueryLeaf) {
            GroupSameDBRule.debug("RdbExpQueryLeaf: START " + qt.getName());
            RdbQuery rq = new RdbQuery();
            Field[] lf = qt.getTupleStructure().getFields();
            rq.fields = new ArrayList(lf.length);
            for (int i = 0; i < lf.length; ++i) {
                rq.fields.add(lf[i]);
            }
            QualifiedTable[] lqt = ((RdbExpQueryLeaf)qt).getQualifiedTables();
            rq.tables = new ArrayList(lqt.length);
            rq.tableIds = new ArrayList(lqt.length);
            for (int i = 0; i < lqt.length; ++i) {
                rq.tables.add(lqt[i]);
                if (lqt[i].getAliasName() != null) {
                    rq.tableIds.add(lqt[i].getAliasName());
                    continue;
                }
                rq.tableIds.add(lqt[i].getTableName());
            }
            rq.exp = ((RdbExpQueryLeaf)qt).getQueryFilter();
            rq.ds = ((RdbExpQueryLeaf)qt).getDataStore();
            GroupSameDBRule.debug("RdbExpQueryLeaf: END " + qt.getName());
            return rq;
        }
        if (qt instanceof QueryLeaf) {
            GroupSameDBRule.debug("QueryLeaf: " + qt);
            return null;
        }
        if (this.memberOfInExpression(((QueryNode)qt).getQueryFilter())) {
            GroupSameDBRule.debug("QueryNode with MemberOf: " + qt);
            SplitQueries split = this.splitQueries(qt);
            GroupSameDBRule.debug("splitQueries done");
            GroupSameDBRule.debug("Structure of split: Left: " + split.outerQts.size() + " Right: " + split.subQts.size());
            RdbQuery workRq = this.exploreQueryTrees(split.outerQts.toArray(new QueryTree[0]));
            GroupSameDBRule.debug("recursive exploreQueryTrees done");
            workRq.hasSubQuery = true;
            if (this.noCalculation(qt)) {
                GroupSameDBRule.debug("noCalculation: => continue");
                workRq.exp = workRq.exp == null ? ((QueryNode)qt).getQueryFilter() : new And(workRq.exp, ((QueryNode)qt).getQueryFilter());
                workRq.subQueries = new ArrayList();
                GroupSameDBRule.debug("number of subqueries: " + split.subQts.size());
                for (int i = 0; i < split.subQts.size(); ++i) {
                    RdbQuery innerRq = this.exploreQueryTrees(((ArrayList)split.subQts.get(i)).toArray(new QueryTree[0]));
                    workRq.subQueries.add(innerRq);
                }
            } else {
                this.createLeafAndUpdateLinks(workRq, qt);
                workRq = null;
            }
            return workRq;
        }
        GroupSameDBRule.debug("QueryNode without MemberOf: " + qt);
        QueryTree[] children = ((QueryNode)qt).getChildren();
        RdbQuery workRq = this.exploreQueryTrees(children);
        if (this.noCalculation(qt)) {
            GroupSameDBRule.debug("noCalculation: => continue");
            workRq.exp = workRq.exp == null ? ((QueryNode)qt).getQueryFilter() : new And(workRq.exp, ((QueryNode)qt).getQueryFilter());
        } else {
            this.createLeafAndUpdateLinks(workRq, qt);
            workRq = null;
        }
        GroupSameDBRule.debug("QueryNode: END");
        return workRq;
    }

    private void createLeafAndUpdateLinks(RdbQuery workRq, QueryTree qt) throws MedorException {
        GroupSameDBRule.debug("Has calculated field: => stop, create RdbExpQL and link");
        RdbExpQueryLeaf ql = this.buildRdbLeaf(workRq, qt);
        Field[] fs = qt.getTupleStructure().getFields();
        TupleStructure ts = ql.getTupleStructure();
        for (int i = 0; i < fs.length; ++i) {
            if (fs[i] instanceof PropagatedField) {
                if (ts.contains(fs[i].getName())) {
                    GroupSameDBRule.debug("Replace in the PropagatedField " + fs[i].getName());
                    ((QueryNode)qt).updatePropagatedField(fs[i].getName(), new QueryTreeField[]{(QueryTreeField)ts.getField(fs[i].getName())});
                    continue;
                }
                GroupSameDBRule.debug("Do not replace in the PropagatedField " + fs[i].getName());
                continue;
            }
            if (fs[i] instanceof CalculatedField) {
                GroupSameDBRule.debug("Try to replace in the CalculatedField " + fs[i].getName());
                Expression e = ((CalculatedField)fs[i]).getExpression();
                if (!this.replaceInFilter(e, ts)) continue;
                ((QueryNode)qt).updateCalculatedField(fs[i].getName(), e);
                continue;
            }
            if (!(fs[i] instanceof NestedField)) continue;
            GroupSameDBRule.debug("Replace in the NestedField " + fs[i].getName());
            throw new MedorException("Unmanaged Nested Field");
        }
        if (qt instanceof FilteredQueryTree) {
            GroupSameDBRule.debug("Try to replace in the filter ");
            Expression e = ((FilteredQueryTree)qt).getQueryFilter();
            if (this.replaceInFilter(e, ts)) {
                ((FilteredQueryTree)qt).setQueryFilter(e);
            }
        }
    }

    private RdbQuery exploreQueryTrees(QueryTree[] qts) throws MedorException {
        boolean first = true;
        RdbQuery workRq = null;
        for (int i = 0; i < qts.length; ++i) {
            RdbQuery currentRq = this.recurseRewrite(qts[i]);
            if (first) {
                GroupSameDBRule.debug("first");
                workRq = currentRq;
                first = false;
                continue;
            }
            if (workRq.ds != null && workRq.ds.isSameAs(currentRq.ds)) {
                GroupSameDBRule.debug("Same store => merging");
                this.mergeRdbQueries(workRq, currentRq);
                continue;
            }
            throw new MedorException("Impossible to group two nodes with different data stores");
        }
        return workRq;
    }

    private boolean replaceInFilter(Expression e, TupleStructure ts) throws MedorException {
        ArrayList<Expression> al = new ArrayList<Expression>();
        al.add(e);
        boolean isModified = false;
        while (!al.isEmpty()) {
            Expression ex = (Expression)al.remove(0);
            if (ex instanceof Operator) {
                for (int i = 0; i < ((Operator)ex).getOperandNumber(); ++i) {
                    al.add(((Operator)ex).getExpression(i));
                }
                continue;
            }
            if (!(ex instanceof FieldOperand)) continue;
            FieldOperand fo = (FieldOperand)ex;
            if (ts.contains(fo.getField().getName())) {
                GroupSameDBRule.debug("Replace in the FieldOperand: " + fo.getField().getName());
                fo.setField(ts.getField(fo.getField().getName()));
                isModified = true;
                continue;
            }
            GroupSameDBRule.debug("Do not replace in the FieldOperand: " + fo.getField().getName());
        }
        return isModified;
    }

    private boolean noCalculation(QueryTree qt) {
        GroupSameDBRule.debug("Testing for calculated fields: ");
        Field[] qtf = qt.getTupleStructure().getFields();
        for (int i = 0; i < qtf.length; ++i) {
            if (!(qtf[i] instanceof CalculatedField)) continue;
            GroupSameDBRule.debug("found");
            return false;
        }
        GroupSameDBRule.debug("not found");
        return true;
    }

    private void mergeRdbQueries(RdbQuery into, RdbQuery other) {
        for (int i = 0; i < other.fields.size(); ++i) {
            into.fields.add(other.fields.get(i));
        }
        for (int i = 0; i < other.tables.size(); ++i) {
            QualifiedTable qt = (QualifiedTable)other.tables.get(i);
            if (into.tables.contains(qt)) {
                BasicQualifiedTable qt1 = new BasicQualifiedTable(qt.getTableName(), qt.getAliasName());
                for (int j = 0; j < other.fields.size(); ++j) {
                    if (((RdbExpField)other.fields.get(j)).getTable() != qt) continue;
                    ((RdbExpField)other.fields.get(j)).setTable(qt1);
                }
                qt = qt1;
            }
            if (qt.getAliasName() != null) {
                if (into.tableIds.contains(qt.getAliasName())) {
                    qt.setAliasName(this.generateAlias(into.tableIds, qt.getAliasName()));
                }
            } else if (into.tableIds.contains(qt.getTableName())) {
                qt.setAliasName(this.generateAlias(into.tableIds, qt.getTableName()));
            }
            into.tables.add(qt);
        }
        if (into.exp == null) {
            into.exp = other.exp;
        } else if (other.exp != null) {
            into.exp = new And(into.exp, other.exp);
        }
    }

    private String generateAlias(ArrayList tableIds, String root) {
        root = root + "_";
        int i = 1;
        while (tableIds.contains(root + i)) {
            ++i;
        }
        root = root + i;
        tableIds.add(root);
        return root;
    }

    private boolean memberOfInExpression(Expression e) {
        GroupSameDBRule.debug("entering memberOfInExpression");
        if (e instanceof MemberOf) {
            return true;
        }
        if (e instanceof Operator) {
            Operator op = (Operator)e;
            boolean found = false;
            for (int i = 0; i < op.getOperandNumber(); ++i) {
                if (!this.memberOfInExpression(op.getExpression(i))) continue;
                found = true;
                break;
            }
            return found;
        }
        return false;
    }

    private RdbExpQueryLeaf buildRdbLeaf(RdbQuery rq, QueryTree qt) throws MedorException {
        BasicRdbExpQueryLeaf ql;
        if (rq.hasSubQuery) {
            int i;
            ql = new BasicRdbExpQueryLeaf(rq.ds, rq.tables.toArray(new QualifiedTable[0]), qt.getName());
            ql.setQueryFilter(rq.exp);
            for (i = 0; i < rq.fields.size(); ++i) {
                ql.addRdbField((RdbExpField)rq.fields.get(i));
            }
            for (i = 0; i < rq.subQueries.size(); ++i) {
                BasicRdbExpQueryLeaf subql = new BasicRdbExpQueryLeaf(rq.ds, ((RdbQuery)rq.subQueries.get((int)i)).tables.toArray(new QualifiedTable[0]), qt.getName());
                this.replaceInFilter(ql.getQueryFilter(), subql.getTupleStructure());
            }
        } else {
            ql = new BasicRdbExpQueryLeaf(rq.ds, rq.tables.toArray(new QualifiedTable[0]), qt.getName());
            ql.setQueryFilter(rq.exp);
            for (int i = 0; i < rq.fields.size(); ++i) {
                ql.addRdbField((RdbExpField)rq.fields.get(i));
            }
        }
        return ql;
    }

    private SplitQueries splitQueries(QueryTree qt) {
        SplitQueries split = new SplitQueries();
        split.outerQts = new ArrayList();
        split.subQts = new ArrayList();
        Expression e = ((QueryNode)qt).getQueryFilter();
        return this.recurseSplit(split, e);
    }

    protected SplitQueries recurseSplit(SplitQueries split, Expression e) {
        if (e instanceof FieldOperand) {
            QueryTreeField f = (QueryTreeField)((FieldOperand)e).getField();
            QueryTree qtf = f.getQueryTree();
            if (!split.outerQts.contains(qtf)) {
                split.outerQts.add(qtf);
            }
        } else {
            if (e instanceof MemberOf) {
                GroupSameDBRule.debug("splitting MemberOf");
                MemberOf mo = (MemberOf)e;
                int moSize = mo.getOperandNumber() / 2;
                for (int i = 0; i < moSize; ++i) {
                    if (!(((MemberOf)e).getExpression(i) instanceof FieldOperand)) continue;
                    QueryTreeField fLeft = (QueryTreeField)((FieldOperand)((MemberOf)e).getExpression(i)).getField();
                    QueryTree qtfLeft = fLeft.getQueryTree();
                    GroupSameDBRule.debug("Left node is " + qtfLeft.getName());
                    if (split.outerQts.contains(qtfLeft)) continue;
                    split.outerQts.add(qtfLeft);
                }
                ArrayList<QueryTree> newSub = null;
                for (int i = 0; i < moSize; ++i) {
                    QueryTreeField fRight = (QueryTreeField)((FieldOperand)((MemberOf)e).getExpression(i + moSize)).getField();
                    QueryTree qtfRight = fRight.getQueryTree();
                    GroupSameDBRule.debug("Right node is " + qtfRight.getName());
                    if (split.outerQts.contains(qtfRight)) {
                        split.outerQts.remove(qtfRight);
                    }
                    boolean isInSub = false;
                    for (int j = 0; j < split.subQts.size(); ++j) {
                        if (!((ArrayList)split.subQts.get(j)).contains(qtfRight)) continue;
                        isInSub = true;
                        break;
                    }
                    GroupSameDBRule.debug("found in subqueries:" + isInSub);
                    if (isInSub) continue;
                    if (newSub == null) {
                        newSub = new ArrayList<QueryTree>(1);
                    }
                    newSub.add(qtfRight);
                }
                if (newSub != null) {
                    split.subQts.add(newSub);
                }
                return split;
            }
            if (e instanceof Operator) {
                Operator op = (Operator)e;
                for (int i = 0; i < op.getOperandNumber(); ++i) {
                    split = this.recurseSplit(split, op.getExpression(i));
                }
                return split;
            }
        }
        return split;
    }

    private static final void debug(String msg) {
    }

    protected static final class SplitQueries {
        public ArrayList outerQts;
        public ArrayList subQts;

        protected SplitQueries() {
        }
    }

    protected static final class RdbQuery {
        public ArrayList fields;
        public ArrayList tables;
        public Expression exp;
        public DataStore ds;
        public ArrayList tableIds;
        public boolean hasSubQuery;
        public ArrayList subQueries;

        protected RdbQuery() {
        }
    }
}

