/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.medor.query.lib;

import java.util.List;
import org.objectweb.medor.api.MedorException;
import org.objectweb.medor.expression.api.Expression;
import org.objectweb.medor.expression.api.MalformedExpressionException;
import org.objectweb.medor.expression.lib.And;
import org.objectweb.medor.filter.api.FieldOperand;
import org.objectweb.medor.filter.lib.BasicFieldOperand;
import org.objectweb.medor.filter.lib.MemberOf;
import org.objectweb.medor.lib.Log;
import org.objectweb.medor.query.api.PropagatedField;
import org.objectweb.medor.query.api.QueryLeaf;
import org.objectweb.medor.query.api.QueryNode;
import org.objectweb.medor.query.api.QueryTree;
import org.objectweb.medor.query.api.QueryTreeField;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class MemberOfHelper {
    public static Logger logger = Log.getLoggerFactory().getLogger("org.objectweb.medor.query.lib.MemberOfHelper");

    public static void addMemberOf(QueryNode qn, List mofLeft, List mofRight) throws MedorException, MalformedExpressionException {
        int size = mofLeft.size();
        for (int i = 0; i < size; ++i) {
            logger.log(BasicLevel.DEBUG, (Object)("Handling field number " + i));
            Expression left = (Expression)mofLeft.get(i);
            Expression right = (Expression)mofRight.get(i);
            if (!(left instanceof FieldOperand)) continue;
            QueryTreeField leftField = (QueryTreeField)((FieldOperand)left).getField();
            QueryTreeField rightField = (QueryTreeField)((FieldOperand)right).getField();
            qn = MemberOfHelper.pushDown(leftField, rightField, mofLeft, mofRight, qn, i);
        }
        MemberOf mof = new MemberOf(mofLeft, mofRight);
        if (qn.getQueryFilter() != null) {
            qn.setQueryFilter(new And(qn.getQueryFilter(), mof));
        } else {
            qn.setQueryFilter(mof);
        }
    }

    private static QueryNode pushDown(QueryTreeField leftField, QueryTreeField rightField, List mofLeft, List mofRight, QueryNode qn, int i) throws MalformedExpressionException, MedorException {
        logger.log(BasicLevel.DEBUG, (Object)("Entering pushDown for fields " + leftField.getName() + " and " + rightField.getName()));
        QueryTree qt1 = leftField.getQueryTree();
        QueryTree qt2 = rightField.getQueryTree();
        if (!(qt1 instanceof QueryLeaf) && qt1 == qt2) {
            logger.log(BasicLevel.DEBUG, (Object)("Fields on the same tree " + qt1));
            if (rightField instanceof PropagatedField && leftField instanceof PropagatedField) {
                QueryTreeField leftFDown = (QueryTreeField)((PropagatedField)leftField).getPreviousFields()[0];
                QueryTreeField rightFDown = (QueryTreeField)((PropagatedField)rightField).getPreviousFields()[0];
                QueryTree qtLDown = leftFDown.getQueryTree();
                if (qtLDown != rightFDown.getQueryTree()) {
                    logger.log(BasicLevel.DEBUG, (Object)"Propagated from fields on different trees: stop recursion");
                    mofLeft.set(i, new BasicFieldOperand(((PropagatedField)leftField).getPreviousFields()[0]));
                    mofRight.set(i, new BasicFieldOperand(((PropagatedField)rightField).getPreviousFields()[0]));
                    ((QueryNode)qt2).removeField(rightField.getName());
                    return (QueryNode)qt1;
                }
                logger.log(BasicLevel.DEBUG, (Object)"Propagated from fields on the same tree: go on with recursion");
                QueryNode qtPushed = MemberOfHelper.pushDown(leftFDown, rightFDown, mofLeft, mofRight, (QueryNode)qtLDown, i);
                ((QueryNode)qt2).removeField(rightField.getName());
                return qtPushed;
            }
            throw new MalformedExpressionException("The helper cannot deal with two fields on the same query node which are not propagated fields");
        }
        return qn;
    }
}

