/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.perseus.persistence.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.perseus.cache.api.CacheEntry;
import org.objectweb.perseus.cache.api.CacheEntryFactory;
import org.objectweb.perseus.cache.api.CacheException;
import org.objectweb.perseus.cache.api.CacheFullException;
import org.objectweb.perseus.cache.api.CacheManager;
import org.objectweb.perseus.cache.api.FixableCacheEntry;
import org.objectweb.perseus.cache.api.UnbindManager;
import org.objectweb.perseus.concurrency.api.ConcurrencyException;
import org.objectweb.perseus.concurrency.api.ConcurrencyManager;
import org.objectweb.perseus.concurrency.api.RolledBackConcurrencyException;
import org.objectweb.perseus.persistence.api.MemoryInstanceManager;
import org.objectweb.perseus.persistence.api.NoDSIPersistenceException;
import org.objectweb.perseus.persistence.api.PersistenceException;
import org.objectweb.perseus.persistence.api.PersistentObjectLifeCycleExcpetion;
import org.objectweb.perseus.persistence.api.RolledBackPersistenceException;
import org.objectweb.perseus.persistence.api.State;
import org.objectweb.perseus.persistence.api.StateFilter;
import org.objectweb.perseus.persistence.api.StateManager;
import org.objectweb.perseus.persistence.api.StorageManager;
import org.objectweb.perseus.persistence.api.TransactionalPersistenceManager;
import org.objectweb.perseus.persistence.api.TransactionalPersistenceManagerAttributeController;
import org.objectweb.perseus.persistence.api.TransactionalWorkingSet;
import org.objectweb.perseus.persistence.api.VirtualState;
import org.objectweb.perseus.persistence.api.WorkingSet;
import org.objectweb.perseus.persistence.api.WorkingSetFilter;
import org.objectweb.perseus.persistence.api.WorkingSetLifeCycle;
import org.objectweb.perseus.persistence.api.WorkingSetManager;
import org.objectweb.perseus.persistence.concurrency.NoDSIConcurrencyException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class TransactionalPersistenceManagerImpl
implements TransactionalPersistenceManager,
BindingController,
TransactionalPersistenceManagerAttributeController {
    public static final String CACHE_MANAGER_BINDING = "cache-manager";
    public static final String CONCURRENCY_MANAGER_BINDING = "concurrency-manager";
    public static final String STORAGE_MANAGER_BINDING = "storage-manager";
    public static final String STATE_MANAGER_BINDING = "state-manager";
    public static final String MEMORY_INSTANCE_MANAGER_BINDING = "memory-instance-manager";
    public static final String UNBIND_MANAGER_BINDING = "unbind-manager";
    public static final String WORKINGSET_MANAGER_BINDING = "workingset-manager";
    public static final String CACHE_ENTRY_FACTORY_BINDING = "cache-entry-factory";
    protected CacheManager cache;
    protected UnbindManager unbindManager;
    protected ConcurrencyManager cm;
    protected StorageManager storage;
    protected StateManager stateManager;
    protected WorkingSetManager wsManager;
    protected MemoryInstanceManager mim;
    protected Logger logger = null;
    protected Collection filters = null;
    protected CacheEntryFactory cef = null;

    protected void bindCeInWS(State state, WorkingSet ws, byte mode) {
        Object oid = state.getCacheEntry().getCeIdentifier();
        ws.bind(state, oid, mode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected CacheEntry getCacheEntry(WorkingSet ws, Object oid) throws PersistenceException {
        CacheEntry ce;
        State state;
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("getCacheEntry( " + oid + ")"));
        }
        if ((state = ws.lookup(oid)) != null && state != VirtualState.instance) {
            return state.getCacheEntry();
        }
        if (this.isShareableObject(oid, ws)) {
            ce = this.cache.lookup(oid);
            if (ce != null) return ce;
            Object po = this.mim.newInstance(oid, ws.getConnectionHolder());
            try {
                return this.cache.bind(oid, po);
            }
            catch (CacheFullException e) {
                throw new RolledBackPersistenceException(e);
            }
            catch (CacheException e) {
                ce = this.cache.lookup(oid);
                if (ce != null) return ce;
                this.logger.log(BasicLevel.WARN, (Object)("Recursive call for getting a cache entry (oid= " + oid + ")"));
                return this.getCacheEntry(ws, oid);
            }
        }
        Object po = this.mim.newInstance(oid, ws.getConnectionHolder());
        ce = this.cef.create(oid, po);
        this.stateManager.setReferenceState(ce, null);
        return ce;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkCacheEntry(CacheEntry ce, WorkingSet ws) throws PersistenceException {
        Object oid = ce.getCeIdentifier();
        if (oid == null) {
            throw new NoDSIPersistenceException("Impossible to read a non persistent object");
        }
        if (!this.stateManager.isBound(ce)) {
            this.unbindNonPersistentInstance(ce.getCeIdentifier(), ws);
            throw new NoDSIPersistenceException("Impossible to read a non persistent object");
        }
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("checkCacheEntry " + oid));
        }
        State state = ws.lookup(oid);
        Object po = ce.getCeObject();
        if (state != null && state != VirtualState.instance) {
            return;
        }
        if (!this.isCacheable(po, ws)) return;
        CacheEntry entryOfCache = this.cache.lookup(oid);
        if (entryOfCache == null) {
            try {
                entryOfCache = this.cache.bind(oid, ce.getCeObject());
                return;
            }
            catch (CacheFullException e) {
                throw new RolledBackPersistenceException(e);
            }
            catch (CacheException e) {
                if (this.logger == null || !this.logger.isLoggable(BasicLevel.DEBUG)) return;
                this.logger.log(BasicLevel.DEBUG, (Object)("checkCacheEntry " + oid));
                return;
            }
        } else {
            if (ce == entryOfCache || !this.isShareableObject(po, ws)) return;
            throw new RolledBackPersistenceException("Another persistent object is already present into the cache (identifier=" + oid + ")");
        }
    }

    private boolean isStateCacheable(Object o) {
        return this.stateManager.getCachingStrategy(o) > 1;
    }

    private boolean isShareableObject(Object o, WorkingSet ws) {
        return ws.getWSObjectSharing() && this.mim.isObjectSharing(o);
    }

    private boolean isCacheable(Object o, WorkingSet ws) {
        return this.isStateCacheable(o) || this.isShareableObject(o, ws);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean prepareWS(WorkingSet ws, boolean validate) throws PersistenceException {
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("prepareWS " + ws + " / " + validate));
        }
        boolean valid = validate;
        PersistenceException pe = null;
        try {
            ws.setStatus(WorkingSetLifeCycle.getNextStatus(ws.getStatus(), (byte)6));
        }
        catch (PersistenceException e) {
            pe = e;
            valid = false;
        }
        try {
            try {
                boolean bl = valid = this.cm.validate(ws) && valid;
                if (pe != null) {
                    throw pe;
                }
                if (valid) {
                    if (this.filters != null) {
                        Iterator it = this.filters.iterator();
                        while (it.hasNext()) {
                            WorkingSetFilter wsf = (WorkingSetFilter)it.next();
                            wsf.order(ws);
                        }
                    }
                    Set entries = ws.entries();
                    Iterator it = entries.iterator();
                    while (it.hasNext()) {
                        State state = (State)it.next();
                        if (state == VirtualState.instance || !this.stateManager.isDirty(state) || this.stateManager.isFlushed(state)) continue;
                        this.storage.write(ws.getConnectionHolder(), state.getCacheEntry().getCeIdentifier(), state);
                    }
                }
                Object var9_10 = null;
            }
            catch (Exception e) {
                PersistenceException persistenceException;
                valid = false;
                if (e instanceof PersistenceException) {
                    persistenceException = (PersistenceException)e;
                    throw persistenceException;
                }
                persistenceException = new PersistenceException("An exception occurs during the working preparation, it is marked as rolled back", e);
                throw persistenceException;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            ws.getConnectionHolder().releaseCHConnection();
            if (valid) {
                ws.setStatus(WorkingSetLifeCycle.getNextStatus(ws.getStatus(), (byte)7));
                throw throwable;
            }
            ws.setStatus(WorkingSetLifeCycle.getNextStatus(ws.getStatus(), (byte)8));
            throw throwable;
        }
        ws.getConnectionHolder().releaseCHConnection();
        if (valid) {
            ws.setStatus(WorkingSetLifeCycle.getNextStatus(ws.getStatus(), (byte)7));
            return valid;
        }
        ws.setStatus(WorkingSetLifeCycle.getNextStatus(ws.getStatus(), (byte)8));
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitWS(WorkingSet ws, byte action) throws PersistenceException {
        Object v1;
        byte newStatus;
        block25: {
            if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("commitWS " + ws + " / " + action));
            }
            newStatus = WorkingSetLifeCycle.getNextStatus(ws.getStatus(), action);
            try {
                ws.getConnectionHolder().commitCH();
            }
            catch (PersistenceException e) {
                this.rollbackWS(ws, (byte)4);
                throw new RolledBackPersistenceException(e);
            }
            boolean retainValues = ws.getWSRetainValues();
            try {
                ArrayList<Object> unexportedOids = null;
                Iterator it = ws.entries().iterator();
                while (it.hasNext()) {
                    State state = (State)it.next();
                    if (state == VirtualState.instance || !this.stateManager.isDirty(state)) continue;
                    CacheEntry ce = state.getCacheEntry();
                    if (this.stateManager.isUnexported(state)) {
                        if (this.isCacheable(ce.getCeObject(), ws)) {
                            if (unexportedOids == null) {
                                unexportedOids = new ArrayList<Object>();
                            }
                            unexportedOids.add(ce.getCeIdentifier());
                        }
                        if (this.stateManager.getReferenceState(ce) != state) {
                            this.stateManager.setReferenceState(ce, state);
                        }
                        this.stateManager.makeUnbound(ce);
                        continue;
                    }
                    Object po = ce.getCeIdentifier();
                    boolean shareable = this.isShareableObject(po, ws);
                    boolean cacheable = this.isStateCacheable(po);
                    if (retainValues && cacheable) {
                        CacheEntry entryOfCache;
                        Object oid = ce.getCeIdentifier();
                        if (!shareable) {
                            entryOfCache = this.cache.lookup(oid);
                            if (entryOfCache == null) {
                                this.stateManager.destroyState(state);
                                continue;
                            }
                        } else {
                            entryOfCache = ce;
                        }
                        if (this.stateManager.isToMerge(state)) {
                            Object object = entryOfCache.getCeIdentifier();
                            synchronized (object) {
                                State s = this.stateManager.getReferenceState(entryOfCache);
                                if (s != null) {
                                    s = this.stateManager.merge(s, state);
                                    this.stateManager.setReferenceState(entryOfCache, s);
                                }
                                continue;
                            }
                        }
                        this.stateManager.makeClean(state);
                        State rs = this.stateManager.getReferenceState(entryOfCache);
                        if (rs == null || rs == state) continue;
                        this.stateManager.setReferenceState(entryOfCache, state);
                        continue;
                    }
                    if (this.stateManager.getReferenceState(ce) != state) continue;
                    this.stateManager.makeClean(state);
                    this.stateManager.setReferenceState(ce, null);
                    this.stateManager.destroyState(state);
                }
                try {
                    if (unexportedOids != null) {
                        this.unbindManager.unbindAll(unexportedOids, true);
                    }
                }
                catch (CacheException e) {
                    throw new PersistenceException(e);
                }
                Object var18_19 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var18_20 = null;
                try {
                    ws.getConnectionHolder().closeCHConnection();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var20_24 = v0;
                this.storage.endWS(ws);
                this.cm.finalize(ws);
                ws.setStatus(newStatus);
                ws.clear();
                throw throwable;
            }
            try {
                ws.getConnectionHolder().closeCHConnection();
                v1 = null;
                break block25;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var20_23 = v1;
        this.storage.endWS(ws);
        this.cm.finalize(ws);
        ws.setStatus(newStatus);
        ws.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackWS(WorkingSet ws, byte action) throws PersistenceException {
        Object v1;
        byte newStatus;
        block17: {
            if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("rollbackWS " + ws + " / " + action));
            }
            newStatus = WorkingSetLifeCycle.getNextStatus(ws.getStatus(), action);
            try {
                ws.getConnectionHolder().rollbackCH();
            }
            finally {
                ws.setStatus(newStatus);
            }
            try {
                ArrayList<Object> unexportedOids = null;
                Iterator i = ws.entries().iterator();
                while (i.hasNext()) {
                    State state = (State)i.next();
                    if (state == VirtualState.instance || !this.stateManager.isDirty(state)) continue;
                    CacheEntry ce = state.getCacheEntry();
                    if (this.stateManager.isExported(state)) {
                        if (unexportedOids == null) {
                            unexportedOids = new ArrayList<Object>();
                        }
                        unexportedOids.add(ce.getCeIdentifier());
                        this.stateManager.makeClean(state);
                        this.stateManager.makeUnbound(ce);
                        continue;
                    }
                    if (this.stateManager.isUnexported(state)) {
                        this.stateManager.makeClean(state);
                        this.stateManager.makeBound(ce, ce.getCeIdentifier());
                    }
                    this.stateManager.setReferenceState(ce, null);
                    this.stateManager.destroyState(state);
                }
                if (unexportedOids != null) {
                    try {
                        this.unbindManager.unbindAll(unexportedOids, true);
                    }
                    catch (CacheException ce) {
                        throw new PersistenceException("Impossible to rollback - ", ce);
                    }
                }
                Object var9_10 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var9_11 = null;
                try {
                    ws.getConnectionHolder().closeCHConnection();
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var11_15 = v0;
                this.storage.endWS(ws);
                this.cm.abort(ws);
                ws.clear();
                ws.setStatus(newStatus);
                throw throwable;
            }
            try {
                ws.getConnectionHolder().closeCHConnection();
                v1 = null;
                break block17;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            {
            }
        }
        Object var11_14 = v1;
        this.storage.endWS(ws);
        this.cm.abort(ws);
        ws.clear();
        ws.setStatus(newStatus);
    }

    private void assertOpenWorkingset(WorkingSet ws) throws PersistenceException {
        if (ws.getStatus() == 32) {
            throw new PersistenceException("Impossible to work with a closed WorkingSet");
        }
    }

    public String[] listFc() {
        return new String[]{CACHE_MANAGER_BINDING, CONCURRENCY_MANAGER_BINDING, STATE_MANAGER_BINDING, STORAGE_MANAGER_BINDING, MEMORY_INSTANCE_MANAGER_BINDING, UNBIND_MANAGER_BINDING, WORKINGSET_MANAGER_BINDING, STATE_MANAGER_BINDING, CACHE_ENTRY_FACTORY_BINDING};
    }

    public Object lookupFc(String s) {
        if (CACHE_MANAGER_BINDING.equals(s)) {
            return this.cache;
        }
        if (CONCURRENCY_MANAGER_BINDING.equals(s)) {
            return this.cm;
        }
        if (STATE_MANAGER_BINDING.equals(s)) {
            return this.stateManager;
        }
        if (STORAGE_MANAGER_BINDING.equals(s)) {
            return this.storage;
        }
        if (MEMORY_INSTANCE_MANAGER_BINDING.equals(s)) {
            return this.mim;
        }
        if (UNBIND_MANAGER_BINDING.equals(s)) {
            return this.unbindManager;
        }
        if (WORKINGSET_MANAGER_BINDING.equals(s)) {
            return this.wsManager;
        }
        if (STATE_MANAGER_BINDING.equals(s)) {
            return this.stateManager;
        }
        if (CACHE_ENTRY_FACTORY_BINDING.equals(s)) {
            return this.cef;
        }
        return null;
    }

    public void bindFc(String s, Object o) {
        if ("logger".equals(s)) {
            this.logger = (Logger)o;
        } else if (CACHE_MANAGER_BINDING.equals(s)) {
            this.cache = (CacheManager)o;
        } else if (CONCURRENCY_MANAGER_BINDING.equals(s)) {
            this.cm = (ConcurrencyManager)o;
        } else if (STATE_MANAGER_BINDING.equals(s)) {
            this.stateManager = (StateManager)o;
        } else if (STORAGE_MANAGER_BINDING.equals(s)) {
            this.storage = (StorageManager)o;
        } else if (MEMORY_INSTANCE_MANAGER_BINDING.equals(s)) {
            this.mim = (MemoryInstanceManager)o;
        } else if (UNBIND_MANAGER_BINDING.equals(s)) {
            this.unbindManager = (UnbindManager)o;
        } else if (WORKINGSET_MANAGER_BINDING.equals(s)) {
            this.wsManager = (WorkingSetManager)o;
        } else if (STATE_MANAGER_BINDING.equals(s)) {
            this.stateManager = (StateManager)o;
        } else if (CACHE_ENTRY_FACTORY_BINDING.equals(s)) {
            this.cef = (CacheEntryFactory)o;
        }
    }

    public void unbindFc(String s) {
        if (CACHE_MANAGER_BINDING.equals(s)) {
            this.cache = null;
        } else if (CONCURRENCY_MANAGER_BINDING.equals(s)) {
            this.cm = null;
        } else if (STATE_MANAGER_BINDING.equals(s)) {
            this.stateManager = null;
        } else if (STORAGE_MANAGER_BINDING.equals(s)) {
            this.storage = null;
        } else if (MEMORY_INSTANCE_MANAGER_BINDING.equals(s)) {
            this.mim = null;
        } else if (UNBIND_MANAGER_BINDING.equals(s)) {
            this.unbindManager = null;
        } else if (WORKINGSET_MANAGER_BINDING.equals(s)) {
            this.wsManager = null;
        } else if (STATE_MANAGER_BINDING.equals(s)) {
            this.stateManager = null;
        } else if (CACHE_ENTRY_FACTORY_BINDING.equals(s)) {
            this.cef = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(Object _ws, Object resourceId, Object resourceHints, Object lockHints, boolean resourceCopyRequired, Object suggestedResource, Object synchronizer) throws ConcurrencyException {
        if (suggestedResource != null) {
            return suggestedResource;
        }
        WorkingSet ws = (WorkingSet)_ws;
        State state = null;
        CacheEntry ce = (CacheEntry)resourceHints;
        Object po = ce.getCeObject();
        if (this.isStateCacheable(po)) {
            if (this.isShareableObject(po, ws)) {
                state = this.stateManager.getReferenceState(ce);
                if (state == null) {
                    Object object = synchronizer;
                    synchronized (object) {
                        state = this.stateManager.getReferenceState(ce);
                        if (state == null) {
                            state = this.load(ws, ce);
                            this.stateManager.setReferenceState(ce, state);
                        }
                    }
                }
                if (resourceCopyRequired || lockHints != null) {
                    state = this.stateManager.createState(state);
                    if (lockHints != null) {
                        this.stateManager.makeClean(state);
                        this.stateManager.makeToMerge(state, lockHints);
                    }
                }
            } else {
                CacheEntry entryOfCache = this.cache.lookup(resourceId);
                if (entryOfCache != null) {
                    state = this.stateManager.getReferenceState(entryOfCache);
                }
                if (state == null) {
                    Object object = synchronizer;
                    synchronized (object) {
                        if (entryOfCache != null) {
                            state = this.stateManager.getReferenceState(entryOfCache);
                        }
                        if (state == null) {
                            state = this.load(ws, entryOfCache);
                        }
                    }
                    if (entryOfCache != null) {
                        this.stateManager.setReferenceState(entryOfCache, state);
                    }
                }
                state = this.stateManager.createState(state);
                this.stateManager.makeClean(state);
                this.stateManager.setReferenceState(ce, state);
                state.setCacheEntry(ce);
                if (lockHints != null) {
                    this.stateManager.makeToMerge(state, lockHints);
                }
            }
        } else {
            state = this.load(ws, ce);
        }
        return state;
    }

    private State load(WorkingSet ws, CacheEntry ce) throws ConcurrencyException {
        State state = this.stateManager.createState(ce);
        Object oid = ce.getCeIdentifier();
        try {
            this.storage.read(ws, oid, state, false);
            this.stateManager.makeClean(state);
            return state;
        }
        catch (PersistenceException e) {
            this.stateManager.destroyState(state);
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("Error during loading:\n\t-oid=" + oid + "\n\t-ws.lookup(oid)=" + ws.lookup(oid) + "\n\t-ce.rs=" + this.stateManager.getReferenceState(ce) + "\n\t-exception=" + e.getClass().getName() + ":" + e.getMessage()));
            }
            if (e instanceof NoDSIPersistenceException) {
                throw new NoDSIConcurrencyException(e);
            }
            throw new ConcurrencyException(e);
        }
    }

    public State export(WorkingSet ws, Object obj) throws PersistenceException {
        return this.export(ws, obj, null);
    }

    public State export(WorkingSet ws, Object obj, Object hints) throws PersistenceException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("export ctx=" + ws + " / obj=" + obj.getClass().getName() + " / hints=" + hints));
        }
        this.assertOpenWorkingset(ws);
        State state = null;
        Object oid = null;
        CacheEntry ce = null;
        try {
            oid = hints == null ? this.storage.export(ws.getConnectionHolder(), obj) : this.storage.export(ws.getConnectionHolder(), obj, hints);
            ce = this.isCacheable(obj, ws) ? this.cache.bind(oid, obj) : this.cef.create(oid, obj);
            state = this.stateManager.getReferenceState(ce);
            this.stateManager.makeExported(state);
            ws.bind(state, oid, (byte)2);
            this.getWriteRight(ws, oid, null, state);
            return state;
        }
        catch (PersistenceException e) {
            if (ce != null) {
                this.stateManager.makeUnbound(ce);
            }
            throw e;
        }
        catch (CacheFullException e) {
            throw new RolledBackPersistenceException(e);
        }
        catch (CacheException e) {
            try {
                state = ws.lookup(oid);
                if (state != null && this.stateManager.isUnexported(state) && (ce = this.cache.lookup(oid)) != null) {
                    this.unbindManager.unbind(oid, true);
                    ce = this.cache.bind(oid, obj);
                    state = this.stateManager.getReferenceState(ce);
                    if (state == null) {
                        state = VirtualState.instance;
                    }
                    ws.bind(state, oid, (byte)2);
                    this.getWriteRight(ws, oid, null, state);
                    this.stateManager.makeDirty(state);
                    this.stateManager.makeExported(state);
                    return state;
                }
            }
            catch (CacheException cacheE) {
                throw new PersistenceException("Cannot put object into cache, oid=" + oid, cacheE);
            }
            throw new PersistenceException("Cannot put object into cache, oid=" + oid, e);
        }
    }

    public State unexport(WorkingSet ws, Object oid) throws PersistenceException {
        this.assertOpenWorkingset(ws);
        CacheEntry ce = this.getCacheEntry(ws, oid);
        if (!this.stateManager.isBound(ce)) {
            throw new PersistentObjectLifeCycleExcpetion("Impossible to remove a non persistent object");
        }
        State state = this.stateManager.createState(ce);
        this.getWriteRight(ws, oid, null, state);
        this.storage.unexport(ws.getConnectionHolder(), oid, ce);
        this.stateManager.makeUnexported(state);
        return state;
    }

    public State unexport(WorkingSet ws, CacheEntry ce) throws PersistenceException {
        this.assertOpenWorkingset(ws);
        if (!this.stateManager.isBound(ce)) {
            throw new PersistentObjectLifeCycleExcpetion("Impossible to remove a non persistent object");
        }
        Object oid = ce.getCeIdentifier();
        State state = this.getWriteRightNState(ws, ce, null);
        this.storage.unexport(ws.getConnectionHolder(), oid, ce);
        this.stateManager.makeUnexported(state);
        return state;
    }

    public CacheEntry getObjectById(WorkingSet ws, Object oid) throws PersistenceException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("getObjectById ctx=" + ws + " / oid=" + oid));
        }
        this.assertOpenWorkingset(ws);
        State s = ws.lookup(oid);
        if (s != null && s != VirtualState.instance) {
            return s.getCacheEntry();
        }
        return this.getCacheEntry(ws, oid);
    }

    public State readIntention(WorkingSet ws, Object oid, Object thinLock) throws PersistenceException {
        this.assertOpenWorkingset(ws);
        try {
            return this._readIntention(ws, this.getCacheEntry(ws, oid), thinLock);
        }
        catch (NoDSIPersistenceException e) {
            this.unbindNonPersistentInstance(oid, ws);
            throw e;
        }
    }

    public State readIntention(WorkingSet ws, CacheEntry ce, Object thinLock) throws PersistenceException {
        this.assertOpenWorkingset(ws);
        this.checkCacheEntry(ce, ws);
        return this._readIntention(ws, ce, thinLock);
    }

    private State _readIntention(WorkingSet ws, CacheEntry ce, Object thinLock) throws PersistenceException {
        Object oid = ce.getCeIdentifier();
        State state = ws.lookup(oid);
        if (state != null) {
            if (state == VirtualState.instance) {
                state = null;
            } else {
                return state;
            }
        }
        try {
            state = (State)this.cm.readIntention(ws, oid, thinLock, this, ce);
        }
        catch (RolledBackConcurrencyException e) {
            throw new RolledBackPersistenceException(e);
        }
        catch (NoDSIConcurrencyException e) {
            this.unbindNonPersistentInstance(oid, ws);
            throw new NoDSIPersistenceException(e);
        }
        catch (ConcurrencyException e) {
            throw new PersistenceException(e);
        }
        ws.bind(state, oid, (byte)1);
        return state;
    }

    public State writeIntention(WorkingSet ws, Object oid, Object thinLock) throws PersistenceException {
        this.assertOpenWorkingset(ws);
        try {
            return this.getWriteRightNState(ws, this.getCacheEntry(ws, oid), thinLock);
        }
        catch (NoDSIPersistenceException e) {
            this.unbindNonPersistentInstance(oid, ws);
            throw e;
        }
    }

    public State writeIntention(WorkingSet ws, CacheEntry ce, Object thinLock) throws PersistenceException {
        this.assertOpenWorkingset(ws);
        this.checkCacheEntry(ce, ws);
        return this.getWriteRightNState(ws, ce, thinLock);
    }

    public void getWriteRight(WorkingSet ws, Object oid, Object thinLock, State state) throws PersistenceException {
        State wsstate = ws.lookup(oid);
        if (wsstate == state && this.stateManager.isDirty(state)) {
            return;
        }
        try {
            this.cm.writeIntention(ws, oid, thinLock, null, null);
        }
        catch (RolledBackConcurrencyException e) {
            throw new RolledBackPersistenceException(e);
        }
        catch (NoDSIConcurrencyException e) {
            this.unbindNonPersistentInstance(oid, ws);
            throw new NoDSIPersistenceException(e);
        }
        catch (ConcurrencyException e) {
            throw new PersistenceException(e);
        }
        ws.bind(state, oid, (byte)2);
        this.stateManager.makeDirty(state);
    }

    public State getWriteRightNState(WorkingSet ws, CacheEntry ce, Object thinLock) throws PersistenceException {
        Object oid = ce.getCeIdentifier();
        State state = ws.lookup(oid);
        if (state != null) {
            if (state == VirtualState.instance) {
                state = null;
            } else if (this.stateManager.isDirty(state)) {
                if (this.stateManager.isFlushed(state)) {
                    this.stateManager.makeDirty(state);
                }
                return state;
            }
        }
        try {
            state = (State)this.cm.writeIntention(ws, oid, thinLock, this, ce);
        }
        catch (RolledBackConcurrencyException e) {
            throw new RolledBackPersistenceException(e);
        }
        catch (NoDSIConcurrencyException e) {
            this.unbindNonPersistentInstance(oid, ws);
            throw new NoDSIPersistenceException(e);
        }
        catch (ConcurrencyException e) {
            throw new PersistenceException(e);
        }
        ws.bind(state, oid, (byte)2);
        this.stateManager.makeDirty(state);
        return state;
    }

    private void unbindNonPersistentInstance(Object oid, WorkingSet ws) {
        if (oid == null) {
            return;
        }
        if (this.cache.lookup(oid) != null) {
            try {
                this.unbindManager.unbind(oid, true);
            }
            catch (CacheException e1) {
                this.logger.log(BasicLevel.ERROR, (Object)"Impossible to unbind from the cache an entry which does not exist on the data support", (Throwable)e1);
            }
        }
        ws.unbind(oid);
    }

    public void accessCompletion(WorkingSet ws, State ce) throws PersistenceException {
        this.assertOpenWorkingset(ws);
    }

    public void flush(WorkingSet ws, StateFilter statefilter) throws PersistenceException {
        this.assertOpenWorkingset(ws);
        Iterator it = ws.entries().iterator();
        while (it.hasNext()) {
            State state = (State)it.next();
            if (state == VirtualState.instance || !this.stateManager.isDirty(state) || this.stateManager.isFlushed(state) || statefilter != null && !statefilter.accept(state)) continue;
            this.storage.write(ws.getConnectionHolder(), state.getCacheEntry().getCeIdentifier(), state);
            this.stateManager.makeFlushed(state);
        }
    }

    public void flush(WorkingSet ws, State stateToFlush) throws PersistenceException {
        this.assertOpenWorkingset(ws);
        State state = ws.lookup(stateToFlush.getCacheEntry().getCeIdentifier());
        if (state == stateToFlush && this.stateManager.isDirty(state) && !this.stateManager.isFlushed(state)) {
            this.storage.write(ws.getConnectionHolder(), state.getCacheEntry().getCeIdentifier(), state);
            this.stateManager.makeFlushed(state);
        }
    }

    public boolean evict(WorkingSet ws, Object oid, boolean force) throws PersistenceException {
        FixableCacheEntry ce = (FixableCacheEntry)this.cache.lookup(oid);
        this.assertOpenWorkingset(ws);
        if (ce == null) {
            return true;
        }
        int fix = ce.getCeFixCount();
        State state = ws.lookup(oid);
        if (state != null) {
            if (this.stateManager.isDirty(state) && !this.stateManager.isFlushed(state)) {
                this.storage.write(ws.getConnectionHolder(), oid, state);
                this.stateManager.makeFlushed(state);
            }
            ws.bind(VirtualState.instance, oid, (byte)3);
        }
        if (fix > 0) {
            if (force) {
                throw new PersistenceException("Impossible to evict an entry from the cache: There is another user than the given working set");
            }
            return false;
        }
        this.stateManager.setReferenceState(ce, null);
        ce = null;
        try {
            return this.unbindManager.unbind(oid, false);
        }
        catch (CacheException e) {
            if (force) {
                throw new PersistenceException("Impossible to unbind the entry: ", e);
            }
            return false;
        }
    }

    public int evictAll(WorkingSet ws, boolean force) throws PersistenceException {
        if (ws != null) {
            this.assertOpenWorkingset(ws);
        }
        try {
            return this.unbindManager.unbindUnfixed(force).size();
        }
        catch (CacheException e) {
            throw new PersistenceException(e);
        }
    }

    public void unbind(WorkingSet ws, Object oid) throws PersistenceException {
        this.assertOpenWorkingset(ws);
        this.unbind(ws, this.getCacheEntry(ws, oid));
    }

    public void unbind(WorkingSet ws, CacheEntry ce) throws PersistenceException {
        this.assertOpenWorkingset(ws);
        FixableCacheEntry fce = (FixableCacheEntry)ce;
        Object oid = ce.getCeIdentifier();
        State state = ws.lookup(oid);
        if (state == null) {
            state = this.readIntention(ws, ce, null);
        } else if (this.stateManager.isDirty(state) && !this.stateManager.isFlushed(state)) {
            this.storage.write(ws.getConnectionHolder(), oid, state);
            this.stateManager.makeFlushed(state);
        }
        ws.bind(VirtualState.instance, oid, (byte)3);
        if (this.isCacheable(ce.getCeObject(), ws)) {
            try {
                while (fce.getCeFixCount() > 0) {
                    this.cache.unfix(fce);
                }
                this.unbindManager.unbind(oid, true);
            }
            catch (CacheException e) {
                throw new PersistenceException("Impossible to unbind the entry: ", e);
            }
        }
        this.stateManager.makeUnbound(ce);
        this.stateManager.setReferenceState(ce, state);
    }

    public void refresh(WorkingSet ws, Object oid) throws PersistenceException {
        this.assertOpenWorkingset(ws);
        CacheEntry ce = this.cache.lookup(oid);
        if (ce != null) {
            this.refresh(ws, ce);
        }
    }

    public void refresh(WorkingSet ws, CacheEntry ce) throws PersistenceException {
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("refresh " + ce.getCeIdentifier()));
        }
        this.assertOpenWorkingset(ws);
        this.stateManager.setReferenceState(ce, null);
        ws.bind(VirtualState.instance, ce.getCeIdentifier(), (byte)3);
    }

    public WorkingSet createWS(Object userObject) throws PersistenceException {
        WorkingSet ws = this.wsManager.createWS(userObject);
        this.storage.beginWS(ws);
        return ws;
    }

    public WorkingSet createWS(Object userObject, Object workingSetType) throws PersistenceException {
        WorkingSet ws = this.wsManager.createWS(userObject, workingSetType);
        this.storage.beginWS(ws);
        return ws;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(WorkingSet context) throws PersistenceException {
        block6: {
            if (!context.entries().isEmpty()) {
                boolean prepared_ok = false;
                PersistenceException pe = null;
                try {
                    prepared_ok = this.prepareWS(context, true);
                }
                catch (PersistenceException e) {
                    pe = e;
                }
                if (prepared_ok) {
                    this.commitWS(context, (byte)5);
                    break block6;
                } else {
                    this.rollbackWS(context, (byte)5);
                    if (pe == null) {
                        throw new RolledBackPersistenceException();
                    }
                    throw pe;
                }
            }
            context.getConnectionHolder().closeCHConnection();
            context.setStatus(WorkingSetLifeCycle.getNextStatus(context.getStatus(), (byte)5));
            this.storage.endWS(context);
        }
        this.wsManager.closeWS(context);
    }

    public void begin(TransactionalWorkingSet tx) throws PersistenceException {
        this.assertOpenWorkingset(tx);
        if (this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("begin " + tx));
        }
        if (tx.entries().size() > 0) {
            this.logger.log(BasicLevel.DEBUG, (Object)("Flush modification before the transaction " + tx));
            this.close(tx);
        }
        this.storage.beginWS(tx);
        tx.getConnectionHolder().begin();
        tx.setStatus(WorkingSetLifeCycle.getNextStatus(tx.getStatus(), (byte)2));
    }

    public boolean prepare(TransactionalWorkingSet tx) throws PersistenceException {
        this.assertOpenWorkingset(tx);
        return this.prepareWS(tx, !tx.getWSRollBackOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(TransactionalWorkingSet tx) throws PersistenceException {
        this.assertOpenWorkingset(tx);
        try {
            if (tx.getStatus() == 2) {
                boolean prepared_ok = false;
                PersistenceException pe = null;
                try {
                    prepared_ok = this.prepareWS(tx, !tx.getWSRollBackOnly());
                }
                catch (PersistenceException e) {
                    pe = e;
                }
                if (prepared_ok) {
                    this.commitWS(tx, (byte)3);
                    return;
                }
                this.rollbackWS(tx, (byte)4);
                if (pe != null) throw pe;
                throw new RolledBackPersistenceException();
            }
            this.commitWS(tx, (byte)3);
            return;
        }
        finally {
            this.storage.beginWS(tx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(TransactionalWorkingSet tx) throws PersistenceException {
        this.assertOpenWorkingset(tx);
        try {
            byte status = tx.getStatus();
            if (status != 6 && status != 5) {
                try {
                    this.prepareWS(tx, false);
                }
                catch (PersistenceException e) {
                    this.logger.log(BasicLevel.WARN, (Object)"An error occris during the rollback operation", (Throwable)e);
                }
            }
            this.rollbackWS(tx, (byte)4);
        }
        finally {
            this.storage.beginWS(tx);
        }
    }

    public void setFilters(Collection fs) throws IllegalArgumentException {
        this.filters = fs;
    }

    public Collection getFilters() {
        return this.filters;
    }
}

