/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.configuration;

import java.lang.reflect.Method;
import java.util.Properties;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.apache.commons.logging.Log;
import org.ow2.carol.util.configuration.ConfigurationException;
import org.ow2.carol.util.configuration.TraceCarol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Protocol {
    private final String name;
    private final Properties properties;
    private PortableRemoteObjectDelegate portableRemoteObjectDelegate = null;
    private final String portableRemoteObjectClassName;
    private final String initialContextFactoryClassName;
    private final String registryClassName;
    private final String interceptorNamePrefix;

    protected String getValue(String key) throws ConfigurationException {
        String s = this.properties.getProperty(key);
        if (s == null) {
            throw new ConfigurationException("Property '" + key + "' was not found in the properties object of the protocol, properties are :'" + this.properties + "'");
        }
        return s;
    }

    @Deprecated
    protected Protocol() {
        this.name = null;
        this.properties = null;
        this.portableRemoteObjectClassName = null;
        this.initialContextFactoryClassName = null;
        this.registryClassName = null;
        this.interceptorNamePrefix = null;
    }

    public Protocol(String name, Properties properties, Log logger, String domainName, String serverName) throws ConfigurationException {
        String setterClass;
        if (name == null || "".equals(name)) {
            throw new ConfigurationException("Cannot build a protocol with null or empty name");
        }
        this.name = name;
        if (properties == null) {
            throw new ConfigurationException("Cannot build a new protocol without properties");
        }
        this.properties = properties;
        String dName = domainName == null ? "defaultDomain" : domainName;
        String sName = serverName == null ? "defaultServer" : serverName;
        String prefixProtocol = "carol." + name + ".";
        this.portableRemoteObjectClassName = this.getValue(prefixProtocol + "PortableRemoteObjectClass");
        this.initialContextFactoryClassName = this.getValue(prefixProtocol + "context.factory");
        this.registryClassName = this.getValue(prefixProtocol + "NameServiceClass");
        this.interceptorNamePrefix = properties.getProperty("carol." + name + "." + "interceptor.pkgs");
        String interceptorValues = properties.getProperty("carol." + name + "." + "interceptors");
        if (this.interceptorNamePrefix != null && interceptorValues != null) {
            String[] values;
            for (String value : values = interceptorValues.split(",")) {
                this.addInterceptor(value);
            }
        }
        if ((setterClass = properties.getProperty("carol." + name + "." + "setter.class")) != null) {
            String setterMethodProperties = this.getValue("carol." + name + "." + "setter.methodProperties");
            String setterMethodMBean = this.getValue("carol." + name + "." + "setter.methodMBean");
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(setterClass);
                Method mProperties = clazz.getMethod(setterMethodProperties, Properties.class);
                mProperties.invoke(null, properties);
                Method mMBean = clazz.getMethod(setterMethodMBean, String.class, String.class);
                mMBean.invoke(null, dName, sName);
            }
            catch (ClassNotFoundException cnfe) {
                if (logger.isDebugEnabled()) {
                    logger.debug(name + "is not available, don't configure it.");
                }
            }
            catch (NoClassDefFoundError ncdfe) {
                if (logger.isDebugEnabled()) {
                    logger.debug(name + "is not available, don't configure it.");
                }
            }
            catch (Exception ex) {
                TraceCarol.error("Cannot set the " + name + " configuration.", ex);
                throw new ConfigurationException("Cannot set the " + name + " configuration.", ex);
            }
        }
    }

    @Deprecated
    public void addInterceptor(String interceptorInitializer) {
        System.setProperty(this.interceptorNamePrefix + "." + interceptorInitializer, "");
        if (TraceCarol.isDebugCarol()) {
            TraceCarol.debugCarol("Setting interceptor " + this.interceptorNamePrefix + "." + interceptorInitializer + "/");
        }
    }

    public void addInterceptor(Class<?> jinitClass) {
        TraceCarol.error("The protocol " + this.name + "doesn't support dynamic interceptors.");
        throw new UnsupportedOperationException("The protocol " + this.name + "doesn't support dynamic interceptors.");
    }

    public void removeInterceptor(Class<?> jinitClass) {
        TraceCarol.error("The protocol " + this.name + "doesn't support dynamic interceptors.");
        throw new UnsupportedOperationException("The protocol " + this.name + "doesn't support dynamic interceptors.");
    }

    public String getInitialContextFactoryClassName() {
        return this.initialContextFactoryClassName;
    }

    public String getRegistryClassName() {
        return this.registryClassName;
    }

    public PortableRemoteObjectDelegate getPortableRemoteObject() {
        if (this.portableRemoteObjectDelegate != null) {
            return this.portableRemoteObjectDelegate;
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.portableRemoteObjectClassName);
            this.portableRemoteObjectDelegate = (PortableRemoteObjectDelegate)clazz.newInstance();
        }
        catch (Exception e) {
            IllegalStateException newEx = new IllegalStateException("Cannot build PortableRemoteObjectDelegate class '" + this.portableRemoteObjectClassName + "'");
            newEx.initCause(e);
            throw newEx;
        }
        return this.portableRemoteObjectDelegate;
    }

    public String getName() {
        return this.name;
    }
}

