/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.csiv2.gss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import org.ow2.carol.util.configuration.TraceCarol;

public class GSSHelper {
    private static final byte[] EXPORTED_NAME_TOK_ID = new byte[]{4, 1};
    private static final int[] TWO_BYTES = new int[]{65280, 255};
    private static final int[] FOUR_BYTES = new int[]{-16777216, 0xFF0000, 65280, 255};
    private static final int BYTES = 255;
    private static final int SEQUENCE = 96;
    private static final int OBJECT_IDENTIFIER = 6;

    private GSSHelper() {
    }

    public static byte[] encodeExported(String name) {
        byte[] mechOidDer = GSSHelper.getMechOidDer();
        byte[] nameBytes = null;
        try {
            nameBytes = name.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException("Cannot get utf-8 encoding" + uee.getMessage());
        }
        int nameLength = name.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(EXPORTED_NAME_TOK_ID[0]);
        bos.write(EXPORTED_NAME_TOK_ID[1]);
        int mechOidLength = mechOidDer.length;
        bos.write(mechOidLength & TWO_BYTES[0]);
        bos.write(mechOidLength & TWO_BYTES[1]);
        bos.write(mechOidDer, 0, mechOidDer.length);
        bos.write(nameLength & FOUR_BYTES[0]);
        bos.write(nameLength & FOUR_BYTES[1]);
        bos.write(nameLength & FOUR_BYTES[2]);
        bos.write(nameLength & FOUR_BYTES[3]);
        bos.write(nameBytes, 0, nameBytes.length);
        return bos.toByteArray();
    }

    public static String decodeExported(byte[] toDecode) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(toDecode);
        if (bis.read() != EXPORTED_NAME_TOK_ID[0] || bis.read() != EXPORTED_NAME_TOK_ID[1]) {
            throw new IllegalArgumentException("Invalid header, this is not an exported name");
        }
        int mechOidLength = bis.read() * 8 + bis.read();
        byte[] mechOidDerTemplate = GSSHelper.getMechOidDer();
        byte[] mechOidDer = new byte[mechOidLength];
        int success = bis.read(mechOidDer);
        if (success == -1 || success != mechOidDerTemplate.length) {
            throw new IllegalArgumentException("Not able to decode name, length is incorrect");
        }
        for (int b = 0; b < mechOidDerTemplate.length; ++b) {
            if (mechOidDer[b] == mechOidDerTemplate[b]) continue;
            throw new IllegalArgumentException("Not a valid MechoID");
        }
        int nameLength = bis.read() * 24 + bis.read() * 16 + bis.read() * 8 + bis.read();
        byte[] name = new byte[nameLength];
        success = bis.read(name);
        if (success == -1 || success != nameLength) {
            throw new IllegalArgumentException("Not able to decode name, length is incorrect");
        }
        return new String(name);
    }

    private static String getMechOID() {
        return "oid:2.23.130.1.1.1".substring(4);
    }

    public static byte[] decodeToken(byte[] toExtract) {
        int i;
        int lengthTmp;
        int b = 0;
        if (toExtract[b++] != 96) {
            throw new IllegalArgumentException("Invalid token");
        }
        int tokenLegnth = 0;
        if (((lengthTmp = toExtract[b++]) & 0x80) == 128) {
            int additionalOctets = lengthTmp & 0x7F;
            for (i = 0; i < additionalOctets; ++i) {
                tokenLegnth = (tokenLegnth << 8) + (toExtract[b++] & 0xFF);
            }
        } else {
            tokenLegnth = lengthTmp;
        }
        if (toExtract[b] != 6) {
            throw new IllegalArgumentException("Invalid object identifier");
        }
        byte[] mechOidDerTemplate = GSSHelper.getMechOidDer();
        for (i = 0; i < mechOidDerTemplate.length; ++i) {
            if (toExtract[b++] == mechOidDerTemplate[i]) continue;
            throw new IllegalArgumentException("Not a valid MechoID");
        }
        int objLength = toExtract.length - b;
        byte[] objId = new byte[objLength];
        System.arraycopy(toExtract, b, objId, 0, objLength);
        return objId;
    }

    public static byte[] encodeToken(byte[] contextData) throws IOException {
        byte[] mechOidDer = GSSHelper.getMechOidDer();
        int mechOidLength = mechOidDer.length;
        int contextDataLength = contextData.length;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(96);
        bos.write(mechOidLength + contextDataLength);
        bos.write(mechOidDer);
        bos.write(contextData);
        return bos.toByteArray();
    }

    public static byte[] getMechOidDer() {
        Oid oid = null;
        byte[] gssupDerEncoding = null;
        try {
            oid = new Oid(GSSHelper.getMechOID());
            gssupDerEncoding = oid.getDER();
        }
        catch (GSSException gsse) {
            TraceCarol.error("Error while getting MechOID");
            return null;
        }
        return gssupDerEncoding;
    }
}

