/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.cmi.ha.interceptor.iiop;

import java.io.IOException;
import java.util.Stack;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.ow2.cmi.ha.RequestId;
import org.ow2.cmi.ha.interceptor.HAContext;
import org.ow2.cmi.ha.interceptor.HACurrent;
import org.ow2.cmi.ha.interceptor.iiop.HAInterceptor;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class HAClientInterceptor
extends HAInterceptor
implements ClientRequestInterceptor {
    private static final long serialVersionUID = 7391445843768730939L;
    private String interceptorName = "HAClientInterceptor";
    private static Log logger = LogFactory.getLog(HAClientInterceptor.class);

    public String name() {
        return this.interceptorName;
    }

    public void send_request(ClientRequestInfo jri) throws ForwardRequest {
        HACurrent current = HACurrent.getHACurrent();
        HAContext newHACtx = new HAContext();
        Stack<RequestId> requests = current.getRequests();
        newHACtx.setRequests(requests);
        newHACtx.setOnFailover(current.isOnFailover());
        logger.debug("Propagating requests chain: " + newHACtx, new Object[0]);
        try {
            ServiceContext serviceContext = new ServiceContext(HA_CTX_ID, this.marshallHAContext(newHACtx));
            jri.add_request_service_context(serviceContext, true);
        }
        catch (IOException e) {
            logger.error("Error while marshalling " + newHACtx, e);
        }
    }

    public void receive_reply(ClientRequestInfo jri) {
        this.getHAContext(jri);
    }

    public void receive_exception(ClientRequestInfo jri) throws ForwardRequest {
        this.getHAContext(jri);
    }

    public void receive_other(ClientRequestInfo jri) throws ForwardRequest {
        this.getHAContext(jri);
    }

    public void destroy() {
    }

    public void send_poll(ClientRequestInfo jri) {
    }

    private void getHAContext(ClientRequestInfo clientRequestInfo) {
        try {
            ServiceContext serviceContext = clientRequestInfo.get_request_service_context(HA_CTX_ID);
            HAContext receivedCtx = this.unmarshallHAContext(serviceContext.context_data);
            logger.debug("receivedCtx: " + receivedCtx, new Object[0]);
            HACurrent current = HACurrent.getHACurrent();
            Stack<RequestId> requests = receivedCtx.getRequests();
            current.setRequests(requests);
        }
        catch (BAD_PARAM e) {
        }
        catch (IOException e) {
            logger.error("Error while unmarshalling", e);
        }
        catch (ClassNotFoundException e) {
            logger.error("Error while unmarshalling", e);
        }
    }
}

