/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetail;
import org.ow2.easybeans.component.quartz.EasyBeansJobDetailData;
import org.ow2.easybeans.component.quartz.EasyBeansTimer;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class QuartzTimerService
implements TimerService {
    private Factory factory = null;
    private Scheduler scheduler = null;
    private String triggerGroupName = null;
    private long triggerId = 0L;
    private long jobDetailId = 0L;

    public QuartzTimerService(Factory factory, Scheduler scheduler) {
        this.factory = factory;
        this.scheduler = scheduler;
        this.triggerGroupName = factory.getId();
    }

    public Timer createTimer(long duration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        return this.createTimer(new Date(System.currentTimeMillis() + duration), info);
    }

    public Timer createTimer(long initialDuration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        Date initialExpiration = new Date(System.currentTimeMillis() + initialDuration);
        return this.createTimer(initialExpiration, intervalDuration, info);
    }

    public Timer createTimer(Date expiration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        SimpleTrigger trigger = new SimpleTrigger(this.getTriggerName(), this.getTriggerGroupName(), expiration);
        return this.internalTimer(trigger, info);
    }

    public Timer createTimer(Date initialExpiration, long intervalDuration, Serializable info) throws IllegalArgumentException, IllegalStateException, EJBException {
        SimpleTrigger trigger = new SimpleTrigger(this.getTriggerName(), this.getTriggerGroupName(), initialExpiration, null, SimpleTrigger.REPEAT_INDEFINITELY, intervalDuration);
        return this.internalTimer(trigger, info);
    }

    private Timer internalTimer(Trigger trigger, Serializable info) {
        EasyBeansJobDetailData beansJobDetailData = new EasyBeansJobDetailData();
        beansJobDetailData.setInfo(info);
        Integer easyBeansServerID = this.factory.getContainer().getConfiguration().getEZBServer().getID();
        beansJobDetailData.setEasyBeansServerID(easyBeansServerID);
        beansJobDetailData.setContainerId(this.factory.getContainer().getId());
        beansJobDetailData.setFactoryName(this.factory.getClassName());
        EasyBeansJobDetail jobDetail = new EasyBeansJobDetail(this.getNewJobDetailName(), this.getJobDetailGroupName(), beansJobDetailData);
        EasyBeansTimer timer = new EasyBeansTimer(jobDetail, trigger, this.scheduler);
        beansJobDetailData.setTimer(timer);
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            throw new EJBException("Cannot schedule the given job '" + jobDetail + "'.", e);
        }
        return timer;
    }

    public Collection getTimers() throws IllegalStateException, EJBException {
        ArrayList<EasyBeansTimer> timers = new ArrayList<EasyBeansTimer>();
        String[] jobNames = null;
        try {
            jobNames = this.scheduler.getJobNames(this.getJobDetailGroupName());
        }
        catch (SchedulerException e) {
            throw new EJBException("Unable to get the job names from the scheduler for the group named '" + this.getJobDetailGroupName() + "'.", e);
        }
        if (jobNames != null) {
            for (String jobName : jobNames) {
                JobDetail jobDetail = null;
                try {
                    jobDetail = this.scheduler.getJobDetail(jobName, this.getJobDetailGroupName());
                }
                catch (SchedulerException e) {
                    throw new EJBException("Cannot get the jobDetail for the jobName '" + jobName + "'.", e);
                }
                EasyBeansJobDetail easyBeansJobDetail = null;
                if (!(jobDetail instanceof EasyBeansJobDetail)) {
                    throw new EJBException("JobDetail found for the job named '" + jobName + "' is not an EasyBeansJobDetail object");
                }
                easyBeansJobDetail = (EasyBeansJobDetail)jobDetail;
                Trigger[] triggers = null;
                try {
                    triggers = this.scheduler.getTriggersOfJob(jobName, this.getJobDetailGroupName());
                }
                catch (SchedulerException e) {
                    throw new EJBException("Cannot get triggers for the job named '" + jobName + "'.", e);
                }
                if (triggers == null || triggers.length > 1) {
                    throw new EJBException("Invalid numbers of triggers found for the job named '" + jobName + "'.");
                }
                timers.add(new EasyBeansTimer(easyBeansJobDetail, triggers[0], this.scheduler));
            }
        }
        return timers;
    }

    private synchronized String getTriggerName() {
        return "triggerTimer" + this.triggerId++;
    }

    private synchronized String getNewJobDetailName() {
        return "jobDetail" + this.jobDetailId++;
    }

    private String getTriggerGroupName() {
        return this.triggerGroupName;
    }

    private String getJobDetailGroupName() {
        return "jobDetailGroup" + this.factory.getClassName();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }
}

