/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import java.util.ArrayList;
import java.util.List;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.security.interceptors.AccessInterceptor;
import org.ow2.easybeans.security.interceptors.DenyAllInterceptor;
import org.ow2.easybeans.security.interceptors.RunAsAccessInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.IJClassInterceptor;
import org.ow2.util.ee.metadata.ejbjar.impl.JClassInterceptor;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class SecurityResolver {
    private static final JMethod EASYBEANS_INTERCEPTOR = new JMethod(0, "intercept", "(Lorg/ow2/easybeans/api/EasyBeansInvocationContext;)Ljava/lang/Object;", null, new String[]{"java/lang/Exception"});
    private static final String DENYALL_INTERCEPTOR = Type.getInternalName(DenyAllInterceptor.class);
    private static final String RUNAS_INTERCEPTOR = Type.getInternalName(RunAsAccessInterceptor.class);
    private static final String ROLEBASED_INTERCEPTOR = Type.getInternalName(AccessInterceptor.class);

    private SecurityResolver() {
    }

    public static void resolve(EasyBeansEjbJarClassMetadata bean) {
        boolean beanPermitAll = bean.hasPermitAll();
        List<String> beanRolesAllowed = bean.getRolesAllowed();
        String runAs = bean.getRunAs();
        String superClassName = bean.getSuperName();
        while (runAs == null && !superClassName.equals(Type.getInternalName(Object.class))) {
            EasyBeansEjbJarClassMetadata superMetadata = (EasyBeansEjbJarClassMetadata)bean.getLinkedClassMetadata(superClassName);
            if (superMetadata == null) continue;
            runAs = superMetadata.getRunAs();
            superClassName = superMetadata.getSuperName();
            if (runAs == null) continue;
            bean.setRunAs(runAs);
        }
        List<String> declaredRoles = bean.getDeclareRoles();
        superClassName = bean.getSuperName();
        while (declaredRoles == null && !superClassName.equals(Type.getInternalName(Object.class))) {
            EasyBeansEjbJarClassMetadata superMetadata = (EasyBeansEjbJarClassMetadata)bean.getLinkedClassMetadata(superClassName);
            if (superMetadata == null) continue;
            declaredRoles = superMetadata.getDeclareRoles();
            superClassName = superMetadata.getSuperName();
            if (declaredRoles == null) continue;
            bean.setDeclareRoles(declaredRoles);
        }
        for (EasyBeansEjbJarMethodMetadata method : bean.getMethodMetadataCollection()) {
            List<String> rolesAllowed;
            ArrayList<? extends IJClassInterceptor> interceptors = new ArrayList<IJClassInterceptor>();
            List<? extends IJClassInterceptor> previousInterceptors = method.getInterceptors();
            if (previousInterceptors != null) {
                interceptors.addAll(previousInterceptors);
            }
            boolean denyAll = method.hasDenyAll();
            boolean permitAll = method.hasPermitAll();
            if (!permitAll) {
                if (method.isInherited()) {
                    permitAll = method.getOriginalClassMetadata().hasPermitAll();
                    method.setPermitAll(permitAll);
                } else {
                    permitAll = beanPermitAll;
                }
            }
            if ((rolesAllowed = method.getRolesAllowed()) == null) {
                if (method.isInherited()) {
                    rolesAllowed = method.getOriginalClassMetadata().getRolesAllowed();
                    method.setRolesAllowed(rolesAllowed);
                } else {
                    rolesAllowed = beanRolesAllowed;
                    method.setRolesAllowed(beanRolesAllowed);
                }
            }
            if (runAs != null) {
                interceptors.add(new JClassInterceptor(RUNAS_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
            }
            if (denyAll) {
                interceptors.add(new JClassInterceptor(DENYALL_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
            } else if (!permitAll && rolesAllowed != null) {
                interceptors.add(new JClassInterceptor(ROLEBASED_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
            }
            method.setInterceptors(interceptors);
        }
    }
}

