/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagementType;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.persistence.interceptors.NoTxMethodCallOnlyEntityManagerInterceptor;
import org.ow2.easybeans.transaction.interceptors.BMTStatefulTransactionInterceptor;
import org.ow2.easybeans.transaction.interceptors.BMTStatelessTransactionInterceptor;
import org.ow2.easybeans.transaction.interceptors.BMTTransactionInterceptor;
import org.ow2.easybeans.transaction.interceptors.CMTMandatoryTransactionInterceptor;
import org.ow2.easybeans.transaction.interceptors.CMTNeverTransactionInterceptor;
import org.ow2.easybeans.transaction.interceptors.CMTNotSupportedTransactionInterceptor;
import org.ow2.easybeans.transaction.interceptors.CMTRequiredTransactionInterceptor;
import org.ow2.easybeans.transaction.interceptors.CMTRequiresNewTransactionInterceptor;
import org.ow2.easybeans.transaction.interceptors.CMTSupportsTransactionInterceptor;
import org.ow2.easybeans.transaction.interceptors.ListenerSessionSynchronizationInterceptor;
import org.ow2.util.ee.metadata.ejbjar.api.IJClassInterceptor;
import org.ow2.util.ee.metadata.ejbjar.impl.JClassInterceptor;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class TransactionResolver {
    private static final JMethod EASYBEANS_INTERCEPTOR = new JMethod(0, "intercept", "(Lorg/ow2/easybeans/api/EasyBeansInvocationContext;)Ljava/lang/Object;", null, new String[]{"java/lang/Exception"});
    private static final String CMT_REQUIRED_INTERCEPTOR = Type.getInternalName(CMTRequiredTransactionInterceptor.class);
    private static final String CMT_MANDATORY_INTERCEPTOR = Type.getInternalName(CMTMandatoryTransactionInterceptor.class);
    private static final String CMT_NEVER_INTERCEPTOR = Type.getInternalName(CMTNeverTransactionInterceptor.class);
    private static final String CMT_NOT_SUPPORTED_INTERCEPTOR = Type.getInternalName(CMTNotSupportedTransactionInterceptor.class);
    private static final String CMT_SUPPORTS_INTERCEPTOR = Type.getInternalName(CMTSupportsTransactionInterceptor.class);
    private static final String CMT_REQUIRES_NEW_INTERCEPTOR = Type.getInternalName(CMTRequiresNewTransactionInterceptor.class);
    private static final String BMT_INTERCEPTOR = Type.getInternalName(BMTTransactionInterceptor.class);
    private static final String BMT_STATEFUL_INTERCEPTOR = Type.getInternalName(BMTStatefulTransactionInterceptor.class);
    private static final String BMT_STATELESS_INTERCEPTOR = Type.getInternalName(BMTStatelessTransactionInterceptor.class);
    private static final String LISTENER_SESSION_SYNCHRO_INTERCEPTOR = Type.getInternalName(ListenerSessionSynchronizationInterceptor.class);
    private static final String NOTX_TRANSACTION_SCOPED_INTERCEPTOR = Type.getInternalName(NoTxMethodCallOnlyEntityManagerInterceptor.class);
    private static final String SESSION_SYNCHRONIZATION_INTERFACE = "javax/ejb/SessionSynchronization";

    private TransactionResolver() {
    }

    public static void resolve(EasyBeansEjbJarClassMetadata bean) {
        String[] interfaces;
        TransactionAttributeType beanTxType = bean.getTransactionAttributeType();
        TransactionManagementType beanTxManaged = bean.getTransactionManagementType();
        boolean addSynchro = false;
        if (bean.isStateful() && (interfaces = bean.getInterfaces()) != null) {
            for (String itf : interfaces) {
                if (!SESSION_SYNCHRONIZATION_INTERFACE.equals(itf)) continue;
                addSynchro = true;
                break;
            }
        }
        for (EasyBeansEjbJarMethodMetadata method : bean.getMethodMetadataCollection()) {
            List<? extends IJClassInterceptor> previousInterceptors = method.getInterceptors();
            ArrayList<? extends IJClassInterceptor> interceptors = new ArrayList<IJClassInterceptor>();
            if (previousInterceptors != null) {
                interceptors.addAll(previousInterceptors);
            }
            if (beanTxManaged.equals((Object)TransactionManagementType.BEAN)) {
                if (bean.isStateful()) {
                    interceptors.add(new JClassInterceptor(BMT_STATEFUL_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                } else if (bean.isStateless()) {
                    interceptors.add(new JClassInterceptor(BMT_STATELESS_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                } else {
                    interceptors.add(new JClassInterceptor(BMT_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                }
                interceptors.add(new JClassInterceptor(NOTX_TRANSACTION_SCOPED_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
            } else {
                TransactionAttributeType methodTx = method.getTransactionAttributeType();
                if (methodTx == null) {
                    methodTx = !method.isInherited() ? beanTxType : method.getOriginalClassMetadata().getTransactionAttributeType();
                }
                switch (methodTx) {
                    case MANDATORY: {
                        interceptors.add(new JClassInterceptor(CMT_MANDATORY_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                        break;
                    }
                    case NEVER: {
                        interceptors.add(new JClassInterceptor(CMT_NEVER_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                        interceptors.add(new JClassInterceptor(NOTX_TRANSACTION_SCOPED_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                        break;
                    }
                    case NOT_SUPPORTED: {
                        interceptors.add(new JClassInterceptor(CMT_NOT_SUPPORTED_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                        interceptors.add(new JClassInterceptor(NOTX_TRANSACTION_SCOPED_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                        break;
                    }
                    case REQUIRED: {
                        interceptors.add(new JClassInterceptor(CMT_REQUIRED_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                        break;
                    }
                    case REQUIRES_NEW: {
                        interceptors.add(new JClassInterceptor(CMT_REQUIRES_NEW_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                        break;
                    }
                    case SUPPORTS: {
                        interceptors.add(new JClassInterceptor(CMT_SUPPORTS_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                        interceptors.add(new JClassInterceptor(NOTX_TRANSACTION_SCOPED_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid tx attribute on method '" + method.getMethodName() + "', value = '" + (Object)((Object)methodTx) + "'.");
                    }
                }
                if (addSynchro) {
                    interceptors.add(new JClassInterceptor(LISTENER_SESSION_SYNCHRO_INTERCEPTOR, EASYBEANS_INTERCEPTOR));
                }
            }
            method.setInterceptors(interceptors);
        }
    }
}

