/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.injection;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public final class JNDILookupHelper {
    private static final String JAVA_COMP = "java:comp/";
    private static final String JAVA_COMP_ENV = "java:comp/env/";
    private static Log logger = LogFactory.getLog(JNDILookupHelper.class);

    private JNDILookupHelper() {
    }

    public static Object getJndiName(String name) {
        InitialContext ictx;
        try {
            ictx = new InitialContext();
        }
        catch (NamingException e) {
            logger.error("Cannot instantiate an initial context", e);
            return null;
        }
        Object o = null;
        try {
            o = ictx.lookup(name);
        }
        catch (NamingException e) {
            logger.error("Cannot find the JNDI name {0}", name, e);
        }
        if (o == null) {
            logger.error("No object was found for JNDI name {0}", name);
        }
        if (o instanceof Reference) {
            Reference ref = (Reference)o;
            logger.warn("Reference not processed: " + ref, new Object[0]);
            logger.warn("LookupError({0}): The ObjectFactory({1}) was not found with TCCL {2}", name, ref.getFactoryClassName(), Thread.currentThread().getContextClassLoader());
        }
        return o;
    }

    public static Object getEnvJndiName(String name) {
        return JNDILookupHelper.getJndiName(JAVA_COMP_ENV + name);
    }

    public static Object getCompJndiName(String name) {
        return JNDILookupHelper.getJndiName(JAVA_COMP + name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JndiType {
        REGISTRY,
        JAVA_COMP,
        JAVA_COMP_ENV;

    }
}

