/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.injection.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.xml.namespace.QName;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.injection.api.ArchiveInjectionException;
import org.ow2.easybeans.resolver.api.EZBJNDIData;
import org.ow2.easybeans.resolver.api.EZBRemoteJNDIResolver;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.CARDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.metadata.DeployableMetadataException;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;
import org.ow2.util.ee.metadata.car.api.ICarDeployableMetadata;
import org.ow2.util.ee.metadata.car.impl.CarDeployableMetadataFactory;
import org.ow2.util.ee.metadata.common.api.ICommonClassMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonFieldMetadata;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.ee.metadata.common.api.interfaces.ISharedMetadata;
import org.ow2.util.ee.metadata.common.api.struct.IJAnnotationResource;
import org.ow2.util.ee.metadata.common.api.struct.IJEjbEJB;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.scan.api.metadata.structures.JClass;
import org.ow2.util.scan.api.metadata.structures.JField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveInjection {
    private static Log logger = LogFactory.getLog(ArchiveInjection.class);
    public static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private IArchive archive = null;
    private boolean analyzed = false;
    private EZBRemoteJNDIResolver jndiResolver = null;
    private Collection<? extends ICommonClassMetadata<? extends ICommonClassMetadata, ? extends ICommonMethodMetadata, ? extends ICommonFieldMetadata>> metadataCollection = null;

    public ArchiveInjection(IArchive archive) {
        this.archive = archive;
    }

    public void analyze() throws ArchiveInjectionException {
        ICarDeployableMetadata carDeployableMetadata;
        IDeployable<?> deployable = null;
        try {
            deployable = DeployableHelper.getDeployable(this.archive);
        }
        catch (DeployableHelperException e) {
            throw new ArchiveInjectionException("Unable to get a deployable on archive '" + this.archive + "'.", e);
        }
        if (CARDeployable.class.isInstance(deployable)) {
            carDeployableMetadata = null;
            try {
                carDeployableMetadata = new CarDeployableMetadataFactory().createDeployableMetadata((CARDeployable)CARDeployable.class.cast(deployable));
            }
            catch (DeployableMetadataException e) {
                throw new ArchiveInjectionException("Unable to get metadata on archive '" + this.archive + "'.", e);
            }
        } else {
            throw new UnsupportedOperationException("Can only manage injection for Client Deployable. Deployable found is '" + deployable + "'.");
        }
        this.metadataCollection = carDeployableMetadata.getCarClassMetadataCollection();
        this.analyzed = true;
    }

    public void init(Class<?> clazz) throws ArchiveInjectionException {
        if (!this.analyzed) {
            this.analyze();
        }
        LinkedList listClasses = new LinkedList();
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            listClasses.addFirst(currentClass);
        }
        for (Class clazz2 : listClasses) {
            ICommonClassMetadata<? extends ICommonClassMetadata, ? extends ICommonMethodMetadata, ? extends ICommonFieldMetadata> classMetadata = this.getClassMetadata(clazz2);
            if (classMetadata == null) continue;
            this.init(classMetadata, clazz2, null);
        }
    }

    public void init(ICommonClassMetadata commonMetadata, Class clazz, Object instance) throws ArchiveInjectionException {
        Collection fieldCollection = commonMetadata.getStandardFieldMetadataCollection();
        for (ICommonFieldMetadata fieldMetadata : fieldCollection) {
            IJaxwsWebServiceRef jaxwsWSR;
            IJAnnotationResource jAnnotationResource;
            Type typeInterface = Type.getType(fieldMetadata.getJField().getDescriptor());
            String interfaceName = typeInterface.getClassName();
            IJEjbEJB jejb = fieldMetadata.getJEjbEJB();
            if (jejb != null) {
                jejb.setBeanInterface(interfaceName);
                this.injectFieldEJB(jejb, fieldMetadata, clazz, instance);
            }
            if ((jAnnotationResource = fieldMetadata.getJAnnotationResource()) != null) {
                jAnnotationResource.setType(interfaceName);
                if ("javax.transaction.UserTransaction".equals(jAnnotationResource.getType())) {
                    jAnnotationResource.setMappedName("java:comp/UserTransaction");
                } else if ("org.omg.CORBA.ORB".equals(jAnnotationResource.getType())) {
                    jAnnotationResource.setMappedName("java:comp/ORB");
                }
                this.injectFieldResource(jAnnotationResource, fieldMetadata, clazz, instance);
            }
            if ((jaxwsWSR = fieldMetadata.getJaxwsWebServiceRef()) == null) continue;
            jaxwsWSR.setType(interfaceName);
            this.injectWebServiceRef(jaxwsWSR, fieldMetadata, clazz, instance);
        }
        List<IJaxwsWebServiceRef> webServiceRefs = commonMetadata.getJaxwsWebServiceRefs();
        if (webServiceRefs != null) {
            for (IJaxwsWebServiceRef ref : webServiceRefs) {
                this.injectWebServiceRef(ref, commonMetadata, clazz, instance);
            }
        }
        ArrayList<ICommonMethodMetadata> postConstructMethods = new ArrayList<ICommonMethodMetadata>();
        Collection methodCollection = commonMetadata.getStandardMethodMetadataCollection();
        for (ICommonMethodMetadata methodMetadata : methodCollection) {
            if (!methodMetadata.isPostConstruct()) continue;
            postConstructMethods.add(methodMetadata);
        }
        this.invokePostConstructMethods(postConstructMethods, clazz, instance);
    }

    private void injectWebServiceRef(IJaxwsWebServiceRef jaxwsWSR, ISharedMetadata fieldMetadata, Class clazz, Object instance) throws ArchiveInjectionException {
        if (ArchiveInjection.isNullOrEmpty(jaxwsWSR.getValue())) {
            jaxwsWSR.setValue(jaxwsWSR.getType());
        }
        ClassLoader loader = clazz.getClassLoader();
        Class<?> serviceClass = null;
        try {
            serviceClass = loader.loadClass(jaxwsWSR.getValue());
        }
        catch (ClassNotFoundException e) {
            throw new ArchiveInjectionException("Cannot load Service class '" + jaxwsWSR.getValue() + "'", e);
        }
        String wsdlLocation = jaxwsWSR.getWsdlLocation();
        boolean haveWSDL = true;
        URL location = null;
        if (wsdlLocation != null) {
            try {
                location = new URL(wsdlLocation);
            }
            catch (MalformedURLException mue) {
                ClassLoader serviceLoader = serviceClass.getClassLoader();
                location = serviceLoader.getResource(wsdlLocation);
                if (location == null) {
                    location = loader.getResource(wsdlLocation);
                }
                if (location == null) {
                    haveWSDL = false;
                }
            }
        } else {
            haveWSDL = false;
        }
        Object service = null;
        try {
            Constructor<?> constructor;
            if (haveWSDL) {
                constructor = serviceClass.getConstructor(URL.class, QName.class);
                service = constructor.newInstance(location, null);
            } else {
                constructor = serviceClass.getConstructor(new Class[0]);
                service = constructor.newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            throw new ArchiveInjectionException("Cannot access the constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new ArchiveInjectionException("Unknown constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new ArchiveInjectionException("Exception when invoking constructor", e);
        }
        catch (InstantiationException e) {
            throw new ArchiveInjectionException("Cannot create instance", e);
        }
        Object injectedValue = service;
        if (!jaxwsWSR.getType().equals(jaxwsWSR.getValue())) {
            ClassLoader serviceClassLoader = serviceClass.getClassLoader();
            Class<?> sei = null;
            try {
                sei = serviceClassLoader.loadClass(jaxwsWSR.getType());
            }
            catch (ClassNotFoundException e) {
                throw new ArchiveInjectionException("Cannot load SEI '" + jaxwsWSR.getType() + "'", e);
            }
            Method getPortMethod = null;
            try {
                getPortMethod = serviceClass.getMethod("getPort", Class.class);
                injectedValue = getPortMethod.invoke(instance, sei);
            }
            catch (NoSuchMethodException e) {
                throw new ArchiveInjectionException("getPort(Class<T>) was not found on '" + serviceClass + "'", e);
            }
            catch (IllegalAccessException e) {
                throw new ArchiveInjectionException("getPort(Class<T>) is not accessible on '" + serviceClass + "'", e);
            }
            catch (InvocationTargetException e) {
                throw new ArchiveInjectionException("Error during execution of '" + getPortMethod + "'", e);
            }
        }
        String encName = jaxwsWSR.getName();
        if (fieldMetadata instanceof ICommonFieldMetadata) {
            this.setFieldValue((ICommonFieldMetadata)fieldMetadata, clazz, instance, injectedValue);
            encName = this.buildENCName(jaxwsWSR.getName(), (ICommonFieldMetadata)fieldMetadata);
        }
        this.bindValue(encName, injectedValue);
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || "".equals(value);
    }

    protected void invokePostConstructMethods(List<ICommonMethodMetadata> postConstructMethods, Class clazz, Object instance) throws ArchiveInjectionException {
        if (postConstructMethods == null) {
            return;
        }
        for (ICommonMethodMetadata postConstructMethodMetadata : postConstructMethods) {
            Method postConstructMethod = null;
            try {
                postConstructMethod = clazz.getDeclaredMethod(postConstructMethodMetadata.getJMethod().getName(), new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ArchiveInjectionException("Cannot invoke postconstruct method", e);
            }
            boolean accessible = postConstructMethod.isAccessible();
            try {
                postConstructMethod.setAccessible(true);
                postConstructMethod.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ArchiveInjectionException("Cannot invoke postconstruct method", e);
            }
            catch (InvocationTargetException e) {
                throw new ArchiveInjectionException("Cannot invoke postconstruct method", e);
            }
            finally {
                postConstructMethod.setAccessible(accessible);
            }
        }
    }

    public void injectFieldEJB(IJEjbEJB ejb, ICommonFieldMetadata fieldMetadata, Class clazz, Object instance) throws ArchiveInjectionException {
        String interfaceName = ejb.getBeanInterface();
        String beanName = ejb.getBeanName();
        String mappedName = ejb.getMappedName();
        String encName = this.buildENCName(ejb.getName(), fieldMetadata);
        boolean needToBind = true;
        Object value = null;
        try {
            value = new InitialContext().lookup("java:comp/env/" + encName);
            needToBind = false;
        }
        catch (NamingException e) {
            logger.debug("Value for ENC '{0}' not bound in the registry", encName);
        }
        if (value == null) {
            String jndiName = null;
            jndiName = mappedName != null ? mappedName : this.getRemoteJNDIName(interfaceName, beanName);
            try {
                value = new InitialContext().lookup(jndiName);
            }
            catch (NamingException e) {
                throw new ArchiveInjectionException("Cannot get object with JNDI Name '" + jndiName + "' for ejb '" + ejb + "'.", e);
            }
        }
        this.setFieldValue(fieldMetadata, clazz, instance, value);
        if (needToBind) {
            this.bindValue(encName, value);
        }
    }

    public void injectFieldResource(IJAnnotationResource jAnnotationResource, ICommonFieldMetadata fieldMetadata, Class clazz, Object instance) throws ArchiveInjectionException {
        String mappedName = jAnnotationResource.getMappedName();
        Object value = null;
        String encName = this.buildENCName(jAnnotationResource.getName(), fieldMetadata);
        boolean needToBind = true;
        try {
            value = new InitialContext().lookup("java:comp/env/" + encName);
            needToBind = false;
        }
        catch (NamingException e) {
            logger.debug("Value for ENC '{0}' not bound in the registry", encName);
        }
        if (value == null) {
            if (mappedName == null) {
                logger.warn("Injection of @Resource for {0} is not supported", jAnnotationResource);
                return;
            }
            try {
                value = new InitialContext().lookup(mappedName);
            }
            catch (NamingException e) {
                throw new ArchiveInjectionException("Cannot get object with JNDI Name '" + mappedName + "' for Resource '" + jAnnotationResource + "'.", e);
            }
        }
        this.setFieldValue(fieldMetadata, clazz, instance, value);
        if (needToBind) {
            this.bindValue(encName, value);
        }
    }

    protected void bindValue(String encName, Object value) {
        try {
            new InitialContext().bind("java:comp/env/" + encName, value);
        }
        catch (NamingException e) {
            logger.warn("Unable to bind the value for ENC '{0}'.", encName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFieldValue(ICommonFieldMetadata fieldMetadata, Class clazz, Object instance, Object value) throws ArchiveInjectionException {
        JField jField = fieldMetadata.getJField();
        Field field = null;
        try {
            field = clazz.getDeclaredField(jField.getName());
        }
        catch (NoSuchFieldException e) {
            throw new ArchiveInjectionException("Cannot get field '" + jField + "' on the class '" + clazz.getName() + "'", e);
        }
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new ArchiveInjectionException("Cannot set given value on the field '" + jField + "'.", e);
            }
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    protected String buildENCName(String name, ICommonFieldMetadata fieldMetadata) {
        String encName = name;
        if (encName == null || "".equals(encName)) {
            encName = fieldMetadata.getClassMetadata().getJClass().getName().replace("/", ".") + "/" + fieldMetadata.getJField().getName();
        }
        return encName;
    }

    protected String getRemoteJNDIName(String interfaceName, String beanName) throws ArchiveInjectionException {
        String jndiName = null;
        if (this.jndiResolver == null) {
            Object o = null;
            try {
                o = new InitialContext().lookup("EZB_Remote_JNDIResolver");
            }
            catch (NamingException e) {
                throw new ArchiveInjectionException("No Remote EJB3 JNDI Resolver found", e);
            }
            this.jndiResolver = (EZBRemoteJNDIResolver)PortableRemoteObject.narrow((Object)o, EZBRemoteJNDIResolver.class);
        }
        List<EZBJNDIData> jndiDataList = null;
        try {
            jndiDataList = this.jndiResolver.getNames(interfaceName, beanName);
        }
        catch (RemoteException re) {
            throw new ArchiveInjectionException("Unable to get JNDI Name for '" + interfaceName + "'/'" + beanName + "'", re);
        }
        if (jndiDataList.size() == 0) {
            throw new ArchiveInjectionException("Unable to get JNDI Name for '" + interfaceName + "'/'" + beanName + "', no data was found on the remote side.");
        }
        if (jndiDataList.size() > 1) {
            throw new ArchiveInjectionException("Unable to get JNDI Name for '" + interfaceName + "'/'" + beanName + "', too many answers : '" + jndiDataList + "'.");
        }
        EZBJNDIData jndiData = jndiDataList.get(0);
        jndiName = jndiData.getName();
        if (logger.isDebugEnabled()) {
            logger.debug("Found JNDI Name '" + jndiName + "' for '" + interfaceName + "'/'" + beanName + "', too many answers : '" + jndiDataList + "'.", new Object[0]);
        }
        return jndiName;
    }

    protected ICommonClassMetadata<? extends ICommonClassMetadata, ? extends ICommonMethodMetadata, ? extends ICommonFieldMetadata> getClassMetadata(Class clazz) {
        return this.getClassMetadata(clazz.getName());
    }

    protected ICommonClassMetadata<? extends ICommonClassMetadata, ? extends ICommonMethodMetadata, ? extends ICommonFieldMetadata> getClassMetadata(String requestedClassName) {
        for (ICommonClassMetadata<? extends ICommonClassMetadata, ? extends ICommonMethodMetadata, ? extends ICommonFieldMetadata> iCommonClassMetadata : this.metadataCollection) {
            String className;
            JClass jClass = iCommonClassMetadata.getJClass();
            if (jClass == null || !requestedClassName.equals((className = jClass.getName()).replace('/', '.'))) continue;
            return iCommonClassMetadata;
        }
        return null;
    }
}

