/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.persistence;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.ow2.easybeans.persistence.TxEntityManagerLifeCycle;
import org.ow2.easybeans.transaction.JTransactionManager;

public class TxEntityManagerHandler {
    private EntityManagerFactory entityManagerFactory = null;
    private Map<Transaction, EntityManager> entityManagers = null;
    private ThreadLocal<Stack<EntityManager>> threadEntityManager = new ThreadLocal();

    public TxEntityManagerHandler(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.entityManagers = new HashMap<Transaction, EntityManager>();
    }

    public synchronized EntityManager getCurrent() {
        EntityManager current = null;
        Transaction currentTx = null;
        try {
            currentTx = JTransactionManager.getTransactionManager().getTransaction();
        }
        catch (SystemException e) {
            throw new IllegalStateException("Cannot get current transaction", e);
        }
        int statusTx = 5;
        if (currentTx != null) {
            try {
                statusTx = currentTx.getStatus();
            }
            catch (SystemException e) {
                throw new IllegalStateException("Cannot get the status on the current transaction", e);
            }
        }
        if (currentTx == null || statusTx != 0 && statusTx != 1) {
            Stack<EntityManager> stack = this.threadEntityManager.get();
            if (stack == null) {
                throw new IllegalStateException("No EntityManager stack associated on the current thread without TX.NoTxInterceptor may not have been called");
            }
            return stack.peek();
        }
        current = this.entityManagers.get(currentTx);
        if (current == null) {
            current = this.buildNewTxEntityManager(currentTx);
        }
        return current;
    }

    private EntityManager buildNewTxEntityManager(Transaction tx) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        try {
            tx.registerSynchronization(new TxEntityManagerLifeCycle(entityManager, tx, this));
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("Cannot register Entity manager lifecycle", e);
        }
        catch (RollbackException e) {
            throw new IllegalStateException("Cannot register Entity manager lifecycle", e);
        }
        catch (SystemException e) {
            throw new IllegalStateException("Cannot register Entity manager lifecycle", e);
        }
        this.entityManagers.put(tx, entityManager);
        return entityManager;
    }

    private EntityManager buildNoTxEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    public void release(Transaction tx) {
        this.entityManagers.remove(tx);
    }

    public void addCurrent() {
        Stack<EntityManager> stackEntityManager = this.threadEntityManager.get();
        if (stackEntityManager == null) {
            stackEntityManager = new Stack();
            this.threadEntityManager.set(stackEntityManager);
        }
        stackEntityManager.push(this.buildNoTxEntityManager());
    }

    public void closeCurrentAndReturnToPrevious() {
        Stack<EntityManager> stack = this.threadEntityManager.get();
        EntityManager current = stack.peek();
        stack.pop();
        if (stack.empty()) {
            this.threadEntityManager.set(null);
        }
        if (current != null) {
            current.close();
        }
    }
}

