/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.proxy.binding;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ow2.easybeans.api.binding.BindingException;
import org.ow2.easybeans.api.binding.EZBBindingFactory;
import org.ow2.easybeans.api.binding.EZBRef;

public class JNDIBindingFactory
implements EZBBindingFactory {
    public void bind(EZBRef ref) throws BindingException {
        try {
            new InitialContext().rebind(ref.getJNDIName(), (Object)ref);
        }
        catch (NamingException e) {
            throw new BindingException("Cannot bind the object with JNDI name '" + ref.getJNDIName() + "' and reference '" + ref + "'.", e);
        }
    }

    public void unbind(EZBRef ref) throws BindingException {
        Object toUnbind;
        try {
            toUnbind = new InitialContext().lookupLink(ref.getJNDIName());
        }
        catch (NamingException e) {
            toUnbind = null;
        }
        if (toUnbind != null) {
            try {
                new InitialContext().unbind(ref.getJNDIName());
            }
            catch (NamingException e) {
                throw new BindingException("Cannot unbind the object with JNDI name '" + ref.getJNDIName() + "'.", e);
            }
        }
    }
}

