/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.resolver;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.resolver.CommonJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBApplicationJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationJNDIResolver
extends CommonJNDIResolver
implements EZBApplicationJNDIResolver {
    private Map<URL, EZBContainerJNDIResolver> containersMap = new HashMap<URL, EZBContainerJNDIResolver>();

    @Override
    public void addContainerJNDIResolver(EZBContainerJNDIResolver containerJNDIResolver) {
        this.containersMap.put(containerJNDIResolver.getURL(), containerJNDIResolver);
    }

    @Override
    public List<EZBJNDIData> getNames(String interfaceName) {
        return this.getNames(interfaceName, null);
    }

    @Override
    public List<EZBJNDIData> getNames(String interfaceName, String beanName) {
        return this.getNames(interfaceName, beanName, null);
    }

    @Override
    public List<EZBJNDIData> getNames(String interfaceName, String beanName, URL ejbLinkURL) {
        if (ejbLinkURL != null) {
            EZBContainerJNDIResolver containerJNDIResolver = this.containersMap.get(ejbLinkURL);
            if (containerJNDIResolver != null) {
                return containerJNDIResolver.getNames(interfaceName, beanName, false);
            }
            return Collections.emptyList();
        }
        Collection<EZBContainerJNDIResolver> containerJNDIResolvers = this.containersMap.values();
        if (containerJNDIResolvers == null) {
            return Collections.emptyList();
        }
        ArrayList<EZBJNDIData> beanDataList = new ArrayList<EZBJNDIData>();
        for (EZBContainerJNDIResolver containerJNDIResolver : containerJNDIResolvers) {
            beanDataList.addAll(containerJNDIResolver.getNames(interfaceName, beanName, false));
        }
        return beanDataList;
    }
}

