/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.resolver;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.resolver.CommonJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBApplicationJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIData;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerJNDIResolver
extends CommonJNDIResolver
implements EZBContainerJNDIResolver {
    private static Log logger = LogFactory.getLog(ContainerJNDIResolver.class);
    private URL containerURL = null;
    private EZBApplicationJNDIResolver applicationJNDIResolver = null;
    private Map<String, Map<String, EZBJNDIData>> interfacesMap;

    public ContainerJNDIResolver(IArchive archive) {
        try {
            this.containerURL = archive.getURL();
        }
        catch (ArchiveException e) {
            throw new IllegalArgumentException("Cannot get URL from archive '" + archive + "'.");
        }
        this.interfacesMap = new HashMap<String, Map<String, EZBJNDIData>>();
    }

    @Override
    public URL getURL() {
        return this.containerURL;
    }

    @Override
    public List<EZBJNDIData> getNames(String interfaceName) {
        return this.getNames(interfaceName, null);
    }

    @Override
    public EZBApplicationJNDIResolver getApplicationJNDIResolver() {
        return this.applicationJNDIResolver;
    }

    @Override
    public void setApplicationJNDIResolver(EZBApplicationJNDIResolver applicationJNDIResolver) {
        this.applicationJNDIResolver = applicationJNDIResolver;
    }

    @Override
    public List<EZBJNDIData> getNames(String interfaceName, String beanName) {
        return this.getNames(interfaceName, beanName, true);
    }

    @Override
    public List<EZBJNDIData> getNames(String interfaceName, String beanName, boolean askParent) {
        Map<String, EZBJNDIData> beansMap = this.interfacesMap.get(interfaceName);
        if (beansMap == null) {
            return this.getJNDINameInEAR(interfaceName, beanName, askParent);
        }
        if (beanName == null || "".equals(beanName)) {
            Collection<EZBJNDIData> beanValues = beansMap.values();
            if (beanValues == null || beanValues.isEmpty()) {
                return this.getJNDINameInEAR(interfaceName, beanName, askParent);
            }
            return new ArrayList<EZBJNDIData>(beanValues);
        }
        String newBeanname = beanName;
        if (beanName.indexOf("#") > 0) {
            newBeanname = beanName.split("#")[1];
            logger.debug("EJB-LINK not fully supported for interface '" + interfaceName + "', and bean name '" + beanName + "' in container '" + this.containerURL + "'.", new Object[0]);
        }
        ArrayList<EZBJNDIData> beanDataList = new ArrayList<EZBJNDIData>();
        EZBJNDIData beanData = beansMap.get(newBeanname);
        if (beanData == null) {
            return this.getJNDINameInEAR(interfaceName, newBeanname, askParent);
        }
        beanDataList.add(beanData);
        return beanDataList;
    }

    protected List<EZBJNDIData> getJNDINameInEAR(String interfaceName, String beanName, boolean enabled) {
        if (!enabled || this.applicationJNDIResolver == null) {
            return Collections.emptyList();
        }
        return this.applicationJNDIResolver.getNames(interfaceName, beanName);
    }

    @Override
    public void addJNDIName(String interfaceName, EZBJNDIData jndiData) {
        String beanName;
        EZBJNDIData existingData;
        Map<String, EZBJNDIData> beansMap = this.interfacesMap.get(interfaceName);
        if (beansMap == null) {
            beansMap = new HashMap<String, EZBJNDIData>();
            this.interfacesMap.put(interfaceName, beansMap);
        }
        if ((existingData = beansMap.get(beanName = jndiData.getBeanName())) != null) {
            logger.warn("Data already set for '" + jndiData + "' for the container URL '" + this.containerURL + "'.", new Object[0]);
        }
        beansMap.put(beanName, jndiData);
    }
}

