/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.resolver;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.ow2.easybeans.resolver.CommonJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBContainerJNDIResolver;
import org.ow2.easybeans.resolver.api.EZBJNDIData;
import org.ow2.easybeans.resolver.api.EZBServerJNDIResolver;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerJNDIResolver
extends CommonJNDIResolver
implements EZBServerJNDIResolver {
    private Log logger = LogFactory.getLog(ServerJNDIResolver.class);
    private static Map<URL, WeakReference<EZBContainerJNDIResolver>> containerResolvers = new WeakHashMap<URL, WeakReference<EZBContainerJNDIResolver>>();

    @Override
    public synchronized void removeContainerResolver(EZBContainerJNDIResolver resolver2) {
        URL containerURL = resolver2.getURL();
        WeakReference<EZBContainerJNDIResolver> weakRef = containerResolvers.get(containerURL);
        if (weakRef != null) {
            containerResolvers.remove(containerURL);
        } else {
            this.logger.warn("Cannot remove the given container resolver as it is not present.", new Object[0]);
        }
    }

    @Override
    public synchronized void addContainerResolver(EZBContainerJNDIResolver resolver2) {
        WeakReference<EZBContainerJNDIResolver> weakRef = new WeakReference<EZBContainerJNDIResolver>(resolver2);
        containerResolvers.put(resolver2.getURL(), weakRef);
    }

    @Override
    public synchronized List<EZBJNDIData> getNames(String interfaceName) {
        return this.getNames(interfaceName, null);
    }

    @Override
    public synchronized List<EZBJNDIData> getNames(String interfaceName, String beanName) {
        Iterator<URL> itContainerURL = containerResolvers.keySet().iterator();
        ArrayList<EZBJNDIData> foundJNDINames = new ArrayList<EZBJNDIData>();
        while (itContainerURL.hasNext()) {
            URL url = itContainerURL.next();
            WeakReference<EZBContainerJNDIResolver> weakRef = containerResolvers.get(url);
            if (weakRef == null) continue;
            EZBContainerJNDIResolver containerResolver = (EZBContainerJNDIResolver)weakRef.get();
            List<EZBJNDIData> containerJNDINames = containerResolver.getNames(interfaceName, beanName, false);
            foundJNDINames.addAll(containerJNDINames);
        }
        return foundJNDINames;
    }
}

