/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.server;

import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ow2.easybeans.server.Embedded;
import org.ow2.easybeans.server.EmbeddedException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xmlconfig.XMLConfiguration;
import org.ow2.util.xmlconfig.XMLConfigurationException;
import org.ow2.util.xmlconfig.properties.SystemPropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddedConfigurator {
    private static final String CONFIGURATION_FILE_NAME = "easybeans.xml";
    private static Log logger = LogFactory.getLog(EmbeddedConfigurator.class);

    private EmbeddedConfigurator() {
    }

    public static Embedded init(Embedded embedded, URL xmlConfigurationURL) throws EmbeddedException {
        EmbeddedConfigurator.configure(embedded, xmlConfigurationURL);
        return embedded;
    }

    public static Embedded init(Embedded embedded, List<URL> xmlConfigurationURLs, Map<String, Object> contextualInstances) throws EmbeddedException {
        EmbeddedConfigurator.configure(embedded, xmlConfigurationURLs, contextualInstances);
        return embedded;
    }

    public static Embedded create(URL xmlConfigurationURL) throws EmbeddedException {
        return EmbeddedConfigurator.init(new Embedded(), xmlConfigurationURL);
    }

    public static Embedded create() throws EmbeddedException {
        URL xmlConfigurationURL = Thread.currentThread().getContextClassLoader().getResource(CONFIGURATION_FILE_NAME);
        if (xmlConfigurationURL == null) {
            throw new EmbeddedException("No configuration file with name 'easybeans.xml' was found in classpath.");
        }
        return EmbeddedConfigurator.create(xmlConfigurationURL);
    }

    private static void configure(Embedded embedded, URL xmlConfigurationURL) throws EmbeddedException {
        EmbeddedConfigurator.configure(embedded, Collections.singletonList(xmlConfigurationURL), null);
    }

    private static void configure(Embedded embedded, List<URL> xmlConfigurationURLs, Map<String, Object> contextualInstances) throws EmbeddedException {
        long tStart = System.currentTimeMillis();
        logger.debug("Starting configuration of EasyBeans server", new Object[0]);
        XMLConfiguration xmlConfiguration = new XMLConfiguration("easybeans-mapping.xml");
        if (xmlConfigurationURLs != null) {
            for (URL configuration : xmlConfigurationURLs) {
                xmlConfiguration.addConfigurationFile(configuration);
            }
        }
        xmlConfiguration.setPropertyResolver(new SystemPropertyResolver());
        if (contextualInstances != null) {
            xmlConfiguration.setContextualInstances(contextualInstances);
        }
        try {
            xmlConfiguration.configure(embedded);
        }
        catch (XMLConfigurationException e) {
            throw new EmbeddedException("Cannot configure the embedded server", e);
        }
        logger.debug("Configuration done in : {0} ms", System.currentTimeMillis() - tStart);
    }
}

