/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Iterator;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.SessionSynchronization;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.MethodDesc;
import org.ow2.jonas.deployment.ejb.SessionDesc;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.CommonEjb;
import org.ow2.jonas.deployment.ejb.xml.JonasSession;
import org.ow2.jonas.deployment.ejb.xml.Session;
import org.ow2.jonas.lib.util.BeanNaming;

public class SessionStatelessDesc
extends SessionDesc {
    private static final String SERVICE_ENDPOINT_JNDI_SUFFIX = "_SE";
    private String wrpServiceEndpointName;
    private String wrpSEHomeName;
    protected boolean singleton = true;
    private String fullWrpServiceEndpointName;
    private String fullWrpSEHomeName;
    private Class serviceEndpointClass;
    private String serviceEndpointJndiName;

    public SessionStatelessDesc(ClassLoader classLoader, Session ses, AssemblyDescriptor asd, JonasSession jSes, JLinkedList jMDRList, String filename) throws DeploymentDescException {
        super(classLoader, ses, asd, jSes, jMDRList, filename);
        String ejbIdentifier = this.getIdentifier();
        if (this.getServiceEndpointClass() != null) {
            String packageName = "org.ow2.jonas_gen." + BeanNaming.getPackageName(this.getServiceEndpointClass().getName());
            this.wrpServiceEndpointName = new String("JOnAS" + ejbIdentifier + "ServiceEndpoint");
            this.fullWrpServiceEndpointName = BeanNaming.getClassName(packageName, this.wrpServiceEndpointName);
            this.wrpSEHomeName = new String("JOnAS" + ejbIdentifier + "SEHome");
            this.fullWrpSEHomeName = BeanNaming.getClassName(packageName, this.wrpSEHomeName);
        }
        this.serviceEndpointJndiName = jSes.getJndiEndpointName() != null ? jSes.getJndiEndpointName() : this.getJndiName() + SERVICE_ENDPOINT_JNDI_SUFFIX;
        if (jSes.getSingleton() != null) {
            if (jSes.getSingleton().equalsIgnoreCase("True")) {
                this.singleton = true;
            } else if (jSes.getSingleton().equalsIgnoreCase("False")) {
                this.singleton = false;
            } else {
                throw new DeploymentDescException("Invalid singleton value for bean " + this.ejbName);
            }
        }
        Iterator i = this.getMethodDescIterator();
        while (i.hasNext()) {
            MethodDesc methd = (MethodDesc)i.next();
            if (!methd.getMethod().getName().equals("ejbTimeout")) continue;
            this.timerTxAttribute = methd.getTxAttribute();
            this.ejbTimeoutSignature = BeanNaming.getSignature(this.getEjbName(), methd.getMethod());
        }
    }

    public void check() throws DeploymentDescException {
        super.check();
        if (SessionSynchronization.class.isAssignableFrom(this.ejbClass)) {
            throw new DeploymentDescException(this.ejbClass.getName() + " should NOT implement javax.ejb.SessionSynchronization");
        }
    }

    protected int addEJBMethodDesc(int len) throws DeploymentDescException {
        if (this.serviceEndpointClass != null) {
            Method[] m = this.serviceEndpointClass.getMethods();
            for (int i = 0; i < m.length; ++i) {
                this.addMethodDesc(m[i], this.serviceEndpointClass);
                ++len;
                this.checkRemoteException(m[i], true);
            }
        }
        return len;
    }

    protected void loadExtraClasses(CommonEjb bd, ClassLoader classLoader) throws DeploymentDescException {
        Session ses = (Session)bd;
        if (ses.getServiceEndpoint() != null) {
            try {
                this.serviceEndpointClass = classLoader.loadClass(ses.getServiceEndpoint());
                if (!Remote.class.isAssignableFrom(this.serviceEndpointClass)) {
                    throw new DeploymentDescException("ServiceEndpoint class '" + ses.getServiceEndpoint() + "' does not extend java.rmi.Remote");
                }
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentDescException("ServiceEndpoint class not found for bean " + this.ejbName, e);
            }
        }
    }

    protected Class getParentClass(String intfType) throws DeploymentDescException {
        Class pClass = null;
        if (intfType.equals("Home")) {
            pClass = EJBHome.class;
        } else if (intfType.equals("Remote")) {
            pClass = EJBObject.class;
        } else if (intfType.equals("LocalHome")) {
            pClass = EJBLocalHome.class;
        } else if (intfType.equals("Local")) {
            pClass = EJBLocalObject.class;
        } else if (intfType.equals("ServiceEndpoint")) {
            pClass = Remote.class;
        } else {
            throw new DeploymentDescException(intfType + " is invalid value for method-intf on bean " + this.ejbName);
        }
        return pClass;
    }

    public Class getServiceEndpointClass() {
        return this.serviceEndpointClass;
    }

    private void checkValidServiceEndpointInterface() {
    }

    public String getJndiServiceEndpointName() {
        return this.serviceEndpointJndiName;
    }

    public String getFullWrpServiceEndpointName() {
        return this.fullWrpServiceEndpointName;
    }

    public String getWrpServiceEndpointName() {
        return this.wrpServiceEndpointName;
    }

    public String getFullWrpSEHomeName() {
        return this.fullWrpSEHomeName;
    }

    public String getWrpSEHomeName() {
        return this.wrpSEHomeName;
    }

    public boolean isSingleton() {
        return this.singleton;
    }
}

