/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ee.mejb;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.j2ee.ListenerRegistration;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.ee.mejb.ListenerRegistrationImpl;
import org.ow2.jonas.ee.mejb.ManagementEndpoint;
import org.ow2.jonas.ee.mejb.ManagementEndpointException;
import org.ow2.jonas.lib.management.domain.DomainMonitor;
import org.ow2.jonas.lib.util.Log;

public class ManagementBean
implements SessionBean,
ManagementEndpoint {
    private static Logger logger = Log.getLogger("org.ow2.jonas.ee.mejb");
    private SessionContext sessionContext = null;
    private MBeanServerConnection jmxServerConnection = null;
    private String serverName = null;
    private String domainName = null;

    public void ejbCreate() throws CreateException {
        try {
            ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
            if (mbeanServers.size() > 0) {
                this.jmxServerConnection = (MBeanServerConnection)mbeanServers.get(0);
                ObjectName name = ObjectName.getInstance("*:j2eeType=J2EEServer,*");
                Set<ObjectName> nameSet = this.jmxServerConnection.queryNames(name, null);
                if (nameSet.isEmpty()) {
                    throw new CreateException("Problem when creating Management bean: the MBeanServer has no J2EEServer MBean registered.");
                }
                if (nameSet.size() > 1) {
                    logger.log(BasicLevel.WARN, (Object)"Problem when creating Management bean: the MBeanServer has more then one J2EEServer MBean registered.");
                }
                ObjectName on = nameSet.iterator().next();
                this.serverName = on.getKeyProperty("name");
                this.domainName = on.getDomain();
                System.out.println("MEJB created, serverName = " + this.serverName + ", domainName = " + this.domainName);
            }
        }
        catch (Exception e) {
            throw new CreateException("Could not create Management bean: " + e.getMessage());
        }
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, RemoteException {
        try {
            return this.jmxServerConnection.getAttribute(name, attribute);
        }
        catch (IOException ioe) {
            throw new RemoteException("Object getAttribute(ObjectName, String) failed", ioe);
        }
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        try {
            return this.jmxServerConnection.getAttributes(name, attributes);
        }
        catch (IOException ioe) {
            throw new RemoteException("AttributeList getAttributes(ObjectName, String[]) failed", ioe);
        }
    }

    public String getDefaultDomain() throws RemoteException {
        try {
            return this.jmxServerConnection.getDefaultDomain();
        }
        catch (IOException ioe) {
            throw new RemoteException("String getDefaultDomain() failed", ioe);
        }
    }

    public Integer getMBeanCount() throws RemoteException {
        try {
            return this.jmxServerConnection.getMBeanCount();
        }
        catch (IOException ioe) {
            throw new RemoteException("Integer getMBeanCount() failed", ioe);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws IntrospectionException, InstanceNotFoundException, ReflectionException, RemoteException {
        try {
            return this.jmxServerConnection.getMBeanInfo(name);
        }
        catch (IOException ioe) {
            throw new RemoteException("MBeanInfo getMBeanInfo(ObjectName) failed", ioe);
        }
    }

    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws MBeanException, InstanceNotFoundException, ReflectionException, RemoteException {
        try {
            return this.jmxServerConnection.invoke(name, operationName, params, signature);
        }
        catch (IOException ioe) {
            throw new RemoteException("Object invoke(ObjectName, String, Object[], String[]) failed", ioe);
        }
    }

    public boolean isRegistered(ObjectName name) throws RemoteException {
        try {
            return this.jmxServerConnection.isRegistered(name);
        }
        catch (IOException ioe) {
            throw new RemoteException("boolean isRegistered(ObjectName) failed", ioe);
        }
    }

    public Set queryNames(ObjectName name, QueryExp query) throws RemoteException {
        try {
            return this.jmxServerConnection.queryNames(name, query);
        }
        catch (IOException ioe) {
            throw new RemoteException("Set queryNames(ObjectName, QueryExp)  failed", ioe);
        }
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, ReflectionException, RemoteException {
        try {
            this.jmxServerConnection.setAttribute(name, attribute);
        }
        catch (IOException ioe) {
            throw new RemoteException("void setAttribute(ObjectName, Attribute) failed", ioe);
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        try {
            return this.jmxServerConnection.setAttributes(name, attributes);
        }
        catch (IOException ioe) {
            throw new RemoteException("AttributeList setAttributes(ObjectName, AttributeList) failed", ioe);
        }
    }

    public ListenerRegistration getListenerRegistry() throws RemoteException {
        return new ListenerRegistrationImpl(this.jmxServerConnection);
    }

    private MBeanServerConnection getServerConnection(String domainServerName) {
        if (domainServerName == null || domainServerName.equals(this.serverName)) {
            return this.jmxServerConnection;
        }
        return DomainMonitor.getInstance().getConnection(domainServerName);
    }

    public Object getAttribute(String domainServerName, ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, RemoteException {
        MBeanServerConnection connection = this.getServerConnection(domainServerName);
        if (connection == null) {
            throw new RemoteException("Could not connect to server " + domainServerName);
        }
        try {
            return connection.getAttribute(name, attribute);
        }
        catch (IOException ioe) {
            throw new RemoteException("Object getAttribute(String, ObjectName, String) failed", ioe);
        }
    }

    public AttributeList getAttributes(String domainServerName, ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        MBeanServerConnection connection = this.getServerConnection(domainServerName);
        if (connection == null) {
            throw new RemoteException("Could not connect to server " + domainServerName);
        }
        try {
            return connection.getAttributes(name, attributes);
        }
        catch (IOException ioe) {
            throw new RemoteException("AttributeList getAttributes(String, ObjectName, String[]) failed", ioe);
        }
    }

    public Integer getMBeanCount(String domainServerName) throws RemoteException {
        MBeanServerConnection connection = this.getServerConnection(domainServerName);
        if (connection == null) {
            throw new RemoteException("Could not connect to server " + domainServerName);
        }
        try {
            return connection.getMBeanCount();
        }
        catch (IOException ioe) {
            throw new RemoteException("Integer getMBeanCount(String) failed", ioe);
        }
    }

    public MBeanInfo getMBeanInfo(String domainServerName, ObjectName name) throws IntrospectionException, InstanceNotFoundException, ReflectionException, RemoteException {
        MBeanServerConnection connection = this.getServerConnection(domainServerName);
        if (connection == null) {
            throw new RemoteException("Could not connect to server " + domainServerName);
        }
        try {
            return connection.getMBeanInfo(name);
        }
        catch (IOException ioe) {
            throw new RemoteException("MBeanInfo getMbeanInfo(String, ObjectName) failed", ioe);
        }
    }

    public Object invoke(String domainServerName, ObjectName name, String operationName, Object[] params, String[] signature) throws MBeanException, InstanceNotFoundException, ReflectionException, RemoteException {
        MBeanServerConnection connection = this.getServerConnection(domainServerName);
        if (connection == null) {
            throw new RemoteException("Could not connect to server " + domainServerName);
        }
        try {
            return connection.invoke(name, operationName, params, signature);
        }
        catch (IOException ioe) {
            throw new RemoteException("Object invoke(String, ObjectName, String, Object[], String[]) failed", ioe);
        }
    }

    public boolean isRegistered(String domainServerName, ObjectName name) throws RemoteException {
        MBeanServerConnection connection = this.getServerConnection(domainServerName);
        if (connection == null) {
            throw new RemoteException("Could not connect to server " + domainServerName);
        }
        try {
            return connection.isRegistered(name);
        }
        catch (IOException ioe) {
            throw new RemoteException("boolean isRegistered(String, ObjectName) failed", ioe);
        }
    }

    public Set queryNames(String domainServerName, ObjectName name, QueryExp query) throws RemoteException {
        MBeanServerConnection connection = this.getServerConnection(domainServerName);
        if (connection == null) {
            throw new RemoteException("Could not connect to server " + domainServerName);
        }
        try {
            return connection.queryNames(name, query);
        }
        catch (IOException ioe) {
            throw new RemoteException("Set queryNames(String, ObjectName, QueryExp) failed", ioe);
        }
    }

    public void setAttribute(String domainServerName, ObjectName name, Attribute attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, InvalidAttributeValueException, ReflectionException, RemoteException {
        MBeanServerConnection connection = this.getServerConnection(domainServerName);
        if (connection == null) {
            throw new RemoteException("Could not connect to server " + domainServerName);
        }
        try {
            connection.setAttribute(name, attribute);
        }
        catch (IOException ioe) {
            throw new RemoteException("void setAttribute(String, ObjectName, Attribute) failed", ioe);
        }
    }

    public AttributeList setAttributes(String domainServerName, ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, RemoteException {
        MBeanServerConnection connection = this.getServerConnection(domainServerName);
        if (connection == null) {
            throw new RemoteException("Could not connect to server " + domainServerName);
        }
        try {
            return connection.setAttributes(name, attributes);
        }
        catch (IOException ioe) {
            throw new RemoteException("AttributeList setAttributes(String, ObjectName, AttributeList) failed", ioe);
        }
    }

    public String[] getServers() throws ManagementEndpointException, RemoteException {
        String j2eeDomainName = this.domainName + ":j2eeType=J2EEDomain,name=" + this.domainName;
        return this.getAttribute(this.serverName, j2eeDomainName, "serverNames");
    }

    public String[] getAttribute(String domainServerName, String objectName, String attribute) throws ManagementEndpointException {
        try {
            return this.getObjectValue(this.getAttribute(domainServerName, new ObjectName(objectName), attribute));
        }
        catch (Exception e) {
            ManagementEndpointException mex = new ManagementEndpointException();
            mex.setExceptionType(e.getClass().toString());
            mex.setMessage("Problem in getAttribute service call for objectname: " + objectName + " - the request was not completed: " + e.getMessage());
            logger.log(BasicLevel.ERROR, (Object)mex.getMessage(), (Throwable)e);
            throw (ManagementEndpointException)mex.initCause(e);
        }
    }

    public boolean isRegistered(String domainServerName, String objectName) throws ManagementEndpointException {
        try {
            return this.isRegistered(domainServerName, new ObjectName(objectName));
        }
        catch (Exception e) {
            ManagementEndpointException mex = new ManagementEndpointException();
            mex.setExceptionType(e.getClass().toString());
            mex.setMessage("Problem in isRegistered service call for objectname: " + objectName + " - the request was not completed: " + e.getMessage());
            logger.log(BasicLevel.ERROR, (Object)mex.getMessage(), (Throwable)e);
            throw (ManagementEndpointException)mex.initCause(e);
        }
    }

    public String[] queryNames(String domainServerName, String objectName, String query) throws ManagementEndpointException {
        try {
            return this.getObjectValue(this.queryNames(domainServerName, new ObjectName(objectName), null));
        }
        catch (Exception e) {
            ManagementEndpointException mex = new ManagementEndpointException();
            mex.setExceptionType(e.getClass().toString());
            mex.setMessage("Problem in queryNames service call for objectname: " + objectName + " - the request was not completed: " + e.getMessage());
            logger.log(BasicLevel.ERROR, (Object)mex.getMessage(), (Throwable)e);
            throw (ManagementEndpointException)mex.initCause(e);
        }
    }

    public String[] getAttributesList(String domainServerName, String objectName) throws ManagementEndpointException {
        try {
            MBeanInfo info = this.getMBeanInfo(domainServerName, new ObjectName(objectName));
            MBeanAttributeInfo[] attrInfo = info.getAttributes();
            String[] attrs = new String[attrInfo.length];
            for (int i = 0; i < attrs.length; ++i) {
                attrs[i] = attrInfo[i].getName();
            }
            return attrs;
        }
        catch (Exception e) {
            ManagementEndpointException mex = new ManagementEndpointException();
            mex.setExceptionType(e.getClass().toString());
            mex.setMessage("Problem in getAttributeList service call for objectname: " + objectName + " - the request was not completed: " + e.getMessage());
            logger.log(BasicLevel.ERROR, (Object)mex.getMessage(), (Throwable)e);
            throw (ManagementEndpointException)mex.initCause(e);
        }
    }

    public String getDescription(String domainServerName, String objectName) throws ManagementEndpointException {
        try {
            MBeanInfo info = this.getMBeanInfo(domainServerName, new ObjectName(objectName));
            return info.getDescription();
        }
        catch (Exception e) {
            ManagementEndpointException mex = new ManagementEndpointException();
            mex.setExceptionType(e.getClass().toString());
            mex.setMessage("Problem in getDescription service call for objectname: " + objectName + " - the request was not completed: " + e.getMessage());
            logger.log(BasicLevel.ERROR, (Object)mex.getMessage(), (Throwable)e);
            throw (ManagementEndpointException)mex.initCause(e);
        }
    }

    public String[] getOperations(String domainServerName, String objectName) throws ManagementEndpointException {
        try {
            MBeanInfo info = this.getMBeanInfo(domainServerName, new ObjectName(objectName));
            MBeanOperationInfo[] operationInfo = info.getOperations();
            String[] operations = new String[operationInfo.length];
            for (int i = 0; i < operationInfo.length; ++i) {
                operations[i] = operationInfo[i].getName();
            }
            return operations;
        }
        catch (Exception e) {
            ManagementEndpointException mex = new ManagementEndpointException();
            mex.setExceptionType(e.getClass().toString());
            mex.setMessage("Problem in getOperations service call for objectname: " + objectName + " - the request was not completed: " + e.getMessage());
            logger.log(BasicLevel.ERROR, (Object)mex.getMessage(), (Throwable)e);
            throw (ManagementEndpointException)mex.initCause(e);
        }
    }

    public String[] invoke(String domainServerName, String objectName, String operationName, String[] params) throws ManagementEndpointException, RemoteException {
        try {
            String[] signature = new String[params.length];
            for (int i = 0; i < signature.length; ++i) {
                signature[i] = "String";
            }
            return this.getObjectValue(this.invoke(domainServerName, new ObjectName(objectName), operationName, params, signature));
        }
        catch (Exception e) {
            ManagementEndpointException mex = new ManagementEndpointException();
            mex.setExceptionType(e.getClass().toString());
            mex.setMessage("Problem in invoke service call for objectname: " + objectName + " - the request was not completed: " + e.getMessage());
            logger.log(BasicLevel.ERROR, (Object)mex.getMessage(), (Throwable)e);
            throw (ManagementEndpointException)mex.initCause(e);
        }
    }

    private String[] getObjectValue(Object objectValue) {
        String[] value = null;
        if (objectValue == null) {
            value = new String[]{"null"};
        } else if (objectValue.getClass().isArray()) {
            value = this.arrayToString((Object[])objectValue);
        } else {
            try {
                value = this.collectionToString((Collection)objectValue);
            }
            catch (Exception e) {
                value = new String[]{objectValue.toString()};
            }
        }
        return value;
    }

    private String[] arrayToString(Object[] pArray) {
        String[] retStringArr = new String[pArray.length];
        for (int i = 0; i < pArray.length; ++i) {
            retStringArr[i] = pArray[i] == null ? "null" : pArray[i].toString();
        }
        return retStringArr;
    }

    private String[] collectionToString(Collection pCollection) {
        String[] retStringArr = new String[pCollection.size()];
        Iterator it = pCollection.iterator();
        int i = 0;
        while (it.hasNext()) {
            retStringArr[i++] = it.next().toString();
        }
        return retStringArr;
    }
}

