/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.javaee;

import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.ModelMBean;

public class J2EEManagedObject {
    public static final String NAME = "name";
    public static final String J2EE_TYPE_SERVER = "J2EEServer";
    public static final String J2EE_TYPE_APPLICATION = "J2EEApplication";
    private String objectName;
    private boolean stateManageable;
    private boolean statisticsProvider;
    private boolean eventProvider;
    private ModelMBean modelMBean = null;

    protected J2EEManagedObject() {
        this.stateManageable = false;
        this.statisticsProvider = false;
        this.eventProvider = false;
    }

    protected J2EEManagedObject(String objectName) {
        this();
        this.objectName = objectName;
    }

    protected J2EEManagedObject(boolean stateManageable, boolean statisticsProvider, boolean eventProvider) {
        this.stateManageable = stateManageable;
        this.statisticsProvider = statisticsProvider;
        this.eventProvider = eventProvider;
    }

    protected J2EEManagedObject(String objectName, boolean stateManageable, boolean statisticsProvider, boolean eventProvider) {
        this.objectName = objectName;
        this.stateManageable = stateManageable;
        this.statisticsProvider = statisticsProvider;
        this.eventProvider = eventProvider;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setStateManageable(boolean stateManageable) {
        this.stateManageable = stateManageable;
    }

    public void setStatisticsProvider(boolean statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    public void setEventProvider(boolean eventProvider) {
        this.eventProvider = eventProvider;
    }

    public boolean isEventProvider() {
        return this.eventProvider;
    }

    public boolean isStateManageable() {
        return this.stateManageable;
    }

    public boolean isStatisticsProvider() {
        return this.statisticsProvider;
    }

    public void setModelMBean(ModelMBean modelMBean) {
        this.modelMBean = modelMBean;
    }

    public void sendSaveNotification(long sequenceNumber, String resourceName) {
        Notification saveNotif = new Notification("jonas.management.reconfiguration.save", (Object)this.modelMBean, sequenceNumber, resourceName);
        this.sendNotification(saveNotif);
    }

    public void sendReconfigNotification(long sequenceNumber, String resourceName, Object userData) {
        Notification configNotif = new Notification("jonas.management.reconfiguration", (Object)this.modelMBean, sequenceNumber, resourceName);
        configNotif.setUserData(userData);
        this.sendNotification(configNotif);
    }

    protected void sendNotification(Notification notif) {
        try {
            if (this.modelMBean != null) {
                this.modelMBean.sendNotification(notif);
            } else {
                System.out.println("Can't send notification " + notif.toString());
            }
        }
        catch (RuntimeOperationsException e) {
            e.printStackTrace();
        }
        catch (MBeanException e) {
            e.printStackTrace();
        }
    }
}

