/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.security.jacc;

import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Principal;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.security.jacc.JPolicyConfigurationKeeper;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;

public class JPolicyConfiguration
implements PolicyConfiguration {
    private static final int NB_STATES = 3;
    private static final int OPEN = 0;
    private static final int IN_SERVICE = 1;
    private static final int DELETED = 2;
    private static I18n i18n = I18n.getInstance(JPolicyConfiguration.class);
    private static String[] states = null;
    private int state;
    private String contextID = null;
    private static Logger logger = Log.getLogger("org.ow2.jonas.security");
    private PermissionCollection excludedPermissions = null;
    private PermissionCollection uncheckedPermissions = null;
    private Map rolePermissions = null;

    public JPolicyConfiguration(String contextID) {
        this.contextID = contextID;
        if (states == null) {
            states = new String[3];
            JPolicyConfiguration.states[0] = i18n.getMessage("JPolicyConfiguration.openState");
            JPolicyConfiguration.states[1] = i18n.getMessage("JPolicyConfiguration.inServiceState");
            JPolicyConfiguration.states[2] = i18n.getMessage("JPolicyConfiguration.deletedState");
        }
        this.resetState();
        this.excludedPermissions = new Permissions();
        this.uncheckedPermissions = new Permissions();
        this.rolePermissions = new HashMap();
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Adding permission '" + permission + "' as excluded policy."));
        }
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(0);
        if (permission != null) {
            this.excludedPermissions.add(permission);
        }
    }

    public void addToExcludedPolicy(PermissionCollection permissions) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Adding permissions '" + permissions + "' as excluded policy."));
        }
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(0);
        if (permissions != null) {
            Enumeration<Permission> e = permissions.elements();
            while (e.hasMoreElements()) {
                this.excludedPermissions.add(e.nextElement());
            }
        }
    }

    public void addToRole(String roleName, Permission permission) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Adding permission '" + permission + "' to role '" + roleName + "'."));
        }
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(0);
        if (roleName == null) {
            throw new PolicyContextException(i18n.getMessage("JPolicyConfiguration.addToRole"));
        }
        if (permission == null) {
            return;
        }
        PermissionCollection permissionsOfRole = (PermissionCollection)this.rolePermissions.get(roleName);
        if (permissionsOfRole == null) {
            permissionsOfRole = new Permissions();
        }
        permissionsOfRole.add(permission);
        this.rolePermissions.put(roleName, permissionsOfRole);
    }

    public void addToRole(String roleName, PermissionCollection permissions) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Adding permissions '" + permissions + "' to role '" + roleName + "'."));
        }
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(0);
        if (roleName == null) {
            throw new PolicyContextException(i18n.getMessage("JPolicyConfiguration.addToRole"));
        }
        if (permissions == null) {
            return;
        }
        PermissionCollection permissionsOfRole = (PermissionCollection)this.rolePermissions.get(roleName);
        if (permissionsOfRole == null) {
            permissionsOfRole = new Permissions();
        }
        Enumeration<Permission> e = permissions.elements();
        while (e.hasMoreElements()) {
            permissionsOfRole.add(e.nextElement());
        }
        this.rolePermissions.put(roleName, permissionsOfRole);
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Adding permission '" + permission + "' as unchecked policy."));
        }
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(0);
        if (permission != null) {
            this.uncheckedPermissions.add(permission);
        }
    }

    public void addToUncheckedPolicy(PermissionCollection permissions) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Adding permissions '" + permissions + "' as unchecked policy."));
        }
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(0);
        if (permissions != null) {
            Enumeration<Permission> e = permissions.elements();
            while (e.hasMoreElements()) {
                this.uncheckedPermissions.add(e.nextElement());
            }
        }
    }

    public void commit() throws PolicyContextException, SecurityException, UnsupportedOperationException {
        this.checkSetPolicy();
        this.checkCurrentStateNotInState(2);
        this.state = 1;
        JPolicyConfigurationKeeper.addConfiguration(this);
    }

    public void delete() throws PolicyContextException, SecurityException {
        this.checkSetPolicy();
        this.excludedPermissions = new Permissions();
        this.uncheckedPermissions = new Permissions();
        this.rolePermissions = new HashMap();
        this.state = 2;
        JPolicyConfigurationKeeper.removeConfiguration(this);
    }

    public String getContextID() throws PolicyContextException, SecurityException {
        this.checkSetPolicy();
        return this.contextID;
    }

    public boolean inService() throws PolicyContextException, SecurityException {
        this.checkSetPolicy();
        return this.state == 1;
    }

    public void linkConfiguration(PolicyConfiguration link) throws IllegalArgumentException, PolicyContextException, SecurityException, UnsupportedOperationException {
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(0);
        if (this.equals(link)) {
            throw new IllegalArgumentException(i18n.getMessage("JPolicyConfiguration.linkConfiguration.equivalent", this, link));
        }
    }

    public void removeExcludedPolicy() throws PolicyContextException, SecurityException, UnsupportedOperationException {
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(0);
        this.excludedPermissions = new Permissions();
    }

    public void removeRole(String roleName) throws PolicyContextException, SecurityException, UnsupportedOperationException {
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(0);
        this.rolePermissions.remove(roleName);
    }

    public void removeUncheckedPolicy() throws PolicyContextException, SecurityException, UnsupportedOperationException {
        this.checkSetPolicy();
        this.checkCurrentStateIsInState(0);
        this.uncheckedPermissions = new Permissions();
    }

    private void checkCurrentStateNotInState(int s) throws UnsupportedOperationException {
        if (this.state == s) {
            String err = i18n.getMessage("JPolicyConfiguration.checkCurrentStateNotInState.notValidState", states[s], states[this.state]);
            throw new UnsupportedOperationException(err);
        }
    }

    private void checkCurrentStateIsInState(int s) throws UnsupportedOperationException {
        if (this.state != s) {
            String err = i18n.getMessage("JPolicyConfiguration.checkCurrentStateNotInState.notValidState", states[this.state], states[s]);
            throw new UnsupportedOperationException(err);
        }
    }

    private void checkSetPolicy() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PolicyConfiguration)) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)i18n.getMessage("JPolicyConfiguration.equals.notInstanceOf"));
            }
            return false;
        }
        try {
            return this.contextID.equals(((PolicyConfiguration)obj).getContextID());
        }
        catch (PolicyContextException pce) {
            if (logger.isLoggable(BasicLevel.ERROR)) {
                logger.log(BasicLevel.ERROR, (Object)i18n.getMessage("JPolicyConfiguration.equals.canNotCheck", pce.getMessage()));
            }
            return false;
        }
    }

    public int hashCode() {
        return this.contextID.hashCode();
    }

    protected void resetState() {
        this.state = 0;
    }

    public PermissionCollection getExcludedPermissions() {
        if (this.state != 1) {
            return new Permissions();
        }
        return this.excludedPermissions;
    }

    public PermissionCollection getUncheckedPermissions() {
        if (this.state != 1) {
            return new Permissions();
        }
        return this.uncheckedPermissions;
    }

    public PermissionCollection getPermissionsForPrincipal(Principal principal) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("principal = " + principal));
        }
        if (principal == null || this.state != 1) {
            return new Permissions();
        }
        PermissionCollection permissionsOfRole = (PermissionCollection)this.rolePermissions.get(principal.getName());
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Permissions found = " + permissionsOfRole));
        }
        if (permissionsOfRole == null) {
            permissionsOfRole = new Permissions();
        }
        return permissionsOfRole;
    }
}

