/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.work;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.lib.work.DeployerLogException;
import org.ow2.jonas.workcleaner.CleanTask;
import org.ow2.jonas.workcleaner.LogEntry;
import org.ow2.jonas.workcleaner.WorkCleanerException;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbsCleanTask
implements CleanTask {
    private Log logger = LogFactory.getLog(AbsCleanTask.class);

    protected AbsCleanTask() {
    }

    protected abstract boolean isDeployedLogEntry(LogEntry var1) throws WorkCleanerException;

    public abstract DeployerLog getDeployerLog();

    public boolean isValidLogEntry(LogEntry logEntry) throws WorkCleanerException {
        String lastModifiedFileName = null;
        File logEntryFile = logEntry.getOriginal();
        String logEntryUnpackedDir = logEntry.getCopy().getName();
        this.logger.debug("LogEntry <" + logEntryFile.getName() + "> exists :" + logEntryFile.exists(), new Object[0]);
        if (!logEntryFile.exists()) {
            return false;
        }
        try {
            lastModifiedFileName = FileUtils.lastModifiedFileName(logEntryFile);
        }
        catch (FileUtilsException e) {
            this.logger.error("Cannot retrieve the working file name for the deployable '{0}'", logEntryFile);
        }
        this.logger.debug("LogEntry lastModificationFileName :" + lastModifiedFileName, new Object[0]);
        this.logger.debug("LogEntry isValid :" + lastModifiedFileName.equalsIgnoreCase(logEntryUnpackedDir), new Object[0]);
        return lastModifiedFileName.equalsIgnoreCase(logEntryUnpackedDir);
    }

    @Override
    public void execute() throws WorkCleanerException {
        this.logger.debug("Execute called", new Object[0]);
        Vector<LogEntry> logEntries = this.getLogEntries();
        LogEntry logEntry = null;
        Enumeration<LogEntry> e = logEntries.elements();
        while (e.hasMoreElements()) {
            logEntry = e.nextElement();
            this.logger.debug("LogEntry <" + logEntry.getOriginal().getName() + "," + logEntry.getCopy().getName() + ">", new Object[0]);
            if (this.isDeployedLogEntry(logEntry)) {
                this.logger.debug("LogEntry currently deployed - > do nothing", new Object[0]);
                continue;
            }
            if (this.isValidLogEntry(logEntry) || !this.removeLogEntry(logEntry)) continue;
            e = logEntries.elements();
        }
    }

    public boolean removeLogEntry(LogEntry logEntry) throws WorkCleanerException {
        if (FileUtils.delete(logEntry.getCopy())) {
            try {
                this.getDeployerLog().removeEntry(logEntry);
                return true;
            }
            catch (DeployerLogException edle) {
                throw new WorkCleanerException("Can't remove an entry" + edle.getMessage());
            }
        }
        return false;
    }

    public Vector<LogEntry> getLogEntries() {
        return this.getDeployerLog().getEntries();
    }

    protected Log getLogger() {
        return this.logger;
    }
}

